/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PhoneNumberRequest {
    private final Optional<String> phoneNumber;
    private final Optional<String> phoneNumberType;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Map<String, Object> additionalProperties;

    private PhoneNumberRequest(Optional<String> phoneNumber, Optional<String> phoneNumberType, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Map<String, Object> additionalProperties) {
        this.phoneNumber = phoneNumber;
        this.phoneNumberType = phoneNumberType;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="phone_number")
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phone_number_type")
    public Optional<String> getPhoneNumberType() {
        return this.phoneNumberType;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PhoneNumberRequest && this.equalTo((PhoneNumberRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PhoneNumberRequest other) {
        return this.phoneNumber.equals(other.phoneNumber) && this.phoneNumberType.equals(other.phoneNumberType) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams);
    }

    public int hashCode() {
        return Objects.hash(this.phoneNumber, this.phoneNumberType, this.integrationParams, this.linkedAccountParams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<String> phoneNumberType = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PhoneNumberRequest other) {
            this.phoneNumber(other.getPhoneNumber());
            this.phoneNumberType(other.getPhoneNumberType());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            return this;
        }

        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public Builder phoneNumber(Optional<String> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.of(phoneNumber);
            return this;
        }

        @JsonSetter(value="phone_number_type", nulls=Nulls.SKIP)
        public Builder phoneNumberType(Optional<String> phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
            return this;
        }

        public Builder phoneNumberType(String phoneNumberType) {
            this.phoneNumberType = Optional.of(phoneNumberType);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        public PhoneNumberRequest build() {
            return new PhoneNumberRequest(this.phoneNumber, this.phoneNumberType, this.integrationParams, this.linkedAccountParams, this.additionalProperties);
        }
    }
}

