/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.crm.types.SelectiveSyncConfigurationsUsageEnum;
import com.merge.api.resources.crm.types.SyncStatusStatusEnum;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SyncStatus {
    private final String modelName;
    private final String modelId;
    private final Optional<OffsetDateTime> lastSyncStart;
    private final Optional<OffsetDateTime> nextSyncStart;
    private final SyncStatusStatusEnum status;
    private final boolean isInitialSync;
    private final Optional<SelectiveSyncConfigurationsUsageEnum> selectiveSyncConfigurationsUsage;
    private final Map<String, Object> additionalProperties;

    private SyncStatus(String modelName, String modelId, Optional<OffsetDateTime> lastSyncStart, Optional<OffsetDateTime> nextSyncStart, SyncStatusStatusEnum status, boolean isInitialSync, Optional<SelectiveSyncConfigurationsUsageEnum> selectiveSyncConfigurationsUsage, Map<String, Object> additionalProperties) {
        this.modelName = modelName;
        this.modelId = modelId;
        this.lastSyncStart = lastSyncStart;
        this.nextSyncStart = nextSyncStart;
        this.status = status;
        this.isInitialSync = isInitialSync;
        this.selectiveSyncConfigurationsUsage = selectiveSyncConfigurationsUsage;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="model_name")
    public String getModelName() {
        return this.modelName;
    }

    @JsonProperty(value="model_id")
    public String getModelId() {
        return this.modelId;
    }

    @JsonProperty(value="last_sync_start")
    public Optional<OffsetDateTime> getLastSyncStart() {
        return this.lastSyncStart;
    }

    @JsonProperty(value="next_sync_start")
    public Optional<OffsetDateTime> getNextSyncStart() {
        return this.nextSyncStart;
    }

    @JsonProperty(value="status")
    public SyncStatusStatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="is_initial_sync")
    public boolean getIsInitialSync() {
        return this.isInitialSync;
    }

    @JsonProperty(value="selective_sync_configurations_usage")
    public Optional<SelectiveSyncConfigurationsUsageEnum> getSelectiveSyncConfigurationsUsage() {
        return this.selectiveSyncConfigurationsUsage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SyncStatus && this.equalTo((SyncStatus)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SyncStatus other) {
        return this.modelName.equals(other.modelName) && this.modelId.equals(other.modelId) && this.lastSyncStart.equals(other.lastSyncStart) && this.nextSyncStart.equals(other.nextSyncStart) && this.status.equals((Object)other.status) && this.isInitialSync == other.isInitialSync && this.selectiveSyncConfigurationsUsage.equals(other.selectiveSyncConfigurationsUsage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.modelName, this.modelId, this.lastSyncStart, this.nextSyncStart, this.status, this.isInitialSync, this.selectiveSyncConfigurationsUsage});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelNameStage,
    ModelIdStage,
    StatusStage,
    IsInitialSyncStage,
    _FinalStage {
        private String modelName;
        private String modelId;
        private SyncStatusStatusEnum status;
        private boolean isInitialSync;
        private Optional<SelectiveSyncConfigurationsUsageEnum> selectiveSyncConfigurationsUsage = Optional.empty();
        private Optional<OffsetDateTime> nextSyncStart = Optional.empty();
        private Optional<OffsetDateTime> lastSyncStart = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SyncStatus other) {
            this.modelName(other.getModelName());
            this.modelId(other.getModelId());
            this.lastSyncStart(other.getLastSyncStart());
            this.nextSyncStart(other.getNextSyncStart());
            this.status(other.getStatus());
            this.isInitialSync(other.getIsInitialSync());
            this.selectiveSyncConfigurationsUsage(other.getSelectiveSyncConfigurationsUsage());
            return this;
        }

        @Override
        @JsonSetter(value="model_name")
        public ModelIdStage modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        @Override
        @JsonSetter(value="model_id")
        public StatusStage modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public IsInitialSyncStage status(SyncStatusStatusEnum status) {
            this.status = status;
            return this;
        }

        @Override
        @JsonSetter(value="is_initial_sync")
        public _FinalStage isInitialSync(boolean isInitialSync) {
            this.isInitialSync = isInitialSync;
            return this;
        }

        @Override
        public _FinalStage selectiveSyncConfigurationsUsage(SelectiveSyncConfigurationsUsageEnum selectiveSyncConfigurationsUsage) {
            this.selectiveSyncConfigurationsUsage = Optional.of(selectiveSyncConfigurationsUsage);
            return this;
        }

        @Override
        @JsonSetter(value="selective_sync_configurations_usage", nulls=Nulls.SKIP)
        public _FinalStage selectiveSyncConfigurationsUsage(Optional<SelectiveSyncConfigurationsUsageEnum> selectiveSyncConfigurationsUsage) {
            this.selectiveSyncConfigurationsUsage = selectiveSyncConfigurationsUsage;
            return this;
        }

        @Override
        public _FinalStage nextSyncStart(OffsetDateTime nextSyncStart) {
            this.nextSyncStart = Optional.of(nextSyncStart);
            return this;
        }

        @Override
        @JsonSetter(value="next_sync_start", nulls=Nulls.SKIP)
        public _FinalStage nextSyncStart(Optional<OffsetDateTime> nextSyncStart) {
            this.nextSyncStart = nextSyncStart;
            return this;
        }

        @Override
        public _FinalStage lastSyncStart(OffsetDateTime lastSyncStart) {
            this.lastSyncStart = Optional.of(lastSyncStart);
            return this;
        }

        @Override
        @JsonSetter(value="last_sync_start", nulls=Nulls.SKIP)
        public _FinalStage lastSyncStart(Optional<OffsetDateTime> lastSyncStart) {
            this.lastSyncStart = lastSyncStart;
            return this;
        }

        @Override
        public SyncStatus build() {
            return new SyncStatus(this.modelName, this.modelId, this.lastSyncStart, this.nextSyncStart, this.status, this.isInitialSync, this.selectiveSyncConfigurationsUsage, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SyncStatus build();

        public _FinalStage lastSyncStart(Optional<OffsetDateTime> var1);

        public _FinalStage lastSyncStart(OffsetDateTime var1);

        public _FinalStage nextSyncStart(Optional<OffsetDateTime> var1);

        public _FinalStage nextSyncStart(OffsetDateTime var1);

        public _FinalStage selectiveSyncConfigurationsUsage(Optional<SelectiveSyncConfigurationsUsageEnum> var1);

        public _FinalStage selectiveSyncConfigurationsUsage(SelectiveSyncConfigurationsUsageEnum var1);
    }

    public static interface IsInitialSyncStage {
        public _FinalStage isInitialSync(boolean var1);
    }

    public static interface StatusStage {
        public IsInitialSyncStage status(SyncStatusStatusEnum var1);
    }

    public static interface ModelIdStage {
        public StatusStage modelId(String var1);
    }

    public static interface ModelNameStage {
        public ModelIdStage modelName(String var1);

        public Builder from(SyncStatus var1);
    }
}

