/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.crm.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.crm.types.RemoteFieldRequest;
import com.merge.api.resources.crm.types.TaskRequestAccount;
import com.merge.api.resources.crm.types.TaskRequestOpportunity;
import com.merge.api.resources.crm.types.TaskRequestOwner;
import com.merge.api.resources.crm.types.TaskRequestStatus;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class TaskRequest {
    private final Optional<String> subject;
    private final Optional<String> content;
    private final Optional<TaskRequestOwner> owner;
    private final Optional<TaskRequestAccount> account;
    private final Optional<TaskRequestOpportunity> opportunity;
    private final Optional<OffsetDateTime> completedDate;
    private final Optional<OffsetDateTime> dueDate;
    private final Optional<TaskRequestStatus> status;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Optional<List<RemoteFieldRequest>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private TaskRequest(Optional<String> subject, Optional<String> content, Optional<TaskRequestOwner> owner, Optional<TaskRequestAccount> account, Optional<TaskRequestOpportunity> opportunity, Optional<OffsetDateTime> completedDate, Optional<OffsetDateTime> dueDate, Optional<TaskRequestStatus> status, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Optional<List<RemoteFieldRequest>> remoteFields, Map<String, Object> additionalProperties) {
        this.subject = subject;
        this.content = content;
        this.owner = owner;
        this.account = account;
        this.opportunity = opportunity;
        this.completedDate = completedDate;
        this.dueDate = dueDate;
        this.status = status;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="subject")
    public Optional<String> getSubject() {
        return this.subject;
    }

    @JsonProperty(value="content")
    public Optional<String> getContent() {
        return this.content;
    }

    @JsonProperty(value="owner")
    public Optional<TaskRequestOwner> getOwner() {
        return this.owner;
    }

    @JsonProperty(value="account")
    public Optional<TaskRequestAccount> getAccount() {
        return this.account;
    }

    @JsonProperty(value="opportunity")
    public Optional<TaskRequestOpportunity> getOpportunity() {
        return this.opportunity;
    }

    @JsonProperty(value="completed_date")
    public Optional<OffsetDateTime> getCompletedDate() {
        return this.completedDate;
    }

    @JsonProperty(value="due_date")
    public Optional<OffsetDateTime> getDueDate() {
        return this.dueDate;
    }

    @JsonProperty(value="status")
    public Optional<TaskRequestStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteFieldRequest>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TaskRequest && this.equalTo((TaskRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TaskRequest other) {
        return this.subject.equals(other.subject) && this.content.equals(other.content) && this.owner.equals(other.owner) && this.account.equals(other.account) && this.opportunity.equals(other.opportunity) && this.completedDate.equals(other.completedDate) && this.dueDate.equals(other.dueDate) && this.status.equals(other.status) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.content, this.owner, this.account, this.opportunity, this.completedDate, this.dueDate, this.status, this.integrationParams, this.linkedAccountParams, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> subject = Optional.empty();
        private Optional<String> content = Optional.empty();
        private Optional<TaskRequestOwner> owner = Optional.empty();
        private Optional<TaskRequestAccount> account = Optional.empty();
        private Optional<TaskRequestOpportunity> opportunity = Optional.empty();
        private Optional<OffsetDateTime> completedDate = Optional.empty();
        private Optional<OffsetDateTime> dueDate = Optional.empty();
        private Optional<TaskRequestStatus> status = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        private Optional<List<RemoteFieldRequest>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TaskRequest other) {
            this.subject(other.getSubject());
            this.content(other.getContent());
            this.owner(other.getOwner());
            this.account(other.getAccount());
            this.opportunity(other.getOpportunity());
            this.completedDate(other.getCompletedDate());
            this.dueDate(other.getDueDate());
            this.status(other.getStatus());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="subject", nulls=Nulls.SKIP)
        public Builder subject(Optional<String> subject) {
            this.subject = subject;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = Optional.of(subject);
            return this;
        }

        @JsonSetter(value="content", nulls=Nulls.SKIP)
        public Builder content(Optional<String> content) {
            this.content = content;
            return this;
        }

        public Builder content(String content) {
            this.content = Optional.of(content);
            return this;
        }

        @JsonSetter(value="owner", nulls=Nulls.SKIP)
        public Builder owner(Optional<TaskRequestOwner> owner) {
            this.owner = owner;
            return this;
        }

        public Builder owner(TaskRequestOwner owner) {
            this.owner = Optional.of(owner);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<TaskRequestAccount> account) {
            this.account = account;
            return this;
        }

        public Builder account(TaskRequestAccount account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="opportunity", nulls=Nulls.SKIP)
        public Builder opportunity(Optional<TaskRequestOpportunity> opportunity) {
            this.opportunity = opportunity;
            return this;
        }

        public Builder opportunity(TaskRequestOpportunity opportunity) {
            this.opportunity = Optional.of(opportunity);
            return this;
        }

        @JsonSetter(value="completed_date", nulls=Nulls.SKIP)
        public Builder completedDate(Optional<OffsetDateTime> completedDate) {
            this.completedDate = completedDate;
            return this;
        }

        public Builder completedDate(OffsetDateTime completedDate) {
            this.completedDate = Optional.of(completedDate);
            return this;
        }

        @JsonSetter(value="due_date", nulls=Nulls.SKIP)
        public Builder dueDate(Optional<OffsetDateTime> dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public Builder dueDate(OffsetDateTime dueDate) {
            this.dueDate = Optional.of(dueDate);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<TaskRequestStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(TaskRequestStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteFieldRequest>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteFieldRequest> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public TaskRequest build() {
            return new TaskRequest(this.subject, this.content, this.owner, this.account, this.opportunity, this.completedDate, this.dueDate, this.status, this.integrationParams, this.linkedAccountParams, this.remoteFields, this.additionalProperties);
        }
    }
}

