/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.filestorage.files.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class FilesDownloadRetrieveRequest {
    private final Optional<String> mimeType;
    private final Map<String, Object> additionalProperties;

    private FilesDownloadRetrieveRequest(Optional<String> mimeType, Map<String, Object> additionalProperties) {
        this.mimeType = mimeType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="mime_type")
    public Optional<String> getMimeType() {
        return this.mimeType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FilesDownloadRetrieveRequest && this.equalTo((FilesDownloadRetrieveRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FilesDownloadRetrieveRequest other) {
        return this.mimeType.equals(other.mimeType);
    }

    public int hashCode() {
        return Objects.hash(this.mimeType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> mimeType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(FilesDownloadRetrieveRequest other) {
            this.mimeType(other.getMimeType());
            return this;
        }

        @JsonSetter(value="mime_type", nulls=Nulls.SKIP)
        public Builder mimeType(Optional<String> mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = Optional.of(mimeType);
            return this;
        }

        public FilesDownloadRetrieveRequest build() {
            return new FilesDownloadRetrieveRequest(this.mimeType, this.additionalProperties);
        }
    }
}

