/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.filestorage.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.filestorage.types.AccountDetailsAndActionsIntegration;
import com.merge.api.resources.filestorage.types.AccountDetailsAndActionsStatusEnum;
import com.merge.api.resources.filestorage.types.CategoryEnum;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AccountDetailsAndActions {
    private final String id;
    private final Optional<CategoryEnum> category;
    private final AccountDetailsAndActionsStatusEnum status;
    private final Optional<String> statusDetail;
    private final Optional<String> endUserOriginId;
    private final String endUserOrganizationName;
    private final String endUserEmailAddress;
    private final Optional<String> subdomain;
    private final String webhookListenerUrl;
    private final Optional<Boolean> isDuplicate;
    private final Optional<AccountDetailsAndActionsIntegration> integration;
    private final String accountType;
    private final OffsetDateTime completedAt;
    private final Map<String, Object> additionalProperties;

    private AccountDetailsAndActions(String id, Optional<CategoryEnum> category, AccountDetailsAndActionsStatusEnum status, Optional<String> statusDetail, Optional<String> endUserOriginId, String endUserOrganizationName, String endUserEmailAddress, Optional<String> subdomain, String webhookListenerUrl, Optional<Boolean> isDuplicate, Optional<AccountDetailsAndActionsIntegration> integration, String accountType, OffsetDateTime completedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.category = category;
        this.status = status;
        this.statusDetail = statusDetail;
        this.endUserOriginId = endUserOriginId;
        this.endUserOrganizationName = endUserOrganizationName;
        this.endUserEmailAddress = endUserEmailAddress;
        this.subdomain = subdomain;
        this.webhookListenerUrl = webhookListenerUrl;
        this.isDuplicate = isDuplicate;
        this.integration = integration;
        this.accountType = accountType;
        this.completedAt = completedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="category")
    public Optional<CategoryEnum> getCategory() {
        return this.category;
    }

    @JsonProperty(value="status")
    public AccountDetailsAndActionsStatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status_detail")
    public Optional<String> getStatusDetail() {
        return this.statusDetail;
    }

    @JsonProperty(value="end_user_origin_id")
    public Optional<String> getEndUserOriginId() {
        return this.endUserOriginId;
    }

    @JsonProperty(value="end_user_organization_name")
    public String getEndUserOrganizationName() {
        return this.endUserOrganizationName;
    }

    @JsonProperty(value="end_user_email_address")
    public String getEndUserEmailAddress() {
        return this.endUserEmailAddress;
    }

    @JsonProperty(value="subdomain")
    public Optional<String> getSubdomain() {
        return this.subdomain;
    }

    @JsonProperty(value="webhook_listener_url")
    public String getWebhookListenerUrl() {
        return this.webhookListenerUrl;
    }

    @JsonProperty(value="is_duplicate")
    public Optional<Boolean> getIsDuplicate() {
        return this.isDuplicate;
    }

    @JsonProperty(value="integration")
    public Optional<AccountDetailsAndActionsIntegration> getIntegration() {
        return this.integration;
    }

    @JsonProperty(value="account_type")
    public String getAccountType() {
        return this.accountType;
    }

    @JsonProperty(value="completed_at")
    public OffsetDateTime getCompletedAt() {
        return this.completedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccountDetailsAndActions && this.equalTo((AccountDetailsAndActions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AccountDetailsAndActions other) {
        return this.id.equals(other.id) && this.category.equals(other.category) && this.status.equals((Object)other.status) && this.statusDetail.equals(other.statusDetail) && this.endUserOriginId.equals(other.endUserOriginId) && this.endUserOrganizationName.equals(other.endUserOrganizationName) && this.endUserEmailAddress.equals(other.endUserEmailAddress) && this.subdomain.equals(other.subdomain) && this.webhookListenerUrl.equals(other.webhookListenerUrl) && this.isDuplicate.equals(other.isDuplicate) && this.integration.equals(other.integration) && this.accountType.equals(other.accountType) && this.completedAt.equals(other.completedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.category, this.status, this.statusDetail, this.endUserOriginId, this.endUserOrganizationName, this.endUserEmailAddress, this.subdomain, this.webhookListenerUrl, this.isDuplicate, this.integration, this.accountType, this.completedAt});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    StatusStage,
    EndUserOrganizationNameStage,
    EndUserEmailAddressStage,
    WebhookListenerUrlStage,
    AccountTypeStage,
    CompletedAtStage,
    _FinalStage {
        private String id;
        private AccountDetailsAndActionsStatusEnum status;
        private String endUserOrganizationName;
        private String endUserEmailAddress;
        private String webhookListenerUrl;
        private String accountType;
        private OffsetDateTime completedAt;
        private Optional<AccountDetailsAndActionsIntegration> integration = Optional.empty();
        private Optional<Boolean> isDuplicate = Optional.empty();
        private Optional<String> subdomain = Optional.empty();
        private Optional<String> endUserOriginId = Optional.empty();
        private Optional<String> statusDetail = Optional.empty();
        private Optional<CategoryEnum> category = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AccountDetailsAndActions other) {
            this.id(other.getId());
            this.category(other.getCategory());
            this.status(other.getStatus());
            this.statusDetail(other.getStatusDetail());
            this.endUserOriginId(other.getEndUserOriginId());
            this.endUserOrganizationName(other.getEndUserOrganizationName());
            this.endUserEmailAddress(other.getEndUserEmailAddress());
            this.subdomain(other.getSubdomain());
            this.webhookListenerUrl(other.getWebhookListenerUrl());
            this.isDuplicate(other.getIsDuplicate());
            this.integration(other.getIntegration());
            this.accountType(other.getAccountType());
            this.completedAt(other.getCompletedAt());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public StatusStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public EndUserOrganizationNameStage status(AccountDetailsAndActionsStatusEnum status) {
            this.status = status;
            return this;
        }

        @Override
        @JsonSetter(value="end_user_organization_name")
        public EndUserEmailAddressStage endUserOrganizationName(String endUserOrganizationName) {
            this.endUserOrganizationName = endUserOrganizationName;
            return this;
        }

        @Override
        @JsonSetter(value="end_user_email_address")
        public WebhookListenerUrlStage endUserEmailAddress(String endUserEmailAddress) {
            this.endUserEmailAddress = endUserEmailAddress;
            return this;
        }

        @Override
        @JsonSetter(value="webhook_listener_url")
        public AccountTypeStage webhookListenerUrl(String webhookListenerUrl) {
            this.webhookListenerUrl = webhookListenerUrl;
            return this;
        }

        @Override
        @JsonSetter(value="account_type")
        public CompletedAtStage accountType(String accountType) {
            this.accountType = accountType;
            return this;
        }

        @Override
        @JsonSetter(value="completed_at")
        public _FinalStage completedAt(OffsetDateTime completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        @Override
        public _FinalStage integration(AccountDetailsAndActionsIntegration integration) {
            this.integration = Optional.of(integration);
            return this;
        }

        @Override
        @JsonSetter(value="integration", nulls=Nulls.SKIP)
        public _FinalStage integration(Optional<AccountDetailsAndActionsIntegration> integration) {
            this.integration = integration;
            return this;
        }

        @Override
        public _FinalStage isDuplicate(Boolean isDuplicate) {
            this.isDuplicate = Optional.of(isDuplicate);
            return this;
        }

        @Override
        @JsonSetter(value="is_duplicate", nulls=Nulls.SKIP)
        public _FinalStage isDuplicate(Optional<Boolean> isDuplicate) {
            this.isDuplicate = isDuplicate;
            return this;
        }

        @Override
        public _FinalStage subdomain(String subdomain) {
            this.subdomain = Optional.of(subdomain);
            return this;
        }

        @Override
        @JsonSetter(value="subdomain", nulls=Nulls.SKIP)
        public _FinalStage subdomain(Optional<String> subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        @Override
        public _FinalStage endUserOriginId(String endUserOriginId) {
            this.endUserOriginId = Optional.of(endUserOriginId);
            return this;
        }

        @Override
        @JsonSetter(value="end_user_origin_id", nulls=Nulls.SKIP)
        public _FinalStage endUserOriginId(Optional<String> endUserOriginId) {
            this.endUserOriginId = endUserOriginId;
            return this;
        }

        @Override
        public _FinalStage statusDetail(String statusDetail) {
            this.statusDetail = Optional.of(statusDetail);
            return this;
        }

        @Override
        @JsonSetter(value="status_detail", nulls=Nulls.SKIP)
        public _FinalStage statusDetail(Optional<String> statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        @Override
        public _FinalStage category(CategoryEnum category) {
            this.category = Optional.of(category);
            return this;
        }

        @Override
        @JsonSetter(value="category", nulls=Nulls.SKIP)
        public _FinalStage category(Optional<CategoryEnum> category) {
            this.category = category;
            return this;
        }

        @Override
        public AccountDetailsAndActions build() {
            return new AccountDetailsAndActions(this.id, this.category, this.status, this.statusDetail, this.endUserOriginId, this.endUserOrganizationName, this.endUserEmailAddress, this.subdomain, this.webhookListenerUrl, this.isDuplicate, this.integration, this.accountType, this.completedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AccountDetailsAndActions build();

        public _FinalStage category(Optional<CategoryEnum> var1);

        public _FinalStage category(CategoryEnum var1);

        public _FinalStage statusDetail(Optional<String> var1);

        public _FinalStage statusDetail(String var1);

        public _FinalStage endUserOriginId(Optional<String> var1);

        public _FinalStage endUserOriginId(String var1);

        public _FinalStage subdomain(Optional<String> var1);

        public _FinalStage subdomain(String var1);

        public _FinalStage isDuplicate(Optional<Boolean> var1);

        public _FinalStage isDuplicate(Boolean var1);

        public _FinalStage integration(Optional<AccountDetailsAndActionsIntegration> var1);

        public _FinalStage integration(AccountDetailsAndActionsIntegration var1);
    }

    public static interface CompletedAtStage {
        public _FinalStage completedAt(OffsetDateTime var1);
    }

    public static interface AccountTypeStage {
        public CompletedAtStage accountType(String var1);
    }

    public static interface WebhookListenerUrlStage {
        public AccountTypeStage webhookListenerUrl(String var1);
    }

    public static interface EndUserEmailAddressStage {
        public WebhookListenerUrlStage endUserEmailAddress(String var1);
    }

    public static interface EndUserOrganizationNameStage {
        public EndUserEmailAddressStage endUserOrganizationName(String var1);
    }

    public static interface StatusStage {
        public EndUserOrganizationNameStage status(AccountDetailsAndActionsStatusEnum var1);
    }

    public static interface IdStage {
        public StatusStage id(String var1);

        public Builder from(AccountDetailsAndActions var1);
    }
}

