/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.filestorage.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.filestorage.types.AuditLogEventEventType;
import com.merge.api.resources.filestorage.types.AuditLogEventRole;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AuditLogEvent {
    private final Optional<String> id;
    private final Optional<String> userName;
    private final Optional<String> userEmail;
    private final AuditLogEventRole role;
    private final String ipAddress;
    private final AuditLogEventEventType eventType;
    private final String eventDescription;
    private final Optional<OffsetDateTime> createdAt;
    private final Map<String, Object> additionalProperties;

    private AuditLogEvent(Optional<String> id, Optional<String> userName, Optional<String> userEmail, AuditLogEventRole role, String ipAddress, AuditLogEventEventType eventType, String eventDescription, Optional<OffsetDateTime> createdAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.userName = userName;
        this.userEmail = userEmail;
        this.role = role;
        this.ipAddress = ipAddress;
        this.eventType = eventType;
        this.eventDescription = eventDescription;
        this.createdAt = createdAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="user_name")
    public Optional<String> getUserName() {
        return this.userName;
    }

    @JsonProperty(value="user_email")
    public Optional<String> getUserEmail() {
        return this.userEmail;
    }

    @JsonProperty(value="role")
    public AuditLogEventRole getRole() {
        return this.role;
    }

    @JsonProperty(value="ip_address")
    public String getIpAddress() {
        return this.ipAddress;
    }

    @JsonProperty(value="event_type")
    public AuditLogEventEventType getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="event_description")
    public String getEventDescription() {
        return this.eventDescription;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AuditLogEvent && this.equalTo((AuditLogEvent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AuditLogEvent other) {
        return this.id.equals(other.id) && this.userName.equals(other.userName) && this.userEmail.equals(other.userEmail) && this.role.equals(other.role) && this.ipAddress.equals(other.ipAddress) && this.eventType.equals(other.eventType) && this.eventDescription.equals(other.eventDescription) && this.createdAt.equals(other.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userName, this.userEmail, this.role, this.ipAddress, this.eventType, this.eventDescription, this.createdAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RoleStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RoleStage,
    IpAddressStage,
    EventTypeStage,
    EventDescriptionStage,
    _FinalStage {
        private AuditLogEventRole role;
        private String ipAddress;
        private AuditLogEventEventType eventType;
        private String eventDescription;
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<String> userEmail = Optional.empty();
        private Optional<String> userName = Optional.empty();
        private Optional<String> id = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AuditLogEvent other) {
            this.id(other.getId());
            this.userName(other.getUserName());
            this.userEmail(other.getUserEmail());
            this.role(other.getRole());
            this.ipAddress(other.getIpAddress());
            this.eventType(other.getEventType());
            this.eventDescription(other.getEventDescription());
            this.createdAt(other.getCreatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="role")
        public IpAddressStage role(AuditLogEventRole role) {
            this.role = role;
            return this;
        }

        @Override
        @JsonSetter(value="ip_address")
        public EventTypeStage ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        @Override
        @JsonSetter(value="event_type")
        public EventDescriptionStage eventType(AuditLogEventEventType eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        @JsonSetter(value="event_description")
        public _FinalStage eventDescription(String eventDescription) {
            this.eventDescription = eventDescription;
            return this;
        }

        @Override
        public _FinalStage createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage userEmail(String userEmail) {
            this.userEmail = Optional.of(userEmail);
            return this;
        }

        @Override
        @JsonSetter(value="user_email", nulls=Nulls.SKIP)
        public _FinalStage userEmail(Optional<String> userEmail) {
            this.userEmail = userEmail;
            return this;
        }

        @Override
        public _FinalStage userName(String userName) {
            this.userName = Optional.of(userName);
            return this;
        }

        @Override
        @JsonSetter(value="user_name", nulls=Nulls.SKIP)
        public _FinalStage userName(Optional<String> userName) {
            this.userName = userName;
            return this;
        }

        @Override
        public _FinalStage id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @Override
        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @Override
        public AuditLogEvent build() {
            return new AuditLogEvent(this.id, this.userName, this.userEmail, this.role, this.ipAddress, this.eventType, this.eventDescription, this.createdAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AuditLogEvent build();

        public _FinalStage id(Optional<String> var1);

        public _FinalStage id(String var1);

        public _FinalStage userName(Optional<String> var1);

        public _FinalStage userName(String var1);

        public _FinalStage userEmail(Optional<String> var1);

        public _FinalStage userEmail(String var1);

        public _FinalStage createdAt(Optional<OffsetDateTime> var1);

        public _FinalStage createdAt(OffsetDateTime var1);
    }

    public static interface EventDescriptionStage {
        public _FinalStage eventDescription(String var1);
    }

    public static interface EventTypeStage {
        public EventDescriptionStage eventType(AuditLogEventEventType var1);
    }

    public static interface IpAddressStage {
        public EventTypeStage ipAddress(String var1);
    }

    public static interface RoleStage {
        public IpAddressStage role(AuditLogEventRole var1);

        public Builder from(AuditLogEvent var1);
    }
}

