/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.filestorage.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.filestorage.types.ExternalTargetFieldApi;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ExternalTargetFieldApiResponse {
    private final Optional<List<ExternalTargetFieldApi>> file;
    private final Optional<List<ExternalTargetFieldApi>> folder;
    private final Optional<List<ExternalTargetFieldApi>> drive;
    private final Optional<List<ExternalTargetFieldApi>> group;
    private final Optional<List<ExternalTargetFieldApi>> user;
    private final Map<String, Object> additionalProperties;

    private ExternalTargetFieldApiResponse(Optional<List<ExternalTargetFieldApi>> file, Optional<List<ExternalTargetFieldApi>> folder, Optional<List<ExternalTargetFieldApi>> drive, Optional<List<ExternalTargetFieldApi>> group, Optional<List<ExternalTargetFieldApi>> user, Map<String, Object> additionalProperties) {
        this.file = file;
        this.folder = folder;
        this.drive = drive;
        this.group = group;
        this.user = user;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="File")
    public Optional<List<ExternalTargetFieldApi>> getFile() {
        return this.file;
    }

    @JsonProperty(value="Folder")
    public Optional<List<ExternalTargetFieldApi>> getFolder() {
        return this.folder;
    }

    @JsonProperty(value="Drive")
    public Optional<List<ExternalTargetFieldApi>> getDrive() {
        return this.drive;
    }

    @JsonProperty(value="Group")
    public Optional<List<ExternalTargetFieldApi>> getGroup() {
        return this.group;
    }

    @JsonProperty(value="User")
    public Optional<List<ExternalTargetFieldApi>> getUser() {
        return this.user;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExternalTargetFieldApiResponse && this.equalTo((ExternalTargetFieldApiResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ExternalTargetFieldApiResponse other) {
        return this.file.equals(other.file) && this.folder.equals(other.folder) && this.drive.equals(other.drive) && this.group.equals(other.group) && this.user.equals(other.user);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.folder, this.drive, this.group, this.user);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<List<ExternalTargetFieldApi>> file = Optional.empty();
        private Optional<List<ExternalTargetFieldApi>> folder = Optional.empty();
        private Optional<List<ExternalTargetFieldApi>> drive = Optional.empty();
        private Optional<List<ExternalTargetFieldApi>> group = Optional.empty();
        private Optional<List<ExternalTargetFieldApi>> user = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ExternalTargetFieldApiResponse other) {
            this.file(other.getFile());
            this.folder(other.getFolder());
            this.drive(other.getDrive());
            this.group(other.getGroup());
            this.user(other.getUser());
            return this;
        }

        @JsonSetter(value="File", nulls=Nulls.SKIP)
        public Builder file(Optional<List<ExternalTargetFieldApi>> file) {
            this.file = file;
            return this;
        }

        public Builder file(List<ExternalTargetFieldApi> file) {
            this.file = Optional.of(file);
            return this;
        }

        @JsonSetter(value="Folder", nulls=Nulls.SKIP)
        public Builder folder(Optional<List<ExternalTargetFieldApi>> folder) {
            this.folder = folder;
            return this;
        }

        public Builder folder(List<ExternalTargetFieldApi> folder) {
            this.folder = Optional.of(folder);
            return this;
        }

        @JsonSetter(value="Drive", nulls=Nulls.SKIP)
        public Builder drive(Optional<List<ExternalTargetFieldApi>> drive) {
            this.drive = drive;
            return this;
        }

        public Builder drive(List<ExternalTargetFieldApi> drive) {
            this.drive = Optional.of(drive);
            return this;
        }

        @JsonSetter(value="Group", nulls=Nulls.SKIP)
        public Builder group(Optional<List<ExternalTargetFieldApi>> group) {
            this.group = group;
            return this;
        }

        public Builder group(List<ExternalTargetFieldApi> group) {
            this.group = Optional.of(group);
            return this;
        }

        @JsonSetter(value="User", nulls=Nulls.SKIP)
        public Builder user(Optional<List<ExternalTargetFieldApi>> user) {
            this.user = user;
            return this;
        }

        public Builder user(List<ExternalTargetFieldApi> user) {
            this.user = Optional.of(user);
            return this;
        }

        public ExternalTargetFieldApiResponse build() {
            return new ExternalTargetFieldApiResponse(this.file, this.folder, this.drive, this.group, this.user, this.additionalProperties);
        }
    }
}

