/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.filestorage.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.filestorage.types.FolderDrive;
import com.merge.api.resources.filestorage.types.FolderParentFolder;
import com.merge.api.resources.filestorage.types.FolderPermissions;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Folder {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> name;
    private final Optional<String> folderUrl;
    private final Optional<Long> size;
    private final Optional<String> description;
    private final Optional<FolderParentFolder> parentFolder;
    private final Optional<FolderDrive> drive;
    private final Optional<FolderPermissions> permissions;
    private final Optional<OffsetDateTime> remoteCreatedAt;
    private final Optional<OffsetDateTime> remoteUpdatedAt;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<Optional<Map<String, JsonNode>>>> remoteData;
    private final Map<String, Object> additionalProperties;

    private Folder(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> name, Optional<String> folderUrl, Optional<Long> size, Optional<String> description, Optional<FolderParentFolder> parentFolder, Optional<FolderDrive> drive, Optional<FolderPermissions> permissions, Optional<OffsetDateTime> remoteCreatedAt, Optional<OffsetDateTime> remoteUpdatedAt, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<Optional<Map<String, JsonNode>>>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.name = name;
        this.folderUrl = folderUrl;
        this.size = size;
        this.description = description;
        this.parentFolder = parentFolder;
        this.drive = drive;
        this.permissions = permissions;
        this.remoteCreatedAt = remoteCreatedAt;
        this.remoteUpdatedAt = remoteUpdatedAt;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="folder_url")
    public Optional<String> getFolderUrl() {
        return this.folderUrl;
    }

    @JsonProperty(value="size")
    public Optional<Long> getSize() {
        return this.size;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="parent_folder")
    public Optional<FolderParentFolder> getParentFolder() {
        return this.parentFolder;
    }

    @JsonProperty(value="drive")
    public Optional<FolderDrive> getDrive() {
        return this.drive;
    }

    @JsonProperty(value="permissions")
    public Optional<FolderPermissions> getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<OffsetDateTime> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="remote_updated_at")
    public Optional<OffsetDateTime> getRemoteUpdatedAt() {
        return this.remoteUpdatedAt;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<Optional<Map<String, JsonNode>>>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Folder && this.equalTo((Folder)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Folder other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.name.equals(other.name) && this.folderUrl.equals(other.folderUrl) && this.size.equals(other.size) && this.description.equals(other.description) && this.parentFolder.equals(other.parentFolder) && this.drive.equals(other.drive) && this.permissions.equals(other.permissions) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.remoteUpdatedAt.equals(other.remoteUpdatedAt) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.folderUrl, this.size, this.description, this.parentFolder, this.drive, this.permissions, this.remoteCreatedAt, this.remoteUpdatedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> folderUrl = Optional.empty();
        private Optional<Long> size = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<FolderParentFolder> parentFolder = Optional.empty();
        private Optional<FolderDrive> drive = Optional.empty();
        private Optional<FolderPermissions> permissions = Optional.empty();
        private Optional<OffsetDateTime> remoteCreatedAt = Optional.empty();
        private Optional<OffsetDateTime> remoteUpdatedAt = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<Optional<Map<String, JsonNode>>>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Folder other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.name(other.getName());
            this.folderUrl(other.getFolderUrl());
            this.size(other.getSize());
            this.description(other.getDescription());
            this.parentFolder(other.getParentFolder());
            this.drive(other.getDrive());
            this.permissions(other.getPermissions());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.remoteUpdatedAt(other.getRemoteUpdatedAt());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="folder_url", nulls=Nulls.SKIP)
        public Builder folderUrl(Optional<String> folderUrl) {
            this.folderUrl = folderUrl;
            return this;
        }

        public Builder folderUrl(String folderUrl) {
            this.folderUrl = Optional.of(folderUrl);
            return this;
        }

        @JsonSetter(value="size", nulls=Nulls.SKIP)
        public Builder size(Optional<Long> size) {
            this.size = size;
            return this;
        }

        public Builder size(Long size) {
            this.size = Optional.of(size);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="parent_folder", nulls=Nulls.SKIP)
        public Builder parentFolder(Optional<FolderParentFolder> parentFolder) {
            this.parentFolder = parentFolder;
            return this;
        }

        public Builder parentFolder(FolderParentFolder parentFolder) {
            this.parentFolder = Optional.of(parentFolder);
            return this;
        }

        @JsonSetter(value="drive", nulls=Nulls.SKIP)
        public Builder drive(Optional<FolderDrive> drive) {
            this.drive = drive;
            return this;
        }

        public Builder drive(FolderDrive drive) {
            this.drive = Optional.of(drive);
            return this;
        }

        @JsonSetter(value="permissions", nulls=Nulls.SKIP)
        public Builder permissions(Optional<FolderPermissions> permissions) {
            this.permissions = permissions;
            return this;
        }

        public Builder permissions(FolderPermissions permissions) {
            this.permissions = Optional.of(permissions);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<OffsetDateTime> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(OffsetDateTime remoteCreatedAt) {
            this.remoteCreatedAt = Optional.of(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="remote_updated_at", nulls=Nulls.SKIP)
        public Builder remoteUpdatedAt(Optional<OffsetDateTime> remoteUpdatedAt) {
            this.remoteUpdatedAt = remoteUpdatedAt;
            return this;
        }

        public Builder remoteUpdatedAt(OffsetDateTime remoteUpdatedAt) {
            this.remoteUpdatedAt = Optional.of(remoteUpdatedAt);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<Optional<Map<String, JsonNode>>>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<Optional<Map<String, JsonNode>>> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public Folder build() {
            return new Folder(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.folderUrl, this.size, this.description, this.parentFolder, this.drive, this.permissions, this.remoteCreatedAt, this.remoteUpdatedAt, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

