/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.filestorage.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.filestorage.types.PermissionGroup;
import com.merge.api.resources.filestorage.types.PermissionRolesItem;
import com.merge.api.resources.filestorage.types.PermissionType;
import com.merge.api.resources.filestorage.types.PermissionUser;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Permission {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<PermissionUser> user;
    private final Optional<PermissionGroup> group;
    private final Optional<PermissionType> type;
    private final Optional<List<Optional<PermissionRolesItem>>> roles;
    private final Map<String, Object> additionalProperties;

    private Permission(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<PermissionUser> user, Optional<PermissionGroup> group, Optional<PermissionType> type, Optional<List<Optional<PermissionRolesItem>>> roles, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.user = user;
        this.group = group;
        this.type = type;
        this.roles = roles;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="user")
    public Optional<PermissionUser> getUser() {
        return this.user;
    }

    @JsonProperty(value="group")
    public Optional<PermissionGroup> getGroup() {
        return this.group;
    }

    @JsonProperty(value="type")
    public Optional<PermissionType> getType() {
        return this.type;
    }

    @JsonProperty(value="roles")
    public Optional<List<Optional<PermissionRolesItem>>> getRoles() {
        return this.roles;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Permission && this.equalTo((Permission)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Permission other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.user.equals(other.user) && this.group.equals(other.group) && this.type.equals(other.type) && this.roles.equals(other.roles);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.user, this.group, this.type, this.roles);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<PermissionUser> user = Optional.empty();
        private Optional<PermissionGroup> group = Optional.empty();
        private Optional<PermissionType> type = Optional.empty();
        private Optional<List<Optional<PermissionRolesItem>>> roles = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Permission other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.user(other.getUser());
            this.group(other.getGroup());
            this.type(other.getType());
            this.roles(other.getRoles());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="user", nulls=Nulls.SKIP)
        public Builder user(Optional<PermissionUser> user) {
            this.user = user;
            return this;
        }

        public Builder user(PermissionUser user) {
            this.user = Optional.of(user);
            return this;
        }

        @JsonSetter(value="group", nulls=Nulls.SKIP)
        public Builder group(Optional<PermissionGroup> group) {
            this.group = group;
            return this;
        }

        public Builder group(PermissionGroup group) {
            this.group = Optional.of(group);
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<PermissionType> type) {
            this.type = type;
            return this;
        }

        public Builder type(PermissionType type) {
            this.type = Optional.of(type);
            return this;
        }

        @JsonSetter(value="roles", nulls=Nulls.SKIP)
        public Builder roles(Optional<List<Optional<PermissionRolesItem>>> roles) {
            this.roles = roles;
            return this;
        }

        public Builder roles(List<Optional<PermissionRolesItem>> roles) {
            this.roles = Optional.of(roles);
            return this;
        }

        public Permission build() {
            return new Permission(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.user, this.group, this.type, this.roles, this.additionalProperties);
        }
    }
}

