/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.filestorage.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.filestorage.types.AdvancedMetadata;
import com.merge.api.resources.filestorage.types.RemoteEndpointInfo;
import com.merge.api.resources.filestorage.types.RemoteFieldApiCoverage;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class RemoteFieldApi {
    private final Map<String, JsonNode> schema;
    private final String remoteKeyName;
    private final RemoteEndpointInfo remoteEndpointInfo;
    private final Optional<List<JsonNode>> exampleValues;
    private final Optional<AdvancedMetadata> advancedMetadata;
    private final Optional<RemoteFieldApiCoverage> coverage;
    private final Map<String, Object> additionalProperties;

    private RemoteFieldApi(Map<String, JsonNode> schema, String remoteKeyName, RemoteEndpointInfo remoteEndpointInfo, Optional<List<JsonNode>> exampleValues, Optional<AdvancedMetadata> advancedMetadata, Optional<RemoteFieldApiCoverage> coverage, Map<String, Object> additionalProperties) {
        this.schema = schema;
        this.remoteKeyName = remoteKeyName;
        this.remoteEndpointInfo = remoteEndpointInfo;
        this.exampleValues = exampleValues;
        this.advancedMetadata = advancedMetadata;
        this.coverage = coverage;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="schema")
    public Map<String, JsonNode> getSchema() {
        return this.schema;
    }

    @JsonProperty(value="remote_key_name")
    public String getRemoteKeyName() {
        return this.remoteKeyName;
    }

    @JsonProperty(value="remote_endpoint_info")
    public RemoteEndpointInfo getRemoteEndpointInfo() {
        return this.remoteEndpointInfo;
    }

    @JsonProperty(value="example_values")
    public Optional<List<JsonNode>> getExampleValues() {
        return this.exampleValues;
    }

    @JsonProperty(value="advanced_metadata")
    public Optional<AdvancedMetadata> getAdvancedMetadata() {
        return this.advancedMetadata;
    }

    @JsonProperty(value="coverage")
    public Optional<RemoteFieldApiCoverage> getCoverage() {
        return this.coverage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RemoteFieldApi && this.equalTo((RemoteFieldApi)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RemoteFieldApi other) {
        return this.schema.equals(other.schema) && this.remoteKeyName.equals(other.remoteKeyName) && this.remoteEndpointInfo.equals(other.remoteEndpointInfo) && this.exampleValues.equals(other.exampleValues) && this.advancedMetadata.equals(other.advancedMetadata) && this.coverage.equals(other.coverage);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.remoteKeyName, this.remoteEndpointInfo, this.exampleValues, this.advancedMetadata, this.coverage);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RemoteKeyNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RemoteKeyNameStage,
    RemoteEndpointInfoStage,
    _FinalStage {
        private String remoteKeyName;
        private RemoteEndpointInfo remoteEndpointInfo;
        private Optional<RemoteFieldApiCoverage> coverage = Optional.empty();
        private Optional<AdvancedMetadata> advancedMetadata = Optional.empty();
        private Optional<List<JsonNode>> exampleValues = Optional.empty();
        private Map<String, JsonNode> schema = new LinkedHashMap<String, JsonNode>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(RemoteFieldApi other) {
            this.schema(other.getSchema());
            this.remoteKeyName(other.getRemoteKeyName());
            this.remoteEndpointInfo(other.getRemoteEndpointInfo());
            this.exampleValues(other.getExampleValues());
            this.advancedMetadata(other.getAdvancedMetadata());
            this.coverage(other.getCoverage());
            return this;
        }

        @Override
        @JsonSetter(value="remote_key_name")
        public RemoteEndpointInfoStage remoteKeyName(String remoteKeyName) {
            this.remoteKeyName = remoteKeyName;
            return this;
        }

        @Override
        @JsonSetter(value="remote_endpoint_info")
        public _FinalStage remoteEndpointInfo(RemoteEndpointInfo remoteEndpointInfo) {
            this.remoteEndpointInfo = remoteEndpointInfo;
            return this;
        }

        @Override
        public _FinalStage coverage(RemoteFieldApiCoverage coverage) {
            this.coverage = Optional.of(coverage);
            return this;
        }

        @Override
        @JsonSetter(value="coverage", nulls=Nulls.SKIP)
        public _FinalStage coverage(Optional<RemoteFieldApiCoverage> coverage) {
            this.coverage = coverage;
            return this;
        }

        @Override
        public _FinalStage advancedMetadata(AdvancedMetadata advancedMetadata) {
            this.advancedMetadata = Optional.of(advancedMetadata);
            return this;
        }

        @Override
        @JsonSetter(value="advanced_metadata", nulls=Nulls.SKIP)
        public _FinalStage advancedMetadata(Optional<AdvancedMetadata> advancedMetadata) {
            this.advancedMetadata = advancedMetadata;
            return this;
        }

        @Override
        public _FinalStage exampleValues(List<JsonNode> exampleValues) {
            this.exampleValues = Optional.of(exampleValues);
            return this;
        }

        @Override
        @JsonSetter(value="example_values", nulls=Nulls.SKIP)
        public _FinalStage exampleValues(Optional<List<JsonNode>> exampleValues) {
            this.exampleValues = exampleValues;
            return this;
        }

        @Override
        public _FinalStage schema(String key, JsonNode value) {
            this.schema.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllSchema(Map<String, JsonNode> schema) {
            this.schema.putAll(schema);
            return this;
        }

        @Override
        @JsonSetter(value="schema", nulls=Nulls.SKIP)
        public _FinalStage schema(Map<String, JsonNode> schema) {
            this.schema.clear();
            this.schema.putAll(schema);
            return this;
        }

        @Override
        public RemoteFieldApi build() {
            return new RemoteFieldApi(this.schema, this.remoteKeyName, this.remoteEndpointInfo, this.exampleValues, this.advancedMetadata, this.coverage, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public RemoteFieldApi build();

        public _FinalStage schema(Map<String, JsonNode> var1);

        public _FinalStage putAllSchema(Map<String, JsonNode> var1);

        public _FinalStage schema(String var1, JsonNode var2);

        public _FinalStage exampleValues(Optional<List<JsonNode>> var1);

        public _FinalStage exampleValues(List<JsonNode> var1);

        public _FinalStage advancedMetadata(Optional<AdvancedMetadata> var1);

        public _FinalStage advancedMetadata(AdvancedMetadata var1);

        public _FinalStage coverage(Optional<RemoteFieldApiCoverage> var1);

        public _FinalStage coverage(RemoteFieldApiCoverage var1);
    }

    public static interface RemoteEndpointInfoStage {
        public _FinalStage remoteEndpointInfo(RemoteEndpointInfo var1);
    }

    public static interface RemoteKeyNameStage {
        public RemoteEndpointInfoStage remoteKeyName(String var1);

        public Builder from(RemoteFieldApi var1);
    }
}

