/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.filestorage.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.filestorage.types.ValidationProblemSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class WarningValidationProblem {
    private final Optional<ValidationProblemSource> source;
    private final String title;
    private final String detail;
    private final String problemType;
    private final Map<String, Object> additionalProperties;

    private WarningValidationProblem(Optional<ValidationProblemSource> source, String title, String detail, String problemType, Map<String, Object> additionalProperties) {
        this.source = source;
        this.title = title;
        this.detail = detail;
        this.problemType = problemType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="source")
    public Optional<ValidationProblemSource> getSource() {
        return this.source;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="detail")
    public String getDetail() {
        return this.detail;
    }

    @JsonProperty(value="problem_type")
    public String getProblemType() {
        return this.problemType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WarningValidationProblem && this.equalTo((WarningValidationProblem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WarningValidationProblem other) {
        return this.source.equals(other.source) && this.title.equals(other.title) && this.detail.equals(other.detail) && this.problemType.equals(other.problemType);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.title, this.detail, this.problemType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TitleStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TitleStage,
    DetailStage,
    ProblemTypeStage,
    _FinalStage {
        private String title;
        private String detail;
        private String problemType;
        private Optional<ValidationProblemSource> source = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(WarningValidationProblem other) {
            this.source(other.getSource());
            this.title(other.getTitle());
            this.detail(other.getDetail());
            this.problemType(other.getProblemType());
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public DetailStage title(String title) {
            this.title = title;
            return this;
        }

        @Override
        @JsonSetter(value="detail")
        public ProblemTypeStage detail(String detail) {
            this.detail = detail;
            return this;
        }

        @Override
        @JsonSetter(value="problem_type")
        public _FinalStage problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        @Override
        public _FinalStage source(ValidationProblemSource source) {
            this.source = Optional.of(source);
            return this;
        }

        @Override
        @JsonSetter(value="source", nulls=Nulls.SKIP)
        public _FinalStage source(Optional<ValidationProblemSource> source) {
            this.source = source;
            return this;
        }

        @Override
        public WarningValidationProblem build() {
            return new WarningValidationProblem(this.source, this.title, this.detail, this.problemType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public WarningValidationProblem build();

        public _FinalStage source(Optional<ValidationProblemSource> var1);

        public _FinalStage source(ValidationProblemSource var1);
    }

    public static interface ProblemTypeStage {
        public _FinalStage problemType(String var1);
    }

    public static interface DetailStage {
        public ProblemTypeStage detail(String var1);
    }

    public static interface TitleStage {
        public DetailStage title(String var1);

        public Builder from(WarningValidationProblem var1);
    }
}

