/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.filestorage.webhookreceivers.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class WebhookReceiverRequest {
    private final String event;
    private final boolean isActive;
    private final Optional<String> key;
    private final Map<String, Object> additionalProperties;

    private WebhookReceiverRequest(String event, boolean isActive, Optional<String> key, Map<String, Object> additionalProperties) {
        this.event = event;
        this.isActive = isActive;
        this.key = key;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="event")
    public String getEvent() {
        return this.event;
    }

    @JsonProperty(value="is_active")
    public boolean getIsActive() {
        return this.isActive;
    }

    @JsonProperty(value="key")
    public Optional<String> getKey() {
        return this.key;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WebhookReceiverRequest && this.equalTo((WebhookReceiverRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WebhookReceiverRequest other) {
        return this.event.equals(other.event) && this.isActive == other.isActive && this.key.equals(other.key);
    }

    public int hashCode() {
        return Objects.hash(this.event, this.isActive, this.key);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EventStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EventStage,
    IsActiveStage,
    _FinalStage {
        private String event;
        private boolean isActive;
        private Optional<String> key = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(WebhookReceiverRequest other) {
            this.event(other.getEvent());
            this.isActive(other.getIsActive());
            this.key(other.getKey());
            return this;
        }

        @Override
        @JsonSetter(value="event")
        public IsActiveStage event(String event) {
            this.event = event;
            return this;
        }

        @Override
        @JsonSetter(value="is_active")
        public _FinalStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        public _FinalStage key(String key) {
            this.key = Optional.of(key);
            return this;
        }

        @Override
        @JsonSetter(value="key", nulls=Nulls.SKIP)
        public _FinalStage key(Optional<String> key) {
            this.key = key;
            return this;
        }

        @Override
        public WebhookReceiverRequest build() {
            return new WebhookReceiverRequest(this.event, this.isActive, this.key, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public WebhookReceiverRequest build();

        public _FinalStage key(Optional<String> var1);

        public _FinalStage key(String var1);
    }

    public static interface IsActiveStage {
        public _FinalStage isActive(boolean var1);
    }

    public static interface EventStage {
        public IsActiveStage event(String var1);

        public Builder from(WebhookReceiverRequest var1);
    }
}

