/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.hris.dependents.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DependentsRetrieveRequest {
    private final Optional<Boolean> includeRemoteData;
    private final Optional<Boolean> includeSensitiveFields;
    private final Map<String, Object> additionalProperties;

    private DependentsRetrieveRequest(Optional<Boolean> includeRemoteData, Optional<Boolean> includeSensitiveFields, Map<String, Object> additionalProperties) {
        this.includeRemoteData = includeRemoteData;
        this.includeSensitiveFields = includeSensitiveFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="include_remote_data")
    public Optional<Boolean> getIncludeRemoteData() {
        return this.includeRemoteData;
    }

    @JsonProperty(value="include_sensitive_fields")
    public Optional<Boolean> getIncludeSensitiveFields() {
        return this.includeSensitiveFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DependentsRetrieveRequest && this.equalTo((DependentsRetrieveRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DependentsRetrieveRequest other) {
        return this.includeRemoteData.equals(other.includeRemoteData) && this.includeSensitiveFields.equals(other.includeSensitiveFields);
    }

    public int hashCode() {
        return Objects.hash(this.includeRemoteData, this.includeSensitiveFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> includeRemoteData = Optional.empty();
        private Optional<Boolean> includeSensitiveFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DependentsRetrieveRequest other) {
            this.includeRemoteData(other.getIncludeRemoteData());
            this.includeSensitiveFields(other.getIncludeSensitiveFields());
            return this;
        }

        @JsonSetter(value="include_remote_data", nulls=Nulls.SKIP)
        public Builder includeRemoteData(Optional<Boolean> includeRemoteData) {
            this.includeRemoteData = includeRemoteData;
            return this;
        }

        public Builder includeRemoteData(Boolean includeRemoteData) {
            this.includeRemoteData = Optional.of(includeRemoteData);
            return this;
        }

        @JsonSetter(value="include_sensitive_fields", nulls=Nulls.SKIP)
        public Builder includeSensitiveFields(Optional<Boolean> includeSensitiveFields) {
            this.includeSensitiveFields = includeSensitiveFields;
            return this;
        }

        public Builder includeSensitiveFields(Boolean includeSensitiveFields) {
            this.includeSensitiveFields = Optional.of(includeSensitiveFields);
            return this;
        }

        public DependentsRetrieveRequest build() {
            return new DependentsRetrieveRequest(this.includeRemoteData, this.includeSensitiveFields, this.additionalProperties);
        }
    }
}

