/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.hris.linkedaccounts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.hris.linkedaccounts.types.LinkedAccountsListRequestCategory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LinkedAccountsListRequest {
    private final Optional<LinkedAccountsListRequestCategory> category;
    private final Optional<String> cursor;
    private final Optional<String> endUserEmailAddress;
    private final Optional<String> endUserOrganizationName;
    private final Optional<String> endUserOriginId;
    private final Optional<String> endUserOriginIds;
    private final Optional<String> id;
    private final Optional<String> ids;
    private final Optional<Boolean> includeDuplicates;
    private final Optional<String> integrationName;
    private final Optional<String> isTestAccount;
    private final Optional<Integer> pageSize;
    private final Optional<String> status;
    private final Map<String, Object> additionalProperties;

    private LinkedAccountsListRequest(Optional<LinkedAccountsListRequestCategory> category, Optional<String> cursor, Optional<String> endUserEmailAddress, Optional<String> endUserOrganizationName, Optional<String> endUserOriginId, Optional<String> endUserOriginIds, Optional<String> id, Optional<String> ids, Optional<Boolean> includeDuplicates, Optional<String> integrationName, Optional<String> isTestAccount, Optional<Integer> pageSize, Optional<String> status, Map<String, Object> additionalProperties) {
        this.category = category;
        this.cursor = cursor;
        this.endUserEmailAddress = endUserEmailAddress;
        this.endUserOrganizationName = endUserOrganizationName;
        this.endUserOriginId = endUserOriginId;
        this.endUserOriginIds = endUserOriginIds;
        this.id = id;
        this.ids = ids;
        this.includeDuplicates = includeDuplicates;
        this.integrationName = integrationName;
        this.isTestAccount = isTestAccount;
        this.pageSize = pageSize;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="category")
    public Optional<LinkedAccountsListRequestCategory> getCategory() {
        return this.category;
    }

    @JsonProperty(value="cursor")
    public Optional<String> getCursor() {
        return this.cursor;
    }

    @JsonProperty(value="end_user_email_address")
    public Optional<String> getEndUserEmailAddress() {
        return this.endUserEmailAddress;
    }

    @JsonProperty(value="end_user_organization_name")
    public Optional<String> getEndUserOrganizationName() {
        return this.endUserOrganizationName;
    }

    @JsonProperty(value="end_user_origin_id")
    public Optional<String> getEndUserOriginId() {
        return this.endUserOriginId;
    }

    @JsonProperty(value="end_user_origin_ids")
    public Optional<String> getEndUserOriginIds() {
        return this.endUserOriginIds;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="ids")
    public Optional<String> getIds() {
        return this.ids;
    }

    @JsonProperty(value="include_duplicates")
    public Optional<Boolean> getIncludeDuplicates() {
        return this.includeDuplicates;
    }

    @JsonProperty(value="integration_name")
    public Optional<String> getIntegrationName() {
        return this.integrationName;
    }

    @JsonProperty(value="is_test_account")
    public Optional<String> getIsTestAccount() {
        return this.isTestAccount;
    }

    @JsonProperty(value="page_size")
    public Optional<Integer> getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="status")
    public Optional<String> getStatus() {
        return this.status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LinkedAccountsListRequest && this.equalTo((LinkedAccountsListRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LinkedAccountsListRequest other) {
        return this.category.equals(other.category) && this.cursor.equals(other.cursor) && this.endUserEmailAddress.equals(other.endUserEmailAddress) && this.endUserOrganizationName.equals(other.endUserOrganizationName) && this.endUserOriginId.equals(other.endUserOriginId) && this.endUserOriginIds.equals(other.endUserOriginIds) && this.id.equals(other.id) && this.ids.equals(other.ids) && this.includeDuplicates.equals(other.includeDuplicates) && this.integrationName.equals(other.integrationName) && this.isTestAccount.equals(other.isTestAccount) && this.pageSize.equals(other.pageSize) && this.status.equals(other.status);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.cursor, this.endUserEmailAddress, this.endUserOrganizationName, this.endUserOriginId, this.endUserOriginIds, this.id, this.ids, this.includeDuplicates, this.integrationName, this.isTestAccount, this.pageSize, this.status);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<LinkedAccountsListRequestCategory> category = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<String> endUserEmailAddress = Optional.empty();
        private Optional<String> endUserOrganizationName = Optional.empty();
        private Optional<String> endUserOriginId = Optional.empty();
        private Optional<String> endUserOriginIds = Optional.empty();
        private Optional<String> id = Optional.empty();
        private Optional<String> ids = Optional.empty();
        private Optional<Boolean> includeDuplicates = Optional.empty();
        private Optional<String> integrationName = Optional.empty();
        private Optional<String> isTestAccount = Optional.empty();
        private Optional<Integer> pageSize = Optional.empty();
        private Optional<String> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(LinkedAccountsListRequest other) {
            this.category(other.getCategory());
            this.cursor(other.getCursor());
            this.endUserEmailAddress(other.getEndUserEmailAddress());
            this.endUserOrganizationName(other.getEndUserOrganizationName());
            this.endUserOriginId(other.getEndUserOriginId());
            this.endUserOriginIds(other.getEndUserOriginIds());
            this.id(other.getId());
            this.ids(other.getIds());
            this.includeDuplicates(other.getIncludeDuplicates());
            this.integrationName(other.getIntegrationName());
            this.isTestAccount(other.getIsTestAccount());
            this.pageSize(other.getPageSize());
            this.status(other.getStatus());
            return this;
        }

        @JsonSetter(value="category", nulls=Nulls.SKIP)
        public Builder category(Optional<LinkedAccountsListRequestCategory> category) {
            this.category = category;
            return this;
        }

        public Builder category(LinkedAccountsListRequestCategory category) {
            this.category = Optional.of(category);
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.of(cursor);
            return this;
        }

        @JsonSetter(value="end_user_email_address", nulls=Nulls.SKIP)
        public Builder endUserEmailAddress(Optional<String> endUserEmailAddress) {
            this.endUserEmailAddress = endUserEmailAddress;
            return this;
        }

        public Builder endUserEmailAddress(String endUserEmailAddress) {
            this.endUserEmailAddress = Optional.of(endUserEmailAddress);
            return this;
        }

        @JsonSetter(value="end_user_organization_name", nulls=Nulls.SKIP)
        public Builder endUserOrganizationName(Optional<String> endUserOrganizationName) {
            this.endUserOrganizationName = endUserOrganizationName;
            return this;
        }

        public Builder endUserOrganizationName(String endUserOrganizationName) {
            this.endUserOrganizationName = Optional.of(endUserOrganizationName);
            return this;
        }

        @JsonSetter(value="end_user_origin_id", nulls=Nulls.SKIP)
        public Builder endUserOriginId(Optional<String> endUserOriginId) {
            this.endUserOriginId = endUserOriginId;
            return this;
        }

        public Builder endUserOriginId(String endUserOriginId) {
            this.endUserOriginId = Optional.of(endUserOriginId);
            return this;
        }

        @JsonSetter(value="end_user_origin_ids", nulls=Nulls.SKIP)
        public Builder endUserOriginIds(Optional<String> endUserOriginIds) {
            this.endUserOriginIds = endUserOriginIds;
            return this;
        }

        public Builder endUserOriginIds(String endUserOriginIds) {
            this.endUserOriginIds = Optional.of(endUserOriginIds);
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="ids", nulls=Nulls.SKIP)
        public Builder ids(Optional<String> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(String ids) {
            this.ids = Optional.of(ids);
            return this;
        }

        @JsonSetter(value="include_duplicates", nulls=Nulls.SKIP)
        public Builder includeDuplicates(Optional<Boolean> includeDuplicates) {
            this.includeDuplicates = includeDuplicates;
            return this;
        }

        public Builder includeDuplicates(Boolean includeDuplicates) {
            this.includeDuplicates = Optional.of(includeDuplicates);
            return this;
        }

        @JsonSetter(value="integration_name", nulls=Nulls.SKIP)
        public Builder integrationName(Optional<String> integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public Builder integrationName(String integrationName) {
            this.integrationName = Optional.of(integrationName);
            return this;
        }

        @JsonSetter(value="is_test_account", nulls=Nulls.SKIP)
        public Builder isTestAccount(Optional<String> isTestAccount) {
            this.isTestAccount = isTestAccount;
            return this;
        }

        public Builder isTestAccount(String isTestAccount) {
            this.isTestAccount = Optional.of(isTestAccount);
            return this;
        }

        @JsonSetter(value="page_size", nulls=Nulls.SKIP)
        public Builder pageSize(Optional<Integer> pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.pageSize = Optional.of(pageSize);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<String> status) {
            this.status = status;
            return this;
        }

        public Builder status(String status) {
            this.status = Optional.of(status);
            return this;
        }

        public LinkedAccountsListRequest build() {
            return new LinkedAccountsListRequest(this.category, this.cursor, this.endUserEmailAddress, this.endUserOrganizationName, this.endUserOriginId, this.endUserOriginIds, this.id, this.ids, this.includeDuplicates, this.integrationName, this.isTestAccount, this.pageSize, this.status, this.additionalProperties);
        }
    }
}

