/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.hris.payrollruns.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.hris.payrollruns.types.PayrollRunsRetrieveRequestRemoteFields;
import com.merge.api.resources.hris.payrollruns.types.PayrollRunsRetrieveRequestShowEnumOrigins;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PayrollRunsRetrieveRequest {
    private final Optional<Boolean> includeRemoteData;
    private final Optional<PayrollRunsRetrieveRequestRemoteFields> remoteFields;
    private final Optional<PayrollRunsRetrieveRequestShowEnumOrigins> showEnumOrigins;
    private final Map<String, Object> additionalProperties;

    private PayrollRunsRetrieveRequest(Optional<Boolean> includeRemoteData, Optional<PayrollRunsRetrieveRequestRemoteFields> remoteFields, Optional<PayrollRunsRetrieveRequestShowEnumOrigins> showEnumOrigins, Map<String, Object> additionalProperties) {
        this.includeRemoteData = includeRemoteData;
        this.remoteFields = remoteFields;
        this.showEnumOrigins = showEnumOrigins;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="include_remote_data")
    public Optional<Boolean> getIncludeRemoteData() {
        return this.includeRemoteData;
    }

    @JsonProperty(value="remote_fields")
    public Optional<PayrollRunsRetrieveRequestRemoteFields> getRemoteFields() {
        return this.remoteFields;
    }

    @JsonProperty(value="show_enum_origins")
    public Optional<PayrollRunsRetrieveRequestShowEnumOrigins> getShowEnumOrigins() {
        return this.showEnumOrigins;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PayrollRunsRetrieveRequest && this.equalTo((PayrollRunsRetrieveRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PayrollRunsRetrieveRequest other) {
        return this.includeRemoteData.equals(other.includeRemoteData) && this.remoteFields.equals(other.remoteFields) && this.showEnumOrigins.equals(other.showEnumOrigins);
    }

    public int hashCode() {
        return Objects.hash(this.includeRemoteData, this.remoteFields, this.showEnumOrigins);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Boolean> includeRemoteData = Optional.empty();
        private Optional<PayrollRunsRetrieveRequestRemoteFields> remoteFields = Optional.empty();
        private Optional<PayrollRunsRetrieveRequestShowEnumOrigins> showEnumOrigins = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PayrollRunsRetrieveRequest other) {
            this.includeRemoteData(other.getIncludeRemoteData());
            this.remoteFields(other.getRemoteFields());
            this.showEnumOrigins(other.getShowEnumOrigins());
            return this;
        }

        @JsonSetter(value="include_remote_data", nulls=Nulls.SKIP)
        public Builder includeRemoteData(Optional<Boolean> includeRemoteData) {
            this.includeRemoteData = includeRemoteData;
            return this;
        }

        public Builder includeRemoteData(Boolean includeRemoteData) {
            this.includeRemoteData = Optional.of(includeRemoteData);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<PayrollRunsRetrieveRequestRemoteFields> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(PayrollRunsRetrieveRequestRemoteFields remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        @JsonSetter(value="show_enum_origins", nulls=Nulls.SKIP)
        public Builder showEnumOrigins(Optional<PayrollRunsRetrieveRequestShowEnumOrigins> showEnumOrigins) {
            this.showEnumOrigins = showEnumOrigins;
            return this;
        }

        public Builder showEnumOrigins(PayrollRunsRetrieveRequestShowEnumOrigins showEnumOrigins) {
            this.showEnumOrigins = Optional.of(showEnumOrigins);
            return this;
        }

        public PayrollRunsRetrieveRequest build() {
            return new PayrollRunsRetrieveRequest(this.includeRemoteData, this.remoteFields, this.showEnumOrigins, this.additionalProperties);
        }
    }
}

