/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.hris.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.hris.types.CategoriesEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AccountIntegration {
    private final String name;
    private final Optional<String> abbreviatedName;
    private final Optional<List<CategoriesEnum>> categories;
    private final Optional<String> image;
    private final Optional<String> squareImage;
    private final Optional<String> color;
    private final Optional<String> slug;
    private final Optional<Map<String, JsonNode>> apiEndpointsToDocumentationUrls;
    private final Optional<String> webhookSetupGuideUrl;
    private final Optional<Map<String, JsonNode>> categoryBetaStatus;
    private final Map<String, Object> additionalProperties;

    private AccountIntegration(String name, Optional<String> abbreviatedName, Optional<List<CategoriesEnum>> categories, Optional<String> image, Optional<String> squareImage, Optional<String> color, Optional<String> slug, Optional<Map<String, JsonNode>> apiEndpointsToDocumentationUrls, Optional<String> webhookSetupGuideUrl, Optional<Map<String, JsonNode>> categoryBetaStatus, Map<String, Object> additionalProperties) {
        this.name = name;
        this.abbreviatedName = abbreviatedName;
        this.categories = categories;
        this.image = image;
        this.squareImage = squareImage;
        this.color = color;
        this.slug = slug;
        this.apiEndpointsToDocumentationUrls = apiEndpointsToDocumentationUrls;
        this.webhookSetupGuideUrl = webhookSetupGuideUrl;
        this.categoryBetaStatus = categoryBetaStatus;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="abbreviated_name")
    public Optional<String> getAbbreviatedName() {
        return this.abbreviatedName;
    }

    @JsonProperty(value="categories")
    public Optional<List<CategoriesEnum>> getCategories() {
        return this.categories;
    }

    @JsonProperty(value="image")
    public Optional<String> getImage() {
        return this.image;
    }

    @JsonProperty(value="square_image")
    public Optional<String> getSquareImage() {
        return this.squareImage;
    }

    @JsonProperty(value="color")
    public Optional<String> getColor() {
        return this.color;
    }

    @JsonProperty(value="slug")
    public Optional<String> getSlug() {
        return this.slug;
    }

    @JsonProperty(value="api_endpoints_to_documentation_urls")
    public Optional<Map<String, JsonNode>> getApiEndpointsToDocumentationUrls() {
        return this.apiEndpointsToDocumentationUrls;
    }

    @JsonProperty(value="webhook_setup_guide_url")
    public Optional<String> getWebhookSetupGuideUrl() {
        return this.webhookSetupGuideUrl;
    }

    @JsonProperty(value="category_beta_status")
    public Optional<Map<String, JsonNode>> getCategoryBetaStatus() {
        return this.categoryBetaStatus;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AccountIntegration && this.equalTo((AccountIntegration)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AccountIntegration other) {
        return this.name.equals(other.name) && this.abbreviatedName.equals(other.abbreviatedName) && this.categories.equals(other.categories) && this.image.equals(other.image) && this.squareImage.equals(other.squareImage) && this.color.equals(other.color) && this.slug.equals(other.slug) && this.apiEndpointsToDocumentationUrls.equals(other.apiEndpointsToDocumentationUrls) && this.webhookSetupGuideUrl.equals(other.webhookSetupGuideUrl) && this.categoryBetaStatus.equals(other.categoryBetaStatus);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.abbreviatedName, this.categories, this.image, this.squareImage, this.color, this.slug, this.apiEndpointsToDocumentationUrls, this.webhookSetupGuideUrl, this.categoryBetaStatus);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    _FinalStage {
        private String name;
        private Optional<Map<String, JsonNode>> categoryBetaStatus = Optional.empty();
        private Optional<String> webhookSetupGuideUrl = Optional.empty();
        private Optional<Map<String, JsonNode>> apiEndpointsToDocumentationUrls = Optional.empty();
        private Optional<String> slug = Optional.empty();
        private Optional<String> color = Optional.empty();
        private Optional<String> squareImage = Optional.empty();
        private Optional<String> image = Optional.empty();
        private Optional<List<CategoriesEnum>> categories = Optional.empty();
        private Optional<String> abbreviatedName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AccountIntegration other) {
            this.name(other.getName());
            this.abbreviatedName(other.getAbbreviatedName());
            this.categories(other.getCategories());
            this.image(other.getImage());
            this.squareImage(other.getSquareImage());
            this.color(other.getColor());
            this.slug(other.getSlug());
            this.apiEndpointsToDocumentationUrls(other.getApiEndpointsToDocumentationUrls());
            this.webhookSetupGuideUrl(other.getWebhookSetupGuideUrl());
            this.categoryBetaStatus(other.getCategoryBetaStatus());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage categoryBetaStatus(Map<String, JsonNode> categoryBetaStatus) {
            this.categoryBetaStatus = Optional.of(categoryBetaStatus);
            return this;
        }

        @Override
        @JsonSetter(value="category_beta_status", nulls=Nulls.SKIP)
        public _FinalStage categoryBetaStatus(Optional<Map<String, JsonNode>> categoryBetaStatus) {
            this.categoryBetaStatus = categoryBetaStatus;
            return this;
        }

        @Override
        public _FinalStage webhookSetupGuideUrl(String webhookSetupGuideUrl) {
            this.webhookSetupGuideUrl = Optional.of(webhookSetupGuideUrl);
            return this;
        }

        @Override
        @JsonSetter(value="webhook_setup_guide_url", nulls=Nulls.SKIP)
        public _FinalStage webhookSetupGuideUrl(Optional<String> webhookSetupGuideUrl) {
            this.webhookSetupGuideUrl = webhookSetupGuideUrl;
            return this;
        }

        @Override
        public _FinalStage apiEndpointsToDocumentationUrls(Map<String, JsonNode> apiEndpointsToDocumentationUrls) {
            this.apiEndpointsToDocumentationUrls = Optional.of(apiEndpointsToDocumentationUrls);
            return this;
        }

        @Override
        @JsonSetter(value="api_endpoints_to_documentation_urls", nulls=Nulls.SKIP)
        public _FinalStage apiEndpointsToDocumentationUrls(Optional<Map<String, JsonNode>> apiEndpointsToDocumentationUrls) {
            this.apiEndpointsToDocumentationUrls = apiEndpointsToDocumentationUrls;
            return this;
        }

        @Override
        public _FinalStage slug(String slug) {
            this.slug = Optional.of(slug);
            return this;
        }

        @Override
        @JsonSetter(value="slug", nulls=Nulls.SKIP)
        public _FinalStage slug(Optional<String> slug) {
            this.slug = slug;
            return this;
        }

        @Override
        public _FinalStage color(String color) {
            this.color = Optional.of(color);
            return this;
        }

        @Override
        @JsonSetter(value="color", nulls=Nulls.SKIP)
        public _FinalStage color(Optional<String> color) {
            this.color = color;
            return this;
        }

        @Override
        public _FinalStage squareImage(String squareImage) {
            this.squareImage = Optional.of(squareImage);
            return this;
        }

        @Override
        @JsonSetter(value="square_image", nulls=Nulls.SKIP)
        public _FinalStage squareImage(Optional<String> squareImage) {
            this.squareImage = squareImage;
            return this;
        }

        @Override
        public _FinalStage image(String image) {
            this.image = Optional.of(image);
            return this;
        }

        @Override
        @JsonSetter(value="image", nulls=Nulls.SKIP)
        public _FinalStage image(Optional<String> image) {
            this.image = image;
            return this;
        }

        @Override
        public _FinalStage categories(List<CategoriesEnum> categories) {
            this.categories = Optional.of(categories);
            return this;
        }

        @Override
        @JsonSetter(value="categories", nulls=Nulls.SKIP)
        public _FinalStage categories(Optional<List<CategoriesEnum>> categories) {
            this.categories = categories;
            return this;
        }

        @Override
        public _FinalStage abbreviatedName(String abbreviatedName) {
            this.abbreviatedName = Optional.of(abbreviatedName);
            return this;
        }

        @Override
        @JsonSetter(value="abbreviated_name", nulls=Nulls.SKIP)
        public _FinalStage abbreviatedName(Optional<String> abbreviatedName) {
            this.abbreviatedName = abbreviatedName;
            return this;
        }

        @Override
        public AccountIntegration build() {
            return new AccountIntegration(this.name, this.abbreviatedName, this.categories, this.image, this.squareImage, this.color, this.slug, this.apiEndpointsToDocumentationUrls, this.webhookSetupGuideUrl, this.categoryBetaStatus, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AccountIntegration build();

        public _FinalStage abbreviatedName(Optional<String> var1);

        public _FinalStage abbreviatedName(String var1);

        public _FinalStage categories(Optional<List<CategoriesEnum>> var1);

        public _FinalStage categories(List<CategoriesEnum> var1);

        public _FinalStage image(Optional<String> var1);

        public _FinalStage image(String var1);

        public _FinalStage squareImage(Optional<String> var1);

        public _FinalStage squareImage(String var1);

        public _FinalStage color(Optional<String> var1);

        public _FinalStage color(String var1);

        public _FinalStage slug(Optional<String> var1);

        public _FinalStage slug(String var1);

        public _FinalStage apiEndpointsToDocumentationUrls(Optional<Map<String, JsonNode>> var1);

        public _FinalStage apiEndpointsToDocumentationUrls(Map<String, JsonNode> var1);

        public _FinalStage webhookSetupGuideUrl(Optional<String> var1);

        public _FinalStage webhookSetupGuideUrl(String var1);

        public _FinalStage categoryBetaStatus(Optional<Map<String, JsonNode>> var1);

        public _FinalStage categoryBetaStatus(Map<String, JsonNode> var1);
    }

    public static interface NameStage {
        public _FinalStage name(String var1);

        public Builder from(AccountIntegration var1);
    }
}

