/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.hris.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.hris.types.AccountIntegration;
import com.merge.api.resources.hris.types.ModelOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class AvailableActions {
    private final AccountIntegration integration;
    private final boolean passthroughAvailable;
    private final Optional<List<ModelOperation>> availableModelOperations;
    private final Map<String, Object> additionalProperties;

    private AvailableActions(AccountIntegration integration, boolean passthroughAvailable, Optional<List<ModelOperation>> availableModelOperations, Map<String, Object> additionalProperties) {
        this.integration = integration;
        this.passthroughAvailable = passthroughAvailable;
        this.availableModelOperations = availableModelOperations;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="integration")
    public AccountIntegration getIntegration() {
        return this.integration;
    }

    @JsonProperty(value="passthrough_available")
    public boolean getPassthroughAvailable() {
        return this.passthroughAvailable;
    }

    @JsonProperty(value="available_model_operations")
    public Optional<List<ModelOperation>> getAvailableModelOperations() {
        return this.availableModelOperations;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AvailableActions && this.equalTo((AvailableActions)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AvailableActions other) {
        return this.integration.equals(other.integration) && this.passthroughAvailable == other.passthroughAvailable && this.availableModelOperations.equals(other.availableModelOperations);
    }

    public int hashCode() {
        return Objects.hash(this.integration, this.passthroughAvailable, this.availableModelOperations);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IntegrationStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IntegrationStage,
    PassthroughAvailableStage,
    _FinalStage {
        private AccountIntegration integration;
        private boolean passthroughAvailable;
        private Optional<List<ModelOperation>> availableModelOperations = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AvailableActions other) {
            this.integration(other.getIntegration());
            this.passthroughAvailable(other.getPassthroughAvailable());
            this.availableModelOperations(other.getAvailableModelOperations());
            return this;
        }

        @Override
        @JsonSetter(value="integration")
        public PassthroughAvailableStage integration(AccountIntegration integration) {
            this.integration = integration;
            return this;
        }

        @Override
        @JsonSetter(value="passthrough_available")
        public _FinalStage passthroughAvailable(boolean passthroughAvailable) {
            this.passthroughAvailable = passthroughAvailable;
            return this;
        }

        @Override
        public _FinalStage availableModelOperations(List<ModelOperation> availableModelOperations) {
            this.availableModelOperations = Optional.of(availableModelOperations);
            return this;
        }

        @Override
        @JsonSetter(value="available_model_operations", nulls=Nulls.SKIP)
        public _FinalStage availableModelOperations(Optional<List<ModelOperation>> availableModelOperations) {
            this.availableModelOperations = availableModelOperations;
            return this;
        }

        @Override
        public AvailableActions build() {
            return new AvailableActions(this.integration, this.passthroughAvailable, this.availableModelOperations, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AvailableActions build();

        public _FinalStage availableModelOperations(Optional<List<ModelOperation>> var1);

        public _FinalStage availableModelOperations(List<ModelOperation> var1);
    }

    public static interface PassthroughAvailableStage {
        public _FinalStage passthroughAvailable(boolean var1);
    }

    public static interface IntegrationStage {
        public PassthroughAvailableStage integration(AccountIntegration var1);

        public Builder from(AvailableActions var1);
    }
}

