/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.hris.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.hris.types.DebugModelLogSummary;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DebugModeLog {
    private final String logId;
    private final String dashboardView;
    private final DebugModelLogSummary logSummary;
    private final Map<String, Object> additionalProperties;

    private DebugModeLog(String logId, String dashboardView, DebugModelLogSummary logSummary, Map<String, Object> additionalProperties) {
        this.logId = logId;
        this.dashboardView = dashboardView;
        this.logSummary = logSummary;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="log_id")
    public String getLogId() {
        return this.logId;
    }

    @JsonProperty(value="dashboard_view")
    public String getDashboardView() {
        return this.dashboardView;
    }

    @JsonProperty(value="log_summary")
    public DebugModelLogSummary getLogSummary() {
        return this.logSummary;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DebugModeLog && this.equalTo((DebugModeLog)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DebugModeLog other) {
        return this.logId.equals(other.logId) && this.dashboardView.equals(other.dashboardView) && this.logSummary.equals(other.logSummary);
    }

    public int hashCode() {
        return Objects.hash(this.logId, this.dashboardView, this.logSummary);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LogIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LogIdStage,
    DashboardViewStage,
    LogSummaryStage,
    _FinalStage {
        private String logId;
        private String dashboardView;
        private DebugModelLogSummary logSummary;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DebugModeLog other) {
            this.logId(other.getLogId());
            this.dashboardView(other.getDashboardView());
            this.logSummary(other.getLogSummary());
            return this;
        }

        @Override
        @JsonSetter(value="log_id")
        public DashboardViewStage logId(String logId) {
            this.logId = logId;
            return this;
        }

        @Override
        @JsonSetter(value="dashboard_view")
        public LogSummaryStage dashboardView(String dashboardView) {
            this.dashboardView = dashboardView;
            return this;
        }

        @Override
        @JsonSetter(value="log_summary")
        public _FinalStage logSummary(DebugModelLogSummary logSummary) {
            this.logSummary = logSummary;
            return this;
        }

        @Override
        public DebugModeLog build() {
            return new DebugModeLog(this.logId, this.dashboardView, this.logSummary, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DebugModeLog build();
    }

    public static interface LogSummaryStage {
        public _FinalStage logSummary(DebugModelLogSummary var1);
    }

    public static interface DashboardViewStage {
        public LogSummaryStage dashboardView(String var1);
    }

    public static interface LogIdStage {
        public DashboardViewStage logId(String var1);

        public Builder from(DebugModeLog var1);
    }
}

