/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.hris.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.hris.types.EmploymentEmployee;
import com.merge.api.resources.hris.types.EmploymentEmploymentType;
import com.merge.api.resources.hris.types.EmploymentFlsaStatus;
import com.merge.api.resources.hris.types.EmploymentPayCurrency;
import com.merge.api.resources.hris.types.EmploymentPayFrequency;
import com.merge.api.resources.hris.types.EmploymentPayGroup;
import com.merge.api.resources.hris.types.EmploymentPayPeriod;
import com.merge.api.resources.hris.types.RemoteData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Employment {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<EmploymentEmployee> employee;
    private final Optional<String> jobTitle;
    private final Optional<Double> payRate;
    private final Optional<EmploymentPayPeriod> payPeriod;
    private final Optional<EmploymentPayFrequency> payFrequency;
    private final Optional<EmploymentPayCurrency> payCurrency;
    private final Optional<EmploymentPayGroup> payGroup;
    private final Optional<EmploymentFlsaStatus> flsaStatus;
    private final Optional<OffsetDateTime> effectiveDate;
    private final Optional<EmploymentEmploymentType> employmentType;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private Employment(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<EmploymentEmployee> employee, Optional<String> jobTitle, Optional<Double> payRate, Optional<EmploymentPayPeriod> payPeriod, Optional<EmploymentPayFrequency> payFrequency, Optional<EmploymentPayCurrency> payCurrency, Optional<EmploymentPayGroup> payGroup, Optional<EmploymentFlsaStatus> flsaStatus, Optional<OffsetDateTime> effectiveDate, Optional<EmploymentEmploymentType> employmentType, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.employee = employee;
        this.jobTitle = jobTitle;
        this.payRate = payRate;
        this.payPeriod = payPeriod;
        this.payFrequency = payFrequency;
        this.payCurrency = payCurrency;
        this.payGroup = payGroup;
        this.flsaStatus = flsaStatus;
        this.effectiveDate = effectiveDate;
        this.employmentType = employmentType;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="employee")
    public Optional<EmploymentEmployee> getEmployee() {
        return this.employee;
    }

    @JsonProperty(value="job_title")
    public Optional<String> getJobTitle() {
        return this.jobTitle;
    }

    @JsonProperty(value="pay_rate")
    public Optional<Double> getPayRate() {
        return this.payRate;
    }

    @JsonProperty(value="pay_period")
    public Optional<EmploymentPayPeriod> getPayPeriod() {
        return this.payPeriod;
    }

    @JsonProperty(value="pay_frequency")
    public Optional<EmploymentPayFrequency> getPayFrequency() {
        return this.payFrequency;
    }

    @JsonProperty(value="pay_currency")
    public Optional<EmploymentPayCurrency> getPayCurrency() {
        return this.payCurrency;
    }

    @JsonProperty(value="pay_group")
    public Optional<EmploymentPayGroup> getPayGroup() {
        return this.payGroup;
    }

    @JsonProperty(value="flsa_status")
    public Optional<EmploymentFlsaStatus> getFlsaStatus() {
        return this.flsaStatus;
    }

    @JsonProperty(value="effective_date")
    public Optional<OffsetDateTime> getEffectiveDate() {
        return this.effectiveDate;
    }

    @JsonProperty(value="employment_type")
    public Optional<EmploymentEmploymentType> getEmploymentType() {
        return this.employmentType;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Employment && this.equalTo((Employment)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Employment other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.employee.equals(other.employee) && this.jobTitle.equals(other.jobTitle) && this.payRate.equals(other.payRate) && this.payPeriod.equals(other.payPeriod) && this.payFrequency.equals(other.payFrequency) && this.payCurrency.equals(other.payCurrency) && this.payGroup.equals(other.payGroup) && this.flsaStatus.equals(other.flsaStatus) && this.effectiveDate.equals(other.effectiveDate) && this.employmentType.equals(other.employmentType) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.employee, this.jobTitle, this.payRate, this.payPeriod, this.payFrequency, this.payCurrency, this.payGroup, this.flsaStatus, this.effectiveDate, this.employmentType, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<EmploymentEmployee> employee = Optional.empty();
        private Optional<String> jobTitle = Optional.empty();
        private Optional<Double> payRate = Optional.empty();
        private Optional<EmploymentPayPeriod> payPeriod = Optional.empty();
        private Optional<EmploymentPayFrequency> payFrequency = Optional.empty();
        private Optional<EmploymentPayCurrency> payCurrency = Optional.empty();
        private Optional<EmploymentPayGroup> payGroup = Optional.empty();
        private Optional<EmploymentFlsaStatus> flsaStatus = Optional.empty();
        private Optional<OffsetDateTime> effectiveDate = Optional.empty();
        private Optional<EmploymentEmploymentType> employmentType = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Employment other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.employee(other.getEmployee());
            this.jobTitle(other.getJobTitle());
            this.payRate(other.getPayRate());
            this.payPeriod(other.getPayPeriod());
            this.payFrequency(other.getPayFrequency());
            this.payCurrency(other.getPayCurrency());
            this.payGroup(other.getPayGroup());
            this.flsaStatus(other.getFlsaStatus());
            this.effectiveDate(other.getEffectiveDate());
            this.employmentType(other.getEmploymentType());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="employee", nulls=Nulls.SKIP)
        public Builder employee(Optional<EmploymentEmployee> employee) {
            this.employee = employee;
            return this;
        }

        public Builder employee(EmploymentEmployee employee) {
            this.employee = Optional.of(employee);
            return this;
        }

        @JsonSetter(value="job_title", nulls=Nulls.SKIP)
        public Builder jobTitle(Optional<String> jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        public Builder jobTitle(String jobTitle) {
            this.jobTitle = Optional.of(jobTitle);
            return this;
        }

        @JsonSetter(value="pay_rate", nulls=Nulls.SKIP)
        public Builder payRate(Optional<Double> payRate) {
            this.payRate = payRate;
            return this;
        }

        public Builder payRate(Double payRate) {
            this.payRate = Optional.of(payRate);
            return this;
        }

        @JsonSetter(value="pay_period", nulls=Nulls.SKIP)
        public Builder payPeriod(Optional<EmploymentPayPeriod> payPeriod) {
            this.payPeriod = payPeriod;
            return this;
        }

        public Builder payPeriod(EmploymentPayPeriod payPeriod) {
            this.payPeriod = Optional.of(payPeriod);
            return this;
        }

        @JsonSetter(value="pay_frequency", nulls=Nulls.SKIP)
        public Builder payFrequency(Optional<EmploymentPayFrequency> payFrequency) {
            this.payFrequency = payFrequency;
            return this;
        }

        public Builder payFrequency(EmploymentPayFrequency payFrequency) {
            this.payFrequency = Optional.of(payFrequency);
            return this;
        }

        @JsonSetter(value="pay_currency", nulls=Nulls.SKIP)
        public Builder payCurrency(Optional<EmploymentPayCurrency> payCurrency) {
            this.payCurrency = payCurrency;
            return this;
        }

        public Builder payCurrency(EmploymentPayCurrency payCurrency) {
            this.payCurrency = Optional.of(payCurrency);
            return this;
        }

        @JsonSetter(value="pay_group", nulls=Nulls.SKIP)
        public Builder payGroup(Optional<EmploymentPayGroup> payGroup) {
            this.payGroup = payGroup;
            return this;
        }

        public Builder payGroup(EmploymentPayGroup payGroup) {
            this.payGroup = Optional.of(payGroup);
            return this;
        }

        @JsonSetter(value="flsa_status", nulls=Nulls.SKIP)
        public Builder flsaStatus(Optional<EmploymentFlsaStatus> flsaStatus) {
            this.flsaStatus = flsaStatus;
            return this;
        }

        public Builder flsaStatus(EmploymentFlsaStatus flsaStatus) {
            this.flsaStatus = Optional.of(flsaStatus);
            return this;
        }

        @JsonSetter(value="effective_date", nulls=Nulls.SKIP)
        public Builder effectiveDate(Optional<OffsetDateTime> effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public Builder effectiveDate(OffsetDateTime effectiveDate) {
            this.effectiveDate = Optional.of(effectiveDate);
            return this;
        }

        @JsonSetter(value="employment_type", nulls=Nulls.SKIP)
        public Builder employmentType(Optional<EmploymentEmploymentType> employmentType) {
            this.employmentType = employmentType;
            return this;
        }

        public Builder employmentType(EmploymentEmploymentType employmentType) {
            this.employmentType = Optional.of(employmentType);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public Employment build() {
            return new Employment(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.employee, this.jobTitle, this.payRate, this.payPeriod, this.payFrequency, this.payCurrency, this.payGroup, this.flsaStatus, this.effectiveDate, this.employmentType, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

