/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.hris.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.hris.types.LocationCountry;
import com.merge.api.resources.hris.types.LocationLocationType;
import com.merge.api.resources.hris.types.RemoteData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Location {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> name;
    private final Optional<String> phoneNumber;
    private final Optional<String> street1;
    private final Optional<String> street2;
    private final Optional<String> city;
    private final Optional<String> state;
    private final Optional<String> zipCode;
    private final Optional<LocationCountry> country;
    private final Optional<LocationLocationType> locationType;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Map<String, Object> additionalProperties;

    private Location(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> name, Optional<String> phoneNumber, Optional<String> street1, Optional<String> street2, Optional<String> city, Optional<String> state, Optional<String> zipCode, Optional<LocationCountry> country, Optional<LocationLocationType> locationType, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.name = name;
        this.phoneNumber = phoneNumber;
        this.street1 = street1;
        this.street2 = street2;
        this.city = city;
        this.state = state;
        this.zipCode = zipCode;
        this.country = country;
        this.locationType = locationType;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="phone_number")
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="street_1")
    public Optional<String> getStreet1() {
        return this.street1;
    }

    @JsonProperty(value="street_2")
    public Optional<String> getStreet2() {
        return this.street2;
    }

    @JsonProperty(value="city")
    public Optional<String> getCity() {
        return this.city;
    }

    @JsonProperty(value="state")
    public Optional<String> getState() {
        return this.state;
    }

    @JsonProperty(value="zip_code")
    public Optional<String> getZipCode() {
        return this.zipCode;
    }

    @JsonProperty(value="country")
    public Optional<LocationCountry> getCountry() {
        return this.country;
    }

    @JsonProperty(value="location_type")
    public Optional<LocationLocationType> getLocationType() {
        return this.locationType;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Location && this.equalTo((Location)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Location other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.name.equals(other.name) && this.phoneNumber.equals(other.phoneNumber) && this.street1.equals(other.street1) && this.street2.equals(other.street2) && this.city.equals(other.city) && this.state.equals(other.state) && this.zipCode.equals(other.zipCode) && this.country.equals(other.country) && this.locationType.equals(other.locationType) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.phoneNumber, this.street1, this.street2, this.city, this.state, this.zipCode, this.country, this.locationType, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> phoneNumber = Optional.empty();
        private Optional<String> street1 = Optional.empty();
        private Optional<String> street2 = Optional.empty();
        private Optional<String> city = Optional.empty();
        private Optional<String> state = Optional.empty();
        private Optional<String> zipCode = Optional.empty();
        private Optional<LocationCountry> country = Optional.empty();
        private Optional<LocationLocationType> locationType = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Location other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.name(other.getName());
            this.phoneNumber(other.getPhoneNumber());
            this.street1(other.getStreet1());
            this.street2(other.getStreet2());
            this.city(other.getCity());
            this.state(other.getState());
            this.zipCode(other.getZipCode());
            this.country(other.getCountry());
            this.locationType(other.getLocationType());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="phone_number", nulls=Nulls.SKIP)
        public Builder phoneNumber(Optional<String> phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Optional.of(phoneNumber);
            return this;
        }

        @JsonSetter(value="street_1", nulls=Nulls.SKIP)
        public Builder street1(Optional<String> street1) {
            this.street1 = street1;
            return this;
        }

        public Builder street1(String street1) {
            this.street1 = Optional.of(street1);
            return this;
        }

        @JsonSetter(value="street_2", nulls=Nulls.SKIP)
        public Builder street2(Optional<String> street2) {
            this.street2 = street2;
            return this;
        }

        public Builder street2(String street2) {
            this.street2 = Optional.of(street2);
            return this;
        }

        @JsonSetter(value="city", nulls=Nulls.SKIP)
        public Builder city(Optional<String> city) {
            this.city = city;
            return this;
        }

        public Builder city(String city) {
            this.city = Optional.of(city);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<String> state) {
            this.state = state;
            return this;
        }

        public Builder state(String state) {
            this.state = Optional.of(state);
            return this;
        }

        @JsonSetter(value="zip_code", nulls=Nulls.SKIP)
        public Builder zipCode(Optional<String> zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public Builder zipCode(String zipCode) {
            this.zipCode = Optional.of(zipCode);
            return this;
        }

        @JsonSetter(value="country", nulls=Nulls.SKIP)
        public Builder country(Optional<LocationCountry> country) {
            this.country = country;
            return this;
        }

        public Builder country(LocationCountry country) {
            this.country = Optional.of(country);
            return this;
        }

        @JsonSetter(value="location_type", nulls=Nulls.SKIP)
        public Builder locationType(Optional<LocationLocationType> locationType) {
            this.locationType = locationType;
            return this;
        }

        public Builder locationType(LocationLocationType locationType) {
            this.locationType = Optional.of(locationType);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public Location build() {
            return new Location(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.phoneNumber, this.street1, this.street2, this.city, this.state, this.zipCode, this.country, this.locationType, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

