/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.hris.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.hris.types.TimeOffRequestApprover;
import com.merge.api.resources.hris.types.TimeOffRequestEmployee;
import com.merge.api.resources.hris.types.TimeOffRequestRequestType;
import com.merge.api.resources.hris.types.TimeOffRequestStatus;
import com.merge.api.resources.hris.types.TimeOffRequestUnits;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class TimeOffRequest {
    private final Optional<TimeOffRequestEmployee> employee;
    private final Optional<TimeOffRequestApprover> approver;
    private final Optional<TimeOffRequestStatus> status;
    private final Optional<String> employeeNote;
    private final Optional<TimeOffRequestUnits> units;
    private final Optional<Double> amount;
    private final Optional<TimeOffRequestRequestType> requestType;
    private final Optional<OffsetDateTime> startTime;
    private final Optional<OffsetDateTime> endTime;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Map<String, Object> additionalProperties;

    private TimeOffRequest(Optional<TimeOffRequestEmployee> employee, Optional<TimeOffRequestApprover> approver, Optional<TimeOffRequestStatus> status, Optional<String> employeeNote, Optional<TimeOffRequestUnits> units, Optional<Double> amount, Optional<TimeOffRequestRequestType> requestType, Optional<OffsetDateTime> startTime, Optional<OffsetDateTime> endTime, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Map<String, Object> additionalProperties) {
        this.employee = employee;
        this.approver = approver;
        this.status = status;
        this.employeeNote = employeeNote;
        this.units = units;
        this.amount = amount;
        this.requestType = requestType;
        this.startTime = startTime;
        this.endTime = endTime;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="employee")
    public Optional<TimeOffRequestEmployee> getEmployee() {
        return this.employee;
    }

    @JsonProperty(value="approver")
    public Optional<TimeOffRequestApprover> getApprover() {
        return this.approver;
    }

    @JsonProperty(value="status")
    public Optional<TimeOffRequestStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="employee_note")
    public Optional<String> getEmployeeNote() {
        return this.employeeNote;
    }

    @JsonProperty(value="units")
    public Optional<TimeOffRequestUnits> getUnits() {
        return this.units;
    }

    @JsonProperty(value="amount")
    public Optional<Double> getAmount() {
        return this.amount;
    }

    @JsonProperty(value="request_type")
    public Optional<TimeOffRequestRequestType> getRequestType() {
        return this.requestType;
    }

    @JsonProperty(value="start_time")
    public Optional<OffsetDateTime> getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="end_time")
    public Optional<OffsetDateTime> getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TimeOffRequest && this.equalTo((TimeOffRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TimeOffRequest other) {
        return this.employee.equals(other.employee) && this.approver.equals(other.approver) && this.status.equals(other.status) && this.employeeNote.equals(other.employeeNote) && this.units.equals(other.units) && this.amount.equals(other.amount) && this.requestType.equals(other.requestType) && this.startTime.equals(other.startTime) && this.endTime.equals(other.endTime) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams);
    }

    public int hashCode() {
        return Objects.hash(this.employee, this.approver, this.status, this.employeeNote, this.units, this.amount, this.requestType, this.startTime, this.endTime, this.integrationParams, this.linkedAccountParams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<TimeOffRequestEmployee> employee = Optional.empty();
        private Optional<TimeOffRequestApprover> approver = Optional.empty();
        private Optional<TimeOffRequestStatus> status = Optional.empty();
        private Optional<String> employeeNote = Optional.empty();
        private Optional<TimeOffRequestUnits> units = Optional.empty();
        private Optional<Double> amount = Optional.empty();
        private Optional<TimeOffRequestRequestType> requestType = Optional.empty();
        private Optional<OffsetDateTime> startTime = Optional.empty();
        private Optional<OffsetDateTime> endTime = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TimeOffRequest other) {
            this.employee(other.getEmployee());
            this.approver(other.getApprover());
            this.status(other.getStatus());
            this.employeeNote(other.getEmployeeNote());
            this.units(other.getUnits());
            this.amount(other.getAmount());
            this.requestType(other.getRequestType());
            this.startTime(other.getStartTime());
            this.endTime(other.getEndTime());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            return this;
        }

        @JsonSetter(value="employee", nulls=Nulls.SKIP)
        public Builder employee(Optional<TimeOffRequestEmployee> employee) {
            this.employee = employee;
            return this;
        }

        public Builder employee(TimeOffRequestEmployee employee) {
            this.employee = Optional.of(employee);
            return this;
        }

        @JsonSetter(value="approver", nulls=Nulls.SKIP)
        public Builder approver(Optional<TimeOffRequestApprover> approver) {
            this.approver = approver;
            return this;
        }

        public Builder approver(TimeOffRequestApprover approver) {
            this.approver = Optional.of(approver);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<TimeOffRequestStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(TimeOffRequestStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="employee_note", nulls=Nulls.SKIP)
        public Builder employeeNote(Optional<String> employeeNote) {
            this.employeeNote = employeeNote;
            return this;
        }

        public Builder employeeNote(String employeeNote) {
            this.employeeNote = Optional.of(employeeNote);
            return this;
        }

        @JsonSetter(value="units", nulls=Nulls.SKIP)
        public Builder units(Optional<TimeOffRequestUnits> units) {
            this.units = units;
            return this;
        }

        public Builder units(TimeOffRequestUnits units) {
            this.units = Optional.of(units);
            return this;
        }

        @JsonSetter(value="amount", nulls=Nulls.SKIP)
        public Builder amount(Optional<Double> amount) {
            this.amount = amount;
            return this;
        }

        public Builder amount(Double amount) {
            this.amount = Optional.of(amount);
            return this;
        }

        @JsonSetter(value="request_type", nulls=Nulls.SKIP)
        public Builder requestType(Optional<TimeOffRequestRequestType> requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder requestType(TimeOffRequestRequestType requestType) {
            this.requestType = Optional.of(requestType);
            return this;
        }

        @JsonSetter(value="start_time", nulls=Nulls.SKIP)
        public Builder startTime(Optional<OffsetDateTime> startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder startTime(OffsetDateTime startTime) {
            this.startTime = Optional.of(startTime);
            return this;
        }

        @JsonSetter(value="end_time", nulls=Nulls.SKIP)
        public Builder endTime(Optional<OffsetDateTime> endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder endTime(OffsetDateTime endTime) {
            this.endTime = Optional.of(endTime);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        public TimeOffRequest build() {
            return new TimeOffRequest(this.employee, this.approver, this.status, this.employeeNote, this.units, this.amount, this.requestType, this.startTime, this.endTime, this.integrationParams, this.linkedAccountParams, this.additionalProperties);
        }
    }
}

