/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.hris.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class TimesheetEntry {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> employee;
    private final Optional<Double> hoursWorked;
    private final Optional<OffsetDateTime> startTime;
    private final Optional<OffsetDateTime> endTime;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<Optional<Map<String, JsonNode>>>> remoteData;
    private final Map<String, Object> additionalProperties;

    private TimesheetEntry(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> employee, Optional<Double> hoursWorked, Optional<OffsetDateTime> startTime, Optional<OffsetDateTime> endTime, Optional<Boolean> remoteWasDeleted, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<Optional<Map<String, JsonNode>>>> remoteData, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.employee = employee;
        this.hoursWorked = hoursWorked;
        this.startTime = startTime;
        this.endTime = endTime;
        this.remoteWasDeleted = remoteWasDeleted;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="employee")
    public Optional<String> getEmployee() {
        return this.employee;
    }

    @JsonProperty(value="hours_worked")
    public Optional<Double> getHoursWorked() {
        return this.hoursWorked;
    }

    @JsonProperty(value="start_time")
    public Optional<OffsetDateTime> getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="end_time")
    public Optional<OffsetDateTime> getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<Optional<Map<String, JsonNode>>>> getRemoteData() {
        return this.remoteData;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TimesheetEntry && this.equalTo((TimesheetEntry)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TimesheetEntry other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.employee.equals(other.employee) && this.hoursWorked.equals(other.hoursWorked) && this.startTime.equals(other.startTime) && this.endTime.equals(other.endTime) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.employee, this.hoursWorked, this.startTime, this.endTime, this.remoteWasDeleted, this.fieldMappings, this.remoteData);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> employee = Optional.empty();
        private Optional<Double> hoursWorked = Optional.empty();
        private Optional<OffsetDateTime> startTime = Optional.empty();
        private Optional<OffsetDateTime> endTime = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<Optional<Map<String, JsonNode>>>> remoteData = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(TimesheetEntry other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.employee(other.getEmployee());
            this.hoursWorked(other.getHoursWorked());
            this.startTime(other.getStartTime());
            this.endTime(other.getEndTime());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="employee", nulls=Nulls.SKIP)
        public Builder employee(Optional<String> employee) {
            this.employee = employee;
            return this;
        }

        public Builder employee(String employee) {
            this.employee = Optional.of(employee);
            return this;
        }

        @JsonSetter(value="hours_worked", nulls=Nulls.SKIP)
        public Builder hoursWorked(Optional<Double> hoursWorked) {
            this.hoursWorked = hoursWorked;
            return this;
        }

        public Builder hoursWorked(Double hoursWorked) {
            this.hoursWorked = Optional.of(hoursWorked);
            return this;
        }

        @JsonSetter(value="start_time", nulls=Nulls.SKIP)
        public Builder startTime(Optional<OffsetDateTime> startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder startTime(OffsetDateTime startTime) {
            this.startTime = Optional.of(startTime);
            return this;
        }

        @JsonSetter(value="end_time", nulls=Nulls.SKIP)
        public Builder endTime(Optional<OffsetDateTime> endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder endTime(OffsetDateTime endTime) {
            this.endTime = Optional.of(endTime);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<Optional<Map<String, JsonNode>>>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<Optional<Map<String, JsonNode>>> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        public TimesheetEntry build() {
            return new TimesheetEntry(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.employee, this.hoursWorked, this.startTime, this.endTime, this.remoteWasDeleted, this.fieldMappings, this.remoteData, this.additionalProperties);
        }
    }
}

