/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ticketing.attachments.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ticketing.types.AttachmentRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class TicketingAttachmentEndpointRequest {
    private final Optional<Boolean> isDebugMode;
    private final Optional<Boolean> runAsync;
    private final AttachmentRequest model;
    private final Map<String, Object> additionalProperties;

    private TicketingAttachmentEndpointRequest(Optional<Boolean> isDebugMode, Optional<Boolean> runAsync, AttachmentRequest model, Map<String, Object> additionalProperties) {
        this.isDebugMode = isDebugMode;
        this.runAsync = runAsync;
        this.model = model;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="is_debug_mode")
    public Optional<Boolean> getIsDebugMode() {
        return this.isDebugMode;
    }

    @JsonProperty(value="run_async")
    public Optional<Boolean> getRunAsync() {
        return this.runAsync;
    }

    @JsonProperty(value="model")
    public AttachmentRequest getModel() {
        return this.model;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketingAttachmentEndpointRequest && this.equalTo((TicketingAttachmentEndpointRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketingAttachmentEndpointRequest other) {
        return this.isDebugMode.equals(other.isDebugMode) && this.runAsync.equals(other.runAsync) && this.model.equals(other.model);
    }

    public int hashCode() {
        return Objects.hash(this.isDebugMode, this.runAsync, this.model);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ModelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ModelStage,
    _FinalStage {
        private AttachmentRequest model;
        private Optional<Boolean> runAsync = Optional.empty();
        private Optional<Boolean> isDebugMode = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TicketingAttachmentEndpointRequest other) {
            this.isDebugMode(other.getIsDebugMode());
            this.runAsync(other.getRunAsync());
            this.model(other.getModel());
            return this;
        }

        @Override
        @JsonSetter(value="model")
        public _FinalStage model(AttachmentRequest model) {
            this.model = model;
            return this;
        }

        @Override
        public _FinalStage runAsync(Boolean runAsync) {
            this.runAsync = Optional.of(runAsync);
            return this;
        }

        @Override
        @JsonSetter(value="run_async", nulls=Nulls.SKIP)
        public _FinalStage runAsync(Optional<Boolean> runAsync) {
            this.runAsync = runAsync;
            return this;
        }

        @Override
        public _FinalStage isDebugMode(Boolean isDebugMode) {
            this.isDebugMode = Optional.of(isDebugMode);
            return this;
        }

        @Override
        @JsonSetter(value="is_debug_mode", nulls=Nulls.SKIP)
        public _FinalStage isDebugMode(Optional<Boolean> isDebugMode) {
            this.isDebugMode = isDebugMode;
            return this;
        }

        @Override
        public TicketingAttachmentEndpointRequest build() {
            return new TicketingAttachmentEndpointRequest(this.isDebugMode, this.runAsync, this.model, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TicketingAttachmentEndpointRequest build();

        public _FinalStage isDebugMode(Optional<Boolean> var1);

        public _FinalStage isDebugMode(Boolean var1);

        public _FinalStage runAsync(Optional<Boolean> var1);

        public _FinalStage runAsync(Boolean var1);
    }

    public static interface ModelStage {
        public _FinalStage model(AttachmentRequest var1);

        public Builder from(TicketingAttachmentEndpointRequest var1);
    }
}

