/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ticketing.comments;

import com.merge.api.core.ApiError;
import com.merge.api.core.ClientOptions;
import com.merge.api.core.MediaTypes;
import com.merge.api.core.MergeException;
import com.merge.api.core.ObjectMappers;
import com.merge.api.core.RequestOptions;
import com.merge.api.resources.ticketing.comments.requests.CommentEndpointRequest;
import com.merge.api.resources.ticketing.comments.requests.CommentsListRequest;
import com.merge.api.resources.ticketing.comments.requests.CommentsRetrieveRequest;
import com.merge.api.resources.ticketing.types.Comment;
import com.merge.api.resources.ticketing.types.CommentRequest;
import com.merge.api.resources.ticketing.types.CommentResponse;
import com.merge.api.resources.ticketing.types.MetaResponse;
import com.merge.api.resources.ticketing.types.PaginatedCommentList;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class CommentsClient {
    protected final ClientOptions clientOptions;

    public CommentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public PaginatedCommentList list() {
        return this.list(CommentsListRequest.builder().build());
    }

    public PaginatedCommentList list(CommentsListRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PaginatedCommentList list(CommentsListRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ticketing/v1/comments");
        if (request.getCreatedAfter().isPresent()) {
            httpUrl.addQueryParameter("created_after", request.getCreatedAfter().get().toString());
        }
        if (request.getCreatedBefore().isPresent()) {
            httpUrl.addQueryParameter("created_before", request.getCreatedBefore().get().toString());
        }
        if (request.getCursor().isPresent()) {
            httpUrl.addQueryParameter("cursor", request.getCursor().get());
        }
        if (request.getExpand().isPresent()) {
            httpUrl.addQueryParameter("expand", request.getExpand().get().toString());
        }
        if (request.getIncludeDeletedData().isPresent()) {
            httpUrl.addQueryParameter("include_deleted_data", request.getIncludeDeletedData().get().toString());
        }
        if (request.getIncludeRemoteData().isPresent()) {
            httpUrl.addQueryParameter("include_remote_data", request.getIncludeRemoteData().get().toString());
        }
        if (request.getIncludeShellData().isPresent()) {
            httpUrl.addQueryParameter("include_shell_data", request.getIncludeShellData().get().toString());
        }
        if (request.getModifiedAfter().isPresent()) {
            httpUrl.addQueryParameter("modified_after", request.getModifiedAfter().get().toString());
        }
        if (request.getModifiedBefore().isPresent()) {
            httpUrl.addQueryParameter("modified_before", request.getModifiedBefore().get().toString());
        }
        if (request.getPageSize().isPresent()) {
            httpUrl.addQueryParameter("page_size", request.getPageSize().get().toString());
        }
        if (request.getRemoteCreatedAfter().isPresent()) {
            httpUrl.addQueryParameter("remote_created_after", request.getRemoteCreatedAfter().get().toString());
        }
        if (request.getRemoteId().isPresent()) {
            httpUrl.addQueryParameter("remote_id", request.getRemoteId().get());
        }
        if (request.getTicketId().isPresent()) {
            httpUrl.addQueryParameter("ticket_id", request.getTicketId().get());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                PaginatedCommentList paginatedCommentList = (PaginatedCommentList)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), PaginatedCommentList.class);
                return paginatedCommentList;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public CommentResponse create(CommentEndpointRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommentResponse create(CommentEndpointRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ticketing/v1/comments");
        if (request.getIsDebugMode().isPresent()) {
            httpUrl.addQueryParameter("is_debug_mode", request.getIsDebugMode().get().toString());
        }
        if (request.getRunAsync().isPresent()) {
            httpUrl.addQueryParameter("run_async", request.getRunAsync().get().toString());
        }
        HashMap<String, CommentRequest> properties = new HashMap<String, CommentRequest>();
        properties.put("model", request.getModel());
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes(properties), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                CommentResponse commentResponse = (CommentResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CommentResponse.class);
                return commentResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public Comment retrieve(String id) {
        return this.retrieve(id, CommentsRetrieveRequest.builder().build());
    }

    public Comment retrieve(String id, CommentsRetrieveRequest request) {
        return this.retrieve(id, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Comment retrieve(String id, CommentsRetrieveRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ticketing/v1/comments").addPathSegment(id);
        if (request.getExpand().isPresent()) {
            httpUrl.addQueryParameter("expand", request.getExpand().get().toString());
        }
        if (request.getIncludeRemoteData().isPresent()) {
            httpUrl.addQueryParameter("include_remote_data", request.getIncludeRemoteData().get().toString());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                Comment comment = (Comment)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Comment.class);
                return comment;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public MetaResponse metaPostRetrieve() {
        return this.metaPostRetrieve(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MetaResponse metaPostRetrieve(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ticketing/v1/comments/meta/post").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                MetaResponse metaResponse = (MetaResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), MetaResponse.class);
                return metaResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }
}

