/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ticketing.fieldmapping;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.merge.api.core.ApiError;
import com.merge.api.core.ClientOptions;
import com.merge.api.core.MediaTypes;
import com.merge.api.core.MergeException;
import com.merge.api.core.ObjectMappers;
import com.merge.api.core.RequestOptions;
import com.merge.api.resources.ticketing.fieldmapping.requests.CreateFieldMappingRequest;
import com.merge.api.resources.ticketing.fieldmapping.requests.PatchedEditFieldMappingRequest;
import com.merge.api.resources.ticketing.fieldmapping.requests.RemoteFieldsRetrieveRequest;
import com.merge.api.resources.ticketing.types.ExternalTargetFieldApiResponse;
import com.merge.api.resources.ticketing.types.FieldMappingApiInstanceResponse;
import com.merge.api.resources.ticketing.types.FieldMappingInstanceResponse;
import com.merge.api.resources.ticketing.types.RemoteFieldApiResponse;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class FieldMappingClient {
    protected final ClientOptions clientOptions;

    public FieldMappingClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public FieldMappingApiInstanceResponse fieldMappingsRetrieve() {
        return this.fieldMappingsRetrieve(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FieldMappingApiInstanceResponse fieldMappingsRetrieve(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ticketing/v1/field-mappings").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                FieldMappingApiInstanceResponse fieldMappingApiInstanceResponse = (FieldMappingApiInstanceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), FieldMappingApiInstanceResponse.class);
                return fieldMappingApiInstanceResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public FieldMappingInstanceResponse fieldMappingsCreate(CreateFieldMappingRequest request) {
        return this.fieldMappingsCreate(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FieldMappingInstanceResponse fieldMappingsCreate(CreateFieldMappingRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ticketing/v1/field-mappings").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new MergeException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                FieldMappingInstanceResponse fieldMappingInstanceResponse = (FieldMappingInstanceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), FieldMappingInstanceResponse.class);
                return fieldMappingInstanceResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public FieldMappingInstanceResponse fieldMappingsDestroy(String fieldMappingId) {
        return this.fieldMappingsDestroy(fieldMappingId, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FieldMappingInstanceResponse fieldMappingsDestroy(String fieldMappingId, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ticketing/v1/field-mappings").addPathSegment(fieldMappingId).build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                FieldMappingInstanceResponse fieldMappingInstanceResponse = (FieldMappingInstanceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), FieldMappingInstanceResponse.class);
                return fieldMappingInstanceResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public FieldMappingInstanceResponse fieldMappingsPartialUpdate(String fieldMappingId) {
        return this.fieldMappingsPartialUpdate(fieldMappingId, PatchedEditFieldMappingRequest.builder().build());
    }

    public FieldMappingInstanceResponse fieldMappingsPartialUpdate(String fieldMappingId, PatchedEditFieldMappingRequest request) {
        return this.fieldMappingsPartialUpdate(fieldMappingId, request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FieldMappingInstanceResponse fieldMappingsPartialUpdate(String fieldMappingId, PatchedEditFieldMappingRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ticketing/v1/field-mappings").addPathSegment(fieldMappingId).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new MergeException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PATCH", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                FieldMappingInstanceResponse fieldMappingInstanceResponse = (FieldMappingInstanceResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), FieldMappingInstanceResponse.class);
                return fieldMappingInstanceResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public RemoteFieldApiResponse remoteFieldsRetrieve() {
        return this.remoteFieldsRetrieve(RemoteFieldsRetrieveRequest.builder().build());
    }

    public RemoteFieldApiResponse remoteFieldsRetrieve(RemoteFieldsRetrieveRequest request) {
        return this.remoteFieldsRetrieve(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RemoteFieldApiResponse remoteFieldsRetrieve(RemoteFieldsRetrieveRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ticketing/v1/remote-fields");
        if (request.getCommonModels().isPresent()) {
            httpUrl.addQueryParameter("common_models", request.getCommonModels().get());
        }
        if (request.getIncludeExampleValues().isPresent()) {
            httpUrl.addQueryParameter("include_example_values", request.getIncludeExampleValues().get());
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                RemoteFieldApiResponse remoteFieldApiResponse = (RemoteFieldApiResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), RemoteFieldApiResponse.class);
                return remoteFieldApiResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }

    public ExternalTargetFieldApiResponse targetFieldsRetrieve() {
        return this.targetFieldsRetrieve(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExternalTargetFieldApiResponse targetFieldsRetrieve(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("ticketing/v1/target-fields").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ExternalTargetFieldApiResponse externalTargetFieldApiResponse = (ExternalTargetFieldApiResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ExternalTargetFieldApiResponse.class);
                return externalTargetFieldApiResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new ApiError("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class));
        }
        catch (IOException e) {
            throw new MergeException("Network error executing HTTP request", e);
        }
    }
}

