/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ticketing.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ticketing.types.CommentRequestContact;
import com.merge.api.resources.ticketing.types.CommentRequestTicket;
import com.merge.api.resources.ticketing.types.CommentRequestUser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CommentRequest {
    private final Optional<CommentRequestUser> user;
    private final Optional<CommentRequestContact> contact;
    private final Optional<String> body;
    private final Optional<String> htmlBody;
    private final Optional<CommentRequestTicket> ticket;
    private final Optional<Boolean> isPrivate;
    private final Optional<Map<String, JsonNode>> integrationParams;
    private final Optional<Map<String, JsonNode>> linkedAccountParams;
    private final Map<String, Object> additionalProperties;

    private CommentRequest(Optional<CommentRequestUser> user, Optional<CommentRequestContact> contact, Optional<String> body, Optional<String> htmlBody, Optional<CommentRequestTicket> ticket, Optional<Boolean> isPrivate, Optional<Map<String, JsonNode>> integrationParams, Optional<Map<String, JsonNode>> linkedAccountParams, Map<String, Object> additionalProperties) {
        this.user = user;
        this.contact = contact;
        this.body = body;
        this.htmlBody = htmlBody;
        this.ticket = ticket;
        this.isPrivate = isPrivate;
        this.integrationParams = integrationParams;
        this.linkedAccountParams = linkedAccountParams;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="user")
    public Optional<CommentRequestUser> getUser() {
        return this.user;
    }

    @JsonProperty(value="contact")
    public Optional<CommentRequestContact> getContact() {
        return this.contact;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="html_body")
    public Optional<String> getHtmlBody() {
        return this.htmlBody;
    }

    @JsonProperty(value="ticket")
    public Optional<CommentRequestTicket> getTicket() {
        return this.ticket;
    }

    @JsonProperty(value="is_private")
    public Optional<Boolean> getIsPrivate() {
        return this.isPrivate;
    }

    @JsonProperty(value="integration_params")
    public Optional<Map<String, JsonNode>> getIntegrationParams() {
        return this.integrationParams;
    }

    @JsonProperty(value="linked_account_params")
    public Optional<Map<String, JsonNode>> getLinkedAccountParams() {
        return this.linkedAccountParams;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CommentRequest && this.equalTo((CommentRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CommentRequest other) {
        return this.user.equals(other.user) && this.contact.equals(other.contact) && this.body.equals(other.body) && this.htmlBody.equals(other.htmlBody) && this.ticket.equals(other.ticket) && this.isPrivate.equals(other.isPrivate) && this.integrationParams.equals(other.integrationParams) && this.linkedAccountParams.equals(other.linkedAccountParams);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.contact, this.body, this.htmlBody, this.ticket, this.isPrivate, this.integrationParams, this.linkedAccountParams);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CommentRequestUser> user = Optional.empty();
        private Optional<CommentRequestContact> contact = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Optional<String> htmlBody = Optional.empty();
        private Optional<CommentRequestTicket> ticket = Optional.empty();
        private Optional<Boolean> isPrivate = Optional.empty();
        private Optional<Map<String, JsonNode>> integrationParams = Optional.empty();
        private Optional<Map<String, JsonNode>> linkedAccountParams = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CommentRequest other) {
            this.user(other.getUser());
            this.contact(other.getContact());
            this.body(other.getBody());
            this.htmlBody(other.getHtmlBody());
            this.ticket(other.getTicket());
            this.isPrivate(other.getIsPrivate());
            this.integrationParams(other.getIntegrationParams());
            this.linkedAccountParams(other.getLinkedAccountParams());
            return this;
        }

        @JsonSetter(value="user", nulls=Nulls.SKIP)
        public Builder user(Optional<CommentRequestUser> user) {
            this.user = user;
            return this;
        }

        public Builder user(CommentRequestUser user) {
            this.user = Optional.of(user);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<CommentRequestContact> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(CommentRequestContact contact) {
            this.contact = Optional.of(contact);
            return this;
        }

        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public Builder body(Optional<String> body) {
            this.body = body;
            return this;
        }

        public Builder body(String body) {
            this.body = Optional.of(body);
            return this;
        }

        @JsonSetter(value="html_body", nulls=Nulls.SKIP)
        public Builder htmlBody(Optional<String> htmlBody) {
            this.htmlBody = htmlBody;
            return this;
        }

        public Builder htmlBody(String htmlBody) {
            this.htmlBody = Optional.of(htmlBody);
            return this;
        }

        @JsonSetter(value="ticket", nulls=Nulls.SKIP)
        public Builder ticket(Optional<CommentRequestTicket> ticket) {
            this.ticket = ticket;
            return this;
        }

        public Builder ticket(CommentRequestTicket ticket) {
            this.ticket = Optional.of(ticket);
            return this;
        }

        @JsonSetter(value="is_private", nulls=Nulls.SKIP)
        public Builder isPrivate(Optional<Boolean> isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        public Builder isPrivate(Boolean isPrivate) {
            this.isPrivate = Optional.of(isPrivate);
            return this;
        }

        @JsonSetter(value="integration_params", nulls=Nulls.SKIP)
        public Builder integrationParams(Optional<Map<String, JsonNode>> integrationParams) {
            this.integrationParams = integrationParams;
            return this;
        }

        public Builder integrationParams(Map<String, JsonNode> integrationParams) {
            this.integrationParams = Optional.of(integrationParams);
            return this;
        }

        @JsonSetter(value="linked_account_params", nulls=Nulls.SKIP)
        public Builder linkedAccountParams(Optional<Map<String, JsonNode>> linkedAccountParams) {
            this.linkedAccountParams = linkedAccountParams;
            return this;
        }

        public Builder linkedAccountParams(Map<String, JsonNode> linkedAccountParams) {
            this.linkedAccountParams = Optional.of(linkedAccountParams);
            return this;
        }

        public CommentRequest build() {
            return new CommentRequest(this.user, this.contact, this.body, this.htmlBody, this.ticket, this.isPrivate, this.integrationParams, this.linkedAccountParams, this.additionalProperties);
        }
    }
}

