/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ticketing.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ticketing.types.ItemSchema;
import com.merge.api.resources.ticketing.types.RemoteFieldClassFieldChoicesItem;
import com.merge.api.resources.ticketing.types.RemoteFieldClassFieldFormat;
import com.merge.api.resources.ticketing.types.RemoteFieldClassFieldType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class RemoteFieldClass {
    private final Optional<String> id;
    private final Optional<String> displayName;
    private final Optional<String> remoteKeyName;
    private final Optional<String> description;
    private final Optional<Boolean> isCustom;
    private final Optional<Boolean> isRequired;
    private final Optional<RemoteFieldClassFieldType> fieldType;
    private final Optional<RemoteFieldClassFieldFormat> fieldFormat;
    private final Optional<List<RemoteFieldClassFieldChoicesItem>> fieldChoices;
    private final Optional<ItemSchema> itemSchema;
    private final Map<String, Object> additionalProperties;

    private RemoteFieldClass(Optional<String> id, Optional<String> displayName, Optional<String> remoteKeyName, Optional<String> description, Optional<Boolean> isCustom, Optional<Boolean> isRequired, Optional<RemoteFieldClassFieldType> fieldType, Optional<RemoteFieldClassFieldFormat> fieldFormat, Optional<List<RemoteFieldClassFieldChoicesItem>> fieldChoices, Optional<ItemSchema> itemSchema, Map<String, Object> additionalProperties) {
        this.id = id;
        this.displayName = displayName;
        this.remoteKeyName = remoteKeyName;
        this.description = description;
        this.isCustom = isCustom;
        this.isRequired = isRequired;
        this.fieldType = fieldType;
        this.fieldFormat = fieldFormat;
        this.fieldChoices = fieldChoices;
        this.itemSchema = itemSchema;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="display_name")
    public Optional<String> getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="remote_key_name")
    public Optional<String> getRemoteKeyName() {
        return this.remoteKeyName;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="is_custom")
    public Optional<Boolean> getIsCustom() {
        return this.isCustom;
    }

    @JsonProperty(value="is_required")
    public Optional<Boolean> getIsRequired() {
        return this.isRequired;
    }

    @JsonProperty(value="field_type")
    public Optional<RemoteFieldClassFieldType> getFieldType() {
        return this.fieldType;
    }

    @JsonProperty(value="field_format")
    public Optional<RemoteFieldClassFieldFormat> getFieldFormat() {
        return this.fieldFormat;
    }

    @JsonProperty(value="field_choices")
    public Optional<List<RemoteFieldClassFieldChoicesItem>> getFieldChoices() {
        return this.fieldChoices;
    }

    @JsonProperty(value="item_schema")
    public Optional<ItemSchema> getItemSchema() {
        return this.itemSchema;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RemoteFieldClass && this.equalTo((RemoteFieldClass)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RemoteFieldClass other) {
        return this.id.equals(other.id) && this.displayName.equals(other.displayName) && this.remoteKeyName.equals(other.remoteKeyName) && this.description.equals(other.description) && this.isCustom.equals(other.isCustom) && this.isRequired.equals(other.isRequired) && this.fieldType.equals(other.fieldType) && this.fieldFormat.equals(other.fieldFormat) && this.fieldChoices.equals(other.fieldChoices) && this.itemSchema.equals(other.itemSchema);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.displayName, this.remoteKeyName, this.description, this.isCustom, this.isRequired, this.fieldType, this.fieldFormat, this.fieldChoices, this.itemSchema);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> displayName = Optional.empty();
        private Optional<String> remoteKeyName = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<Boolean> isCustom = Optional.empty();
        private Optional<Boolean> isRequired = Optional.empty();
        private Optional<RemoteFieldClassFieldType> fieldType = Optional.empty();
        private Optional<RemoteFieldClassFieldFormat> fieldFormat = Optional.empty();
        private Optional<List<RemoteFieldClassFieldChoicesItem>> fieldChoices = Optional.empty();
        private Optional<ItemSchema> itemSchema = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RemoteFieldClass other) {
            this.id(other.getId());
            this.displayName(other.getDisplayName());
            this.remoteKeyName(other.getRemoteKeyName());
            this.description(other.getDescription());
            this.isCustom(other.getIsCustom());
            this.isRequired(other.getIsRequired());
            this.fieldType(other.getFieldType());
            this.fieldFormat(other.getFieldFormat());
            this.fieldChoices(other.getFieldChoices());
            this.itemSchema(other.getItemSchema());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="display_name", nulls=Nulls.SKIP)
        public Builder displayName(Optional<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = Optional.of(displayName);
            return this;
        }

        @JsonSetter(value="remote_key_name", nulls=Nulls.SKIP)
        public Builder remoteKeyName(Optional<String> remoteKeyName) {
            this.remoteKeyName = remoteKeyName;
            return this;
        }

        public Builder remoteKeyName(String remoteKeyName) {
            this.remoteKeyName = Optional.of(remoteKeyName);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="is_custom", nulls=Nulls.SKIP)
        public Builder isCustom(Optional<Boolean> isCustom) {
            this.isCustom = isCustom;
            return this;
        }

        public Builder isCustom(Boolean isCustom) {
            this.isCustom = Optional.of(isCustom);
            return this;
        }

        @JsonSetter(value="is_required", nulls=Nulls.SKIP)
        public Builder isRequired(Optional<Boolean> isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = Optional.of(isRequired);
            return this;
        }

        @JsonSetter(value="field_type", nulls=Nulls.SKIP)
        public Builder fieldType(Optional<RemoteFieldClassFieldType> fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public Builder fieldType(RemoteFieldClassFieldType fieldType) {
            this.fieldType = Optional.of(fieldType);
            return this;
        }

        @JsonSetter(value="field_format", nulls=Nulls.SKIP)
        public Builder fieldFormat(Optional<RemoteFieldClassFieldFormat> fieldFormat) {
            this.fieldFormat = fieldFormat;
            return this;
        }

        public Builder fieldFormat(RemoteFieldClassFieldFormat fieldFormat) {
            this.fieldFormat = Optional.of(fieldFormat);
            return this;
        }

        @JsonSetter(value="field_choices", nulls=Nulls.SKIP)
        public Builder fieldChoices(Optional<List<RemoteFieldClassFieldChoicesItem>> fieldChoices) {
            this.fieldChoices = fieldChoices;
            return this;
        }

        public Builder fieldChoices(List<RemoteFieldClassFieldChoicesItem> fieldChoices) {
            this.fieldChoices = Optional.of(fieldChoices);
            return this;
        }

        @JsonSetter(value="item_schema", nulls=Nulls.SKIP)
        public Builder itemSchema(Optional<ItemSchema> itemSchema) {
            this.itemSchema = itemSchema;
            return this;
        }

        public Builder itemSchema(ItemSchema itemSchema) {
            this.itemSchema = Optional.of(itemSchema);
            return this;
        }

        public RemoteFieldClass build() {
            return new RemoteFieldClass(this.id, this.displayName, this.remoteKeyName, this.description, this.isCustom, this.isRequired, this.fieldType, this.fieldFormat, this.fieldChoices, this.itemSchema, this.additionalProperties);
        }
    }
}

