/*
 * Decompiled with CFR 0.152.
 */
package com.merge.api.resources.ticketing.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.merge.api.core.ObjectMappers;
import com.merge.api.resources.ticketing.types.RemoteData;
import com.merge.api.resources.ticketing.types.RemoteField;
import com.merge.api.resources.ticketing.types.TicketAccount;
import com.merge.api.resources.ticketing.types.TicketAssigneesItem;
import com.merge.api.resources.ticketing.types.TicketAttachmentsItem;
import com.merge.api.resources.ticketing.types.TicketCollectionsItem;
import com.merge.api.resources.ticketing.types.TicketContact;
import com.merge.api.resources.ticketing.types.TicketCreator;
import com.merge.api.resources.ticketing.types.TicketParentTicket;
import com.merge.api.resources.ticketing.types.TicketPriority;
import com.merge.api.resources.ticketing.types.TicketStatus;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Ticket {
    private final Optional<String> id;
    private final Optional<String> remoteId;
    private final Optional<OffsetDateTime> createdAt;
    private final Optional<OffsetDateTime> modifiedAt;
    private final Optional<String> name;
    private final Optional<List<Optional<TicketAssigneesItem>>> assignees;
    private final Optional<TicketCreator> creator;
    private final Optional<OffsetDateTime> dueDate;
    private final Optional<TicketStatus> status;
    private final Optional<String> description;
    private final Optional<List<Optional<TicketCollectionsItem>>> collections;
    private final Optional<String> ticketType;
    private final Optional<TicketAccount> account;
    private final Optional<TicketContact> contact;
    private final Optional<TicketParentTicket> parentTicket;
    private final Optional<List<Optional<TicketAttachmentsItem>>> attachments;
    private final Optional<List<Optional<String>>> tags;
    private final Optional<OffsetDateTime> remoteCreatedAt;
    private final Optional<OffsetDateTime> remoteUpdatedAt;
    private final Optional<OffsetDateTime> completedAt;
    private final Optional<Boolean> remoteWasDeleted;
    private final Optional<String> ticketUrl;
    private final Optional<TicketPriority> priority;
    private final Optional<Map<String, JsonNode>> fieldMappings;
    private final Optional<List<RemoteData>> remoteData;
    private final Optional<List<RemoteField>> remoteFields;
    private final Map<String, Object> additionalProperties;

    private Ticket(Optional<String> id, Optional<String> remoteId, Optional<OffsetDateTime> createdAt, Optional<OffsetDateTime> modifiedAt, Optional<String> name, Optional<List<Optional<TicketAssigneesItem>>> assignees, Optional<TicketCreator> creator, Optional<OffsetDateTime> dueDate, Optional<TicketStatus> status, Optional<String> description, Optional<List<Optional<TicketCollectionsItem>>> collections, Optional<String> ticketType, Optional<TicketAccount> account, Optional<TicketContact> contact, Optional<TicketParentTicket> parentTicket, Optional<List<Optional<TicketAttachmentsItem>>> attachments, Optional<List<Optional<String>>> tags, Optional<OffsetDateTime> remoteCreatedAt, Optional<OffsetDateTime> remoteUpdatedAt, Optional<OffsetDateTime> completedAt, Optional<Boolean> remoteWasDeleted, Optional<String> ticketUrl, Optional<TicketPriority> priority, Optional<Map<String, JsonNode>> fieldMappings, Optional<List<RemoteData>> remoteData, Optional<List<RemoteField>> remoteFields, Map<String, Object> additionalProperties) {
        this.id = id;
        this.remoteId = remoteId;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.name = name;
        this.assignees = assignees;
        this.creator = creator;
        this.dueDate = dueDate;
        this.status = status;
        this.description = description;
        this.collections = collections;
        this.ticketType = ticketType;
        this.account = account;
        this.contact = contact;
        this.parentTicket = parentTicket;
        this.attachments = attachments;
        this.tags = tags;
        this.remoteCreatedAt = remoteCreatedAt;
        this.remoteUpdatedAt = remoteUpdatedAt;
        this.completedAt = completedAt;
        this.remoteWasDeleted = remoteWasDeleted;
        this.ticketUrl = ticketUrl;
        this.priority = priority;
        this.fieldMappings = fieldMappings;
        this.remoteData = remoteData;
        this.remoteFields = remoteFields;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="remote_id")
    public Optional<String> getRemoteId() {
        return this.remoteId;
    }

    @JsonProperty(value="created_at")
    public Optional<OffsetDateTime> getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="modified_at")
    public Optional<OffsetDateTime> getModifiedAt() {
        return this.modifiedAt;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="assignees")
    public Optional<List<Optional<TicketAssigneesItem>>> getAssignees() {
        return this.assignees;
    }

    @JsonProperty(value="creator")
    public Optional<TicketCreator> getCreator() {
        return this.creator;
    }

    @JsonProperty(value="due_date")
    public Optional<OffsetDateTime> getDueDate() {
        return this.dueDate;
    }

    @JsonProperty(value="status")
    public Optional<TicketStatus> getStatus() {
        return this.status;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="collections")
    public Optional<List<Optional<TicketCollectionsItem>>> getCollections() {
        return this.collections;
    }

    @JsonProperty(value="ticket_type")
    public Optional<String> getTicketType() {
        return this.ticketType;
    }

    @JsonProperty(value="account")
    public Optional<TicketAccount> getAccount() {
        return this.account;
    }

    @JsonProperty(value="contact")
    public Optional<TicketContact> getContact() {
        return this.contact;
    }

    @JsonProperty(value="parent_ticket")
    public Optional<TicketParentTicket> getParentTicket() {
        return this.parentTicket;
    }

    @JsonProperty(value="attachments")
    public Optional<List<Optional<TicketAttachmentsItem>>> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="tags")
    public Optional<List<Optional<String>>> getTags() {
        return this.tags;
    }

    @JsonProperty(value="remote_created_at")
    public Optional<OffsetDateTime> getRemoteCreatedAt() {
        return this.remoteCreatedAt;
    }

    @JsonProperty(value="remote_updated_at")
    public Optional<OffsetDateTime> getRemoteUpdatedAt() {
        return this.remoteUpdatedAt;
    }

    @JsonProperty(value="completed_at")
    public Optional<OffsetDateTime> getCompletedAt() {
        return this.completedAt;
    }

    @JsonProperty(value="remote_was_deleted")
    public Optional<Boolean> getRemoteWasDeleted() {
        return this.remoteWasDeleted;
    }

    @JsonProperty(value="ticket_url")
    public Optional<String> getTicketUrl() {
        return this.ticketUrl;
    }

    @JsonProperty(value="priority")
    public Optional<TicketPriority> getPriority() {
        return this.priority;
    }

    @JsonProperty(value="field_mappings")
    public Optional<Map<String, JsonNode>> getFieldMappings() {
        return this.fieldMappings;
    }

    @JsonProperty(value="remote_data")
    public Optional<List<RemoteData>> getRemoteData() {
        return this.remoteData;
    }

    @JsonProperty(value="remote_fields")
    public Optional<List<RemoteField>> getRemoteFields() {
        return this.remoteFields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Ticket && this.equalTo((Ticket)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Ticket other) {
        return this.id.equals(other.id) && this.remoteId.equals(other.remoteId) && this.createdAt.equals(other.createdAt) && this.modifiedAt.equals(other.modifiedAt) && this.name.equals(other.name) && this.assignees.equals(other.assignees) && this.creator.equals(other.creator) && this.dueDate.equals(other.dueDate) && this.status.equals(other.status) && this.description.equals(other.description) && this.collections.equals(other.collections) && this.ticketType.equals(other.ticketType) && this.account.equals(other.account) && this.contact.equals(other.contact) && this.parentTicket.equals(other.parentTicket) && this.attachments.equals(other.attachments) && this.tags.equals(other.tags) && this.remoteCreatedAt.equals(other.remoteCreatedAt) && this.remoteUpdatedAt.equals(other.remoteUpdatedAt) && this.completedAt.equals(other.completedAt) && this.remoteWasDeleted.equals(other.remoteWasDeleted) && this.ticketUrl.equals(other.ticketUrl) && this.priority.equals(other.priority) && this.fieldMappings.equals(other.fieldMappings) && this.remoteData.equals(other.remoteData) && this.remoteFields.equals(other.remoteFields);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.assignees, this.creator, this.dueDate, this.status, this.description, this.collections, this.ticketType, this.account, this.contact, this.parentTicket, this.attachments, this.tags, this.remoteCreatedAt, this.remoteUpdatedAt, this.completedAt, this.remoteWasDeleted, this.ticketUrl, this.priority, this.fieldMappings, this.remoteData, this.remoteFields);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private Optional<String> remoteId = Optional.empty();
        private Optional<OffsetDateTime> createdAt = Optional.empty();
        private Optional<OffsetDateTime> modifiedAt = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<List<Optional<TicketAssigneesItem>>> assignees = Optional.empty();
        private Optional<TicketCreator> creator = Optional.empty();
        private Optional<OffsetDateTime> dueDate = Optional.empty();
        private Optional<TicketStatus> status = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<List<Optional<TicketCollectionsItem>>> collections = Optional.empty();
        private Optional<String> ticketType = Optional.empty();
        private Optional<TicketAccount> account = Optional.empty();
        private Optional<TicketContact> contact = Optional.empty();
        private Optional<TicketParentTicket> parentTicket = Optional.empty();
        private Optional<List<Optional<TicketAttachmentsItem>>> attachments = Optional.empty();
        private Optional<List<Optional<String>>> tags = Optional.empty();
        private Optional<OffsetDateTime> remoteCreatedAt = Optional.empty();
        private Optional<OffsetDateTime> remoteUpdatedAt = Optional.empty();
        private Optional<OffsetDateTime> completedAt = Optional.empty();
        private Optional<Boolean> remoteWasDeleted = Optional.empty();
        private Optional<String> ticketUrl = Optional.empty();
        private Optional<TicketPriority> priority = Optional.empty();
        private Optional<Map<String, JsonNode>> fieldMappings = Optional.empty();
        private Optional<List<RemoteData>> remoteData = Optional.empty();
        private Optional<List<RemoteField>> remoteFields = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Ticket other) {
            this.id(other.getId());
            this.remoteId(other.getRemoteId());
            this.createdAt(other.getCreatedAt());
            this.modifiedAt(other.getModifiedAt());
            this.name(other.getName());
            this.assignees(other.getAssignees());
            this.creator(other.getCreator());
            this.dueDate(other.getDueDate());
            this.status(other.getStatus());
            this.description(other.getDescription());
            this.collections(other.getCollections());
            this.ticketType(other.getTicketType());
            this.account(other.getAccount());
            this.contact(other.getContact());
            this.parentTicket(other.getParentTicket());
            this.attachments(other.getAttachments());
            this.tags(other.getTags());
            this.remoteCreatedAt(other.getRemoteCreatedAt());
            this.remoteUpdatedAt(other.getRemoteUpdatedAt());
            this.completedAt(other.getCompletedAt());
            this.remoteWasDeleted(other.getRemoteWasDeleted());
            this.ticketUrl(other.getTicketUrl());
            this.priority(other.getPriority());
            this.fieldMappings(other.getFieldMappings());
            this.remoteData(other.getRemoteData());
            this.remoteFields(other.getRemoteFields());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.of(id);
            return this;
        }

        @JsonSetter(value="remote_id", nulls=Nulls.SKIP)
        public Builder remoteId(Optional<String> remoteId) {
            this.remoteId = remoteId;
            return this;
        }

        public Builder remoteId(String remoteId) {
            this.remoteId = Optional.of(remoteId);
            return this;
        }

        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public Builder createdAt(Optional<OffsetDateTime> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = Optional.of(createdAt);
            return this;
        }

        @JsonSetter(value="modified_at", nulls=Nulls.SKIP)
        public Builder modifiedAt(Optional<OffsetDateTime> modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder modifiedAt(OffsetDateTime modifiedAt) {
            this.modifiedAt = Optional.of(modifiedAt);
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.of(name);
            return this;
        }

        @JsonSetter(value="assignees", nulls=Nulls.SKIP)
        public Builder assignees(Optional<List<Optional<TicketAssigneesItem>>> assignees) {
            this.assignees = assignees;
            return this;
        }

        public Builder assignees(List<Optional<TicketAssigneesItem>> assignees) {
            this.assignees = Optional.of(assignees);
            return this;
        }

        @JsonSetter(value="creator", nulls=Nulls.SKIP)
        public Builder creator(Optional<TicketCreator> creator) {
            this.creator = creator;
            return this;
        }

        public Builder creator(TicketCreator creator) {
            this.creator = Optional.of(creator);
            return this;
        }

        @JsonSetter(value="due_date", nulls=Nulls.SKIP)
        public Builder dueDate(Optional<OffsetDateTime> dueDate) {
            this.dueDate = dueDate;
            return this;
        }

        public Builder dueDate(OffsetDateTime dueDate) {
            this.dueDate = Optional.of(dueDate);
            return this;
        }

        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public Builder status(Optional<TicketStatus> status) {
            this.status = status;
            return this;
        }

        public Builder status(TicketStatus status) {
            this.status = Optional.of(status);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.of(description);
            return this;
        }

        @JsonSetter(value="collections", nulls=Nulls.SKIP)
        public Builder collections(Optional<List<Optional<TicketCollectionsItem>>> collections) {
            this.collections = collections;
            return this;
        }

        public Builder collections(List<Optional<TicketCollectionsItem>> collections) {
            this.collections = Optional.of(collections);
            return this;
        }

        @JsonSetter(value="ticket_type", nulls=Nulls.SKIP)
        public Builder ticketType(Optional<String> ticketType) {
            this.ticketType = ticketType;
            return this;
        }

        public Builder ticketType(String ticketType) {
            this.ticketType = Optional.of(ticketType);
            return this;
        }

        @JsonSetter(value="account", nulls=Nulls.SKIP)
        public Builder account(Optional<TicketAccount> account) {
            this.account = account;
            return this;
        }

        public Builder account(TicketAccount account) {
            this.account = Optional.of(account);
            return this;
        }

        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public Builder contact(Optional<TicketContact> contact) {
            this.contact = contact;
            return this;
        }

        public Builder contact(TicketContact contact) {
            this.contact = Optional.of(contact);
            return this;
        }

        @JsonSetter(value="parent_ticket", nulls=Nulls.SKIP)
        public Builder parentTicket(Optional<TicketParentTicket> parentTicket) {
            this.parentTicket = parentTicket;
            return this;
        }

        public Builder parentTicket(TicketParentTicket parentTicket) {
            this.parentTicket = Optional.of(parentTicket);
            return this;
        }

        @JsonSetter(value="attachments", nulls=Nulls.SKIP)
        public Builder attachments(Optional<List<Optional<TicketAttachmentsItem>>> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder attachments(List<Optional<TicketAttachmentsItem>> attachments) {
            this.attachments = Optional.of(attachments);
            return this;
        }

        @JsonSetter(value="tags", nulls=Nulls.SKIP)
        public Builder tags(Optional<List<Optional<String>>> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(List<Optional<String>> tags) {
            this.tags = Optional.of(tags);
            return this;
        }

        @JsonSetter(value="remote_created_at", nulls=Nulls.SKIP)
        public Builder remoteCreatedAt(Optional<OffsetDateTime> remoteCreatedAt) {
            this.remoteCreatedAt = remoteCreatedAt;
            return this;
        }

        public Builder remoteCreatedAt(OffsetDateTime remoteCreatedAt) {
            this.remoteCreatedAt = Optional.of(remoteCreatedAt);
            return this;
        }

        @JsonSetter(value="remote_updated_at", nulls=Nulls.SKIP)
        public Builder remoteUpdatedAt(Optional<OffsetDateTime> remoteUpdatedAt) {
            this.remoteUpdatedAt = remoteUpdatedAt;
            return this;
        }

        public Builder remoteUpdatedAt(OffsetDateTime remoteUpdatedAt) {
            this.remoteUpdatedAt = Optional.of(remoteUpdatedAt);
            return this;
        }

        @JsonSetter(value="completed_at", nulls=Nulls.SKIP)
        public Builder completedAt(Optional<OffsetDateTime> completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public Builder completedAt(OffsetDateTime completedAt) {
            this.completedAt = Optional.of(completedAt);
            return this;
        }

        @JsonSetter(value="remote_was_deleted", nulls=Nulls.SKIP)
        public Builder remoteWasDeleted(Optional<Boolean> remoteWasDeleted) {
            this.remoteWasDeleted = remoteWasDeleted;
            return this;
        }

        public Builder remoteWasDeleted(Boolean remoteWasDeleted) {
            this.remoteWasDeleted = Optional.of(remoteWasDeleted);
            return this;
        }

        @JsonSetter(value="ticket_url", nulls=Nulls.SKIP)
        public Builder ticketUrl(Optional<String> ticketUrl) {
            this.ticketUrl = ticketUrl;
            return this;
        }

        public Builder ticketUrl(String ticketUrl) {
            this.ticketUrl = Optional.of(ticketUrl);
            return this;
        }

        @JsonSetter(value="priority", nulls=Nulls.SKIP)
        public Builder priority(Optional<TicketPriority> priority) {
            this.priority = priority;
            return this;
        }

        public Builder priority(TicketPriority priority) {
            this.priority = Optional.of(priority);
            return this;
        }

        @JsonSetter(value="field_mappings", nulls=Nulls.SKIP)
        public Builder fieldMappings(Optional<Map<String, JsonNode>> fieldMappings) {
            this.fieldMappings = fieldMappings;
            return this;
        }

        public Builder fieldMappings(Map<String, JsonNode> fieldMappings) {
            this.fieldMappings = Optional.of(fieldMappings);
            return this;
        }

        @JsonSetter(value="remote_data", nulls=Nulls.SKIP)
        public Builder remoteData(Optional<List<RemoteData>> remoteData) {
            this.remoteData = remoteData;
            return this;
        }

        public Builder remoteData(List<RemoteData> remoteData) {
            this.remoteData = Optional.of(remoteData);
            return this;
        }

        @JsonSetter(value="remote_fields", nulls=Nulls.SKIP)
        public Builder remoteFields(Optional<List<RemoteField>> remoteFields) {
            this.remoteFields = remoteFields;
            return this;
        }

        public Builder remoteFields(List<RemoteField> remoteFields) {
            this.remoteFields = Optional.of(remoteFields);
            return this;
        }

        public Ticket build() {
            return new Ticket(this.id, this.remoteId, this.createdAt, this.modifiedAt, this.name, this.assignees, this.creator, this.dueDate, this.status, this.description, this.collections, this.ticketType, this.account, this.contact, this.parentTicket, this.attachments, this.tags, this.remoteCreatedAt, this.remoteUpdatedAt, this.completedAt, this.remoteWasDeleted, this.ticketUrl, this.priority, this.fieldMappings, this.remoteData, this.remoteFields, this.additionalProperties);
        }
    }
}

