/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.processor;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.ExitStatus;
import gov.nist.secauto.metaschema.cli.processor.InvalidArgumentException;
import gov.nist.secauto.metaschema.cli.processor.OptionUtils;
import gov.nist.secauto.metaschema.cli.processor.command.CommandService;
import gov.nist.secauto.metaschema.cli.processor.command.ExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ICommand;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import gov.nist.secauto.metaschema.core.util.IVersionInfo;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.AnsiPrintStream;

public class CLIProcessor {
    private static final Logger LOGGER = LogManager.getLogger(CLIProcessor.class);
    @NonNull
    public static final Option HELP_OPTION = Option.builder((String)"h").longOpt("help").desc("display this help message").build();
    @NonNull
    public static final Option NO_COLOR_OPTION = Option.builder().longOpt("no-color").desc("do not colorize output").build();
    @NonNull
    public static final Option QUIET_OPTION = Option.builder((String)"q").longOpt("quiet").desc("minimize output to include only errors").build();
    @NonNull
    public static final Option SHOW_STACK_TRACE_OPTION = Option.builder().longOpt("show-stack-trace").desc("display the stack trace associated with an error").build();
    @NonNull
    public static final Option VERSION_OPTION = Option.builder().longOpt("version").desc("display the application version").build();
    @NonNull
    public static final List<Option> OPTIONS = List.of(HELP_OPTION, NO_COLOR_OPTION, QUIET_OPTION, SHOW_STACK_TRACE_OPTION, VERSION_OPTION);
    public static final String COMMAND_VERSION = "http://csrc.nist.gov/ns/metaschema-java/cli/command-version";
    @NonNull
    private final List<ICommand> commands = new LinkedList<ICommand>();
    @NonNull
    private final String exec;
    @NonNull
    private final Map<String, IVersionInfo> versionInfos;

    public static void main(String ... args) {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        CLIProcessor processor = new CLIProcessor("metaschema-cli");
        CommandService.getInstance().getCommands().stream().forEach(command -> {
            assert (command != null);
            processor.addCommandHandler((ICommand)command);
        });
        System.exit(processor.process(args).getExitCode().getStatusCode());
    }

    public CLIProcessor(@NonNull String exec) {
        this(exec, Map.of());
    }

    public CLIProcessor(@NonNull String exec, @NonNull Map<String, IVersionInfo> versionInfos) {
        this.exec = exec;
        this.versionInfos = versionInfos;
        AnsiConsole.systemInstall();
    }

    @NonNull
    public String getExec() {
        return this.exec;
    }

    @NonNull
    public Map<String, IVersionInfo> getVersionInfos() {
        return this.versionInfos;
    }

    public void addCommandHandler(@NonNull ICommand handler) {
        this.commands.add(handler);
    }

    @NonNull
    public ExitStatus process(String ... args) {
        return this.parseCommand(args);
    }

    @NonNull
    private ExitStatus parseCommand(String ... args) {
        ExitStatus status;
        List<String> commandArgs = Arrays.asList(args);
        assert (commandArgs != null);
        CallingContext callingContext = new CallingContext(commandArgs);
        if (commandArgs.isEmpty()) {
            status = ExitCode.INVALID_COMMAND.exit();
            callingContext.showHelp();
        } else {
            status = callingContext.processCommand();
        }
        return status;
    }

    protected final List<ICommand> getTopLevelCommands() {
        List<ICommand> retval = Collections.unmodifiableList(this.commands);
        assert (retval != null);
        return retval;
    }

    private static void handleNoColor() {
        System.setProperty("jansi.mode", "strip");
        AnsiConsole.systemUninstall();
    }

    public static void handleQuiet() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        Level oldLevel = loggerConfig.getLevel();
        if (oldLevel.isLessSpecificThan(Level.ERROR)) {
            loggerConfig.setLevel(Level.ERROR);
            ctx.updateLoggers();
        }
    }

    protected void showVersion() {
        AnsiPrintStream out = AnsiConsole.out();
        this.getVersionInfos().values().stream().forEach(arg_0 -> CLIProcessor.lambda$showVersion$1((PrintStream)out, arg_0));
        out.flush();
    }

    private static /* synthetic */ void lambda$showVersion$1(PrintStream out, IVersionInfo info) {
        out.println(Ansi.ansi().bold().a(info.getName()).boldOff().a(" ").bold().a(info.getVersion()).boldOff().a(" built at ").bold().a(info.getBuildTimestamp()).boldOff().a(" from branch ").bold().a(info.getGitBranch()).boldOff().a(" (").bold().a(info.getGitCommit()).boldOff().a(") at ").bold().a(info.getGitOriginUrl()).boldOff().reset());
    }

    public class CallingContext {
        @NonNull
        private final List<Option> options;
        @NonNull
        private final Deque<ICommand> calledCommands;
        @NonNull
        private final List<String> extraArgs;

        @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
        public CallingContext(List<String> args) {
            Map topLevelCommandMap = CLIProcessor.this.getTopLevelCommands().stream().collect(Collectors.toUnmodifiableMap(ICommand::getName, Function.identity()));
            List<Option> options = new LinkedList<Option>(OPTIONS);
            LinkedList<ICommand> calledCommands = new LinkedList<ICommand>();
            List<String> extraArgs = new LinkedList<String>();
            boolean endArgs = false;
            for (String arg : args) {
                ICommand command;
                if (endArgs || arg.startsWith("-")) {
                    extraArgs.add(arg);
                    continue;
                }
                if ("--".equals(arg)) {
                    endArgs = true;
                    continue;
                }
                if (calledCommands.isEmpty()) {
                    command = (ICommand)topLevelCommandMap.get(arg);
                } else {
                    command = (ICommand)calledCommands.getLast();
                    command = command.getSubCommandByName(arg);
                }
                if (command == null) {
                    extraArgs.add(arg);
                    endArgs = true;
                    continue;
                }
                calledCommands.add(command);
            }
            if (LOGGER.isDebugEnabled()) {
                String commandChain = calledCommands.stream().map(ICommand::getName).collect(Collectors.joining(" -> "));
                LOGGER.debug("Processing command chain: {}", (Object)commandChain);
            }
            for (ICommand cmd : calledCommands) {
                options.addAll(cmd.gatherOptions());
            }
            options = Collections.unmodifiableList(options);
            extraArgs = Collections.unmodifiableList(extraArgs);
            assert (options != null);
            assert (extraArgs != null);
            this.options = options;
            this.calledCommands = calledCommands;
            this.extraArgs = extraArgs;
        }

        @NonNull
        public CLIProcessor getCLIProcessor() {
            return CLIProcessor.this;
        }

        @Nullable
        public ICommand getTargetCommand() {
            return this.calledCommands.peekLast();
        }

        @NonNull
        protected List<Option> getOptionsList() {
            return this.options;
        }

        @NonNull
        private Deque<ICommand> getCalledCommands() {
            return this.calledCommands;
        }

        @NonNull
        protected List<String> getExtraArgs() {
            return this.extraArgs;
        }

        protected Options toOptions() {
            Options retval = new Options();
            for (Option option : this.getOptionsList()) {
                retval.addOption(option);
            }
            return retval;
        }

        @NonNull
        public ExitStatus processCommand() {
            CommandLine cmdLine;
            DefaultParser parser = new DefaultParser();
            ExitStatus retval = null;
            try {
                Options phase1Options = new Options();
                phase1Options.addOption(HELP_OPTION);
                phase1Options.addOption(VERSION_OPTION);
                cmdLine = parser.parse(phase1Options, this.getExtraArgs().toArray(new String[0]), true);
            }
            catch (ParseException ex) {
                String msg = ex.getMessage();
                assert (msg != null);
                return this.handleInvalidCommand(msg);
            }
            if (cmdLine.hasOption(VERSION_OPTION)) {
                CLIProcessor.this.showVersion();
                retval = ExitCode.OK.exit();
            } else if (cmdLine.hasOption(HELP_OPTION)) {
                this.showHelp();
                retval = ExitCode.OK.exit();
            }
            if (retval == null) {
                try {
                    cmdLine = parser.parse(this.toOptions(), this.getExtraArgs().toArray(new String[0]));
                }
                catch (ParseException ex) {
                    String msg = ex.getMessage();
                    assert (msg != null);
                    return this.handleInvalidCommand(msg);
                }
                if (cmdLine.hasOption(NO_COLOR_OPTION)) {
                    CLIProcessor.handleNoColor();
                }
                if (cmdLine.hasOption(QUIET_OPTION)) {
                    CLIProcessor.handleQuiet();
                }
                retval = this.invokeCommand(cmdLine);
            }
            retval.generateMessage(cmdLine.hasOption(SHOW_STACK_TRACE_OPTION));
            return retval;
        }

        protected ExitStatus invokeCommand(@NonNull CommandLine cmdLine) {
            ExitStatus retval;
            try {
                for (ICommand cmd : this.getCalledCommands()) {
                    try {
                        cmd.validateOptions(this, cmdLine);
                    }
                    catch (InvalidArgumentException ex) {
                        String msg = ex.getMessage();
                        assert (msg != null);
                        return this.handleInvalidCommand(msg);
                    }
                }
                ICommand targetCommand = this.getTargetCommand();
                if (targetCommand == null) {
                    retval = ExitCode.INVALID_COMMAND.exit();
                } else {
                    ICommandExecutor executor = targetCommand.newExecutor(this, cmdLine);
                    retval = executor.execute();
                }
                if (ExitCode.INVALID_COMMAND.equals((Object)retval.getExitCode())) {
                    this.showHelp();
                }
            }
            catch (RuntimeException ex) {
                retval = ExitCode.RUNTIME_ERROR.exitMessage(String.format("An uncaught runtime error occurred. %s", ex.getLocalizedMessage())).withThrowable(ex);
            }
            return retval;
        }

        @NonNull
        public ExitStatus handleInvalidCommand(@NonNull String message) {
            this.showHelp();
            ExitStatus retval = ExitCode.INVALID_COMMAND.exitMessage(message);
            retval.generateMessage(false);
            return retval;
        }

        @Nullable
        protected String buildHelpHeader() {
            return null;
        }

        @NonNull
        private String buildHelpFooter() {
            String retval;
            ICommand targetCommand = this.getTargetCommand();
            Collection<ICommand> subCommands = targetCommand == null ? CLIProcessor.this.getTopLevelCommands() : targetCommand.getSubCommands();
            if (subCommands.isEmpty()) {
                retval = "";
            } else {
                StringBuilder builder = new StringBuilder(64);
                builder.append(System.lineSeparator()).append("The following are available commands:").append(System.lineSeparator());
                int length = subCommands.stream().mapToInt(command -> command.getName().length()).max().orElse(0);
                for (ICommand command2 : subCommands) {
                    builder.append(Ansi.ansi().render(String.format("   @|bold %-" + length + "s|@ %s%n", command2.getName(), command2.getDescription())));
                }
                builder.append(System.lineSeparator()).append('\'').append(CLIProcessor.this.getExec()).append(" <command> --help' will show help on that specific command.").append(System.lineSeparator());
                retval = builder.toString();
                assert (retval != null);
            }
            return retval;
        }

        protected String buildHelpCliSyntax() {
            ICommand targetCommand;
            StringBuilder builder = new StringBuilder(64);
            builder.append(CLIProcessor.this.getExec());
            Deque<ICommand> calledCommands = this.getCalledCommands();
            if (!calledCommands.isEmpty()) {
                builder.append(calledCommands.stream().map(ICommand::getName).collect(Collectors.joining(" ", " ", "")));
            }
            if ((targetCommand = this.getTargetCommand()) == null) {
                builder.append(" <command>");
            } else {
                Collection<ICommand> subCommands = targetCommand.getSubCommands();
                if (!subCommands.isEmpty()) {
                    builder.append(' ');
                    if (!targetCommand.isSubCommandRequired()) {
                        builder.append('[');
                    }
                    builder.append("<command>");
                    if (!targetCommand.isSubCommandRequired()) {
                        builder.append(']');
                    }
                }
            }
            this.getOptionsList().stream().filter(Option::isRequired).forEach(option -> {
                builder.append(' ').append(OptionUtils.toArgument((Option)ObjectUtils.notNull((Object)option)));
                if (option.hasArg()) {
                    builder.append('=').append(option.getArgName());
                }
            });
            builder.append(" [<options>]");
            if (targetCommand != null) {
                for (ExtraArgument argument : targetCommand.getExtraArguments()) {
                    builder.append(' ');
                    if (!argument.isRequired()) {
                        builder.append('[');
                    }
                    builder.append('<');
                    builder.append(argument.getName());
                    builder.append('>');
                    if (argument.getNumber() > 1) {
                        builder.append("...");
                    }
                    if (argument.isRequired()) continue;
                    builder.append(']');
                }
            }
            String retval = builder.toString();
            assert (retval != null);
            return retval;
        }

        public void showHelp() {
            HelpFormatter formatter = new HelpFormatter();
            formatter.setLongOptSeparator("=");
            AnsiPrintStream out = AnsiConsole.out();
            int terminalWidth = Math.max(out.getTerminalWidth(), 40);
            PrintWriter writer = new PrintWriter((OutputStream)out, true, StandardCharsets.UTF_8);
            formatter.printHelp(writer, terminalWidth, this.buildHelpCliSyntax(), this.buildHelpHeader(), this.toOptions(), 1, 3, this.buildHelpFooter(), false);
            writer.flush();
        }
    }
}

