/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.processor.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.InvalidArgumentException;
import gov.nist.secauto.metaschema.cli.processor.command.ExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public interface ICommand {
    @NonNull
    public String getName();

    @NonNull
    public String getDescription();

    @NonNull
    default public List<ExtraArgument> getExtraArguments() {
        return CollectionUtil.emptyList();
    }

    default public int requiredExtraArgumentsCount() {
        return (int)this.getExtraArguments().stream().filter(ExtraArgument::isRequired).count();
    }

    @NonNull
    default public Collection<? extends Option> gatherOptions() {
        return CollectionUtil.emptyList();
    }

    @NonNull
    public Collection<ICommand> getSubCommands();

    public boolean isSubCommandRequired();

    default public ICommand getSubCommandByName(@NonNull String name) {
        return null;
    }

    default public void validateOptions(@NonNull CLIProcessor.CallingContext callingContext, @NonNull CommandLine cmdLine) throws InvalidArgumentException {
    }

    @NonNull
    public ICommandExecutor newExecutor(@NonNull CLIProcessor.CallingContext var1, @NonNull CommandLine var2);
}

