/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.processor.command;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.processor.command.ICommand;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.core.util.UriUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import nl.talsmasoftware.lazy4j.Lazy;

public abstract class AbstractTerminalCommand
implements ICommand {
    private static Lazy<Path> currentWorkingDirectory = Lazy.lazy(() -> Paths.get(System.getProperty("user.dir"), new String[0]));

    @NonNull
    protected static Path getCurrentWorkingDirectory() {
        return (Path)ObjectUtils.notNull((Object)((Path)currentWorkingDirectory.get()));
    }

    @NonNull
    protected static Path resolveAgainstCWD(@NonNull Path path) {
        return path.isAbsolute() ? path : (Path)ObjectUtils.notNull((Object)AbstractTerminalCommand.getCurrentWorkingDirectory().resolve(path).normalize());
    }

    @NonNull
    protected static URI resolveAgainstCWD(@NonNull URI uri) {
        return uri.isAbsolute() ? uri : (URI)ObjectUtils.notNull((Object)AbstractTerminalCommand.getCurrentWorkingDirectory().toUri().resolve(uri.normalize()));
    }

    @NonNull
    protected static URI resolveAgainstCWD(@NonNull String uri) throws URISyntaxException {
        return UriUtils.toUri((String)uri, (URI)((URI)ObjectUtils.notNull((Object)AbstractTerminalCommand.getCurrentWorkingDirectory().toUri())));
    }
}

