/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.ExitStatus;
import gov.nist.secauto.metaschema.cli.processor.InvalidArgumentException;
import gov.nist.secauto.metaschema.cli.processor.OptionUtils;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractCommandExecutor;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractTerminalCommand;
import gov.nist.secauto.metaschema.cli.processor.command.DefaultExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ExtraArgument;
import gov.nist.secauto.metaschema.core.util.CustomCollectors;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.core.util.UriUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.Format;
import gov.nist.secauto.metaschema.databind.io.IBoundLoader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractConvertSubcommand
extends AbstractTerminalCommand {
    private static final Logger LOGGER = LogManager.getLogger(AbstractConvertSubcommand.class);
    @NonNull
    private static final String COMMAND = "convert";
    @NonNull
    private static final List<ExtraArgument> EXTRA_ARGUMENTS = (List)ObjectUtils.notNull(List.of(new DefaultExtraArgument("source-file-or-URL", true), new DefaultExtraArgument("destination-file", false)));
    @NonNull
    private static final Option OVERWRITE_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("overwrite").desc("overwrite the destination if it exists").build());
    @NonNull
    private static final Option TO_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("to").required().hasArg().argName("FORMAT").desc("convert to format: xml, json, or yaml").build());

    public String getName() {
        return COMMAND;
    }

    public Collection<? extends Option> gatherOptions() {
        return (Collection)ObjectUtils.notNull(List.of(OVERWRITE_OPTION, TO_OPTION));
    }

    public List<ExtraArgument> getExtraArguments() {
        return EXTRA_ARGUMENTS;
    }

    public void validateOptions(CLIProcessor.CallingContext callingContext, CommandLine cmdLine) throws InvalidArgumentException {
        try {
            String toFormatText = cmdLine.getOptionValue(TO_OPTION);
            Format.valueOf((String)toFormatText.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            InvalidArgumentException newEx = new InvalidArgumentException(String.format("Invalid '%s' argument. The format must be one of: %s.", OptionUtils.toArgument((Option)TO_OPTION), Format.names().stream().collect(CustomCollectors.joiningWithOxfordComma((String)"and"))));
            newEx.setOption(TO_OPTION);
            newEx.addSuppressed((Throwable)ex);
            throw newEx;
        }
        List extraArgs = cmdLine.getArgList();
        if (extraArgs.isEmpty() || extraArgs.size() > 2) {
            throw new InvalidArgumentException("Illegal number of arguments.");
        }
    }

    protected static abstract class AbstractConversionCommandExecutor
    extends AbstractCommandExecutor {
        protected AbstractConversionCommandExecutor(@NonNull CLIProcessor.CallingContext callingContext, @NonNull CommandLine commandLine) {
            super(callingContext, commandLine);
        }

        @NonNull
        protected abstract IBindingContext getBindingContext();

        public ExitStatus execute() {
            Format toFormat;
            Path destination;
            block24: {
                URI source;
                CommandLine cmdLine = this.getCommandLine();
                List extraArgs = cmdLine.getArgList();
                destination = null;
                if (extraArgs.size() > 1) {
                    destination = Paths.get((String)extraArgs.get(1), new String[0]).toAbsolutePath();
                }
                if (destination != null) {
                    if (Files.exists(destination, new LinkOption[0])) {
                        if (!cmdLine.hasOption(OVERWRITE_OPTION)) {
                            return ExitCode.INVALID_ARGUMENTS.exitMessage(new Object[]{String.format("The provided destination '%s' already exists and the '%s' option was not provided.", destination, OptionUtils.toArgument((Option)OVERWRITE_OPTION))});
                        }
                        if (!Files.isWritable(destination)) {
                            return ExitCode.IO_ERROR.exitMessage(new Object[]{"The provided destination '" + destination + "' is not writable."});
                        }
                    } else {
                        Path parent = destination.getParent();
                        if (parent != null) {
                            try {
                                Files.createDirectories(parent, new FileAttribute[0]);
                            }
                            catch (IOException ex) {
                                return ExitCode.INVALID_TARGET.exit().withThrowable((Throwable)ex);
                            }
                        }
                    }
                }
                String sourceName = (String)ObjectUtils.notNull((Object)((String)extraArgs.get(0)));
                URI cwd = (URI)ObjectUtils.notNull((Object)Paths.get("", new String[0]).toAbsolutePath().toUri());
                try {
                    source = UriUtils.toUri((String)sourceName, (URI)cwd);
                }
                catch (URISyntaxException ex) {
                    return ExitCode.IO_ERROR.exitMessage(new Object[]{"Cannot load source '%s' as it is not a valid file or URI."}).withThrowable((Throwable)ex);
                }
                assert (source != null);
                String toFormatText = cmdLine.getOptionValue(TO_OPTION);
                toFormat = Format.valueOf((String)toFormatText.toUpperCase(Locale.ROOT));
                IBindingContext bindingContext = this.getBindingContext();
                try {
                    IBoundLoader loader = bindingContext.newBoundLoader();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Converting '{}'.", (Object)source);
                    }
                    if (destination == null) {
                        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8);
                        this.handleConversion(source, toFormat, writer, loader);
                        break block24;
                    }
                    try (BufferedWriter writer = Files.newBufferedWriter(destination, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                        assert (writer != null);
                        this.handleConversion(source, toFormat, writer, loader);
                    }
                }
                catch (IOException | IllegalArgumentException ex) {
                    return ExitCode.PROCESSING_ERROR.exit().withThrowable((Throwable)ex);
                }
            }
            if (destination != null && LOGGER.isInfoEnabled()) {
                LOGGER.info("Generated {} file: {}", (Object)toFormat.toString(), (Object)destination);
            }
            return ExitCode.OK.exit();
        }

        protected abstract void handleConversion(@NonNull URI var1, @NonNull Format var2, @NonNull Writer var3, @NonNull IBoundLoader var4) throws FileNotFoundException, IOException;
    }
}

