/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.ExitStatus;
import gov.nist.secauto.metaschema.cli.processor.InvalidArgumentException;
import gov.nist.secauto.metaschema.cli.processor.OptionUtils;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractCommandExecutor;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractTerminalCommand;
import gov.nist.secauto.metaschema.cli.processor.command.DefaultExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ExtraArgument;
import gov.nist.secauto.metaschema.cli.util.LoggingValidationHandler;
import gov.nist.secauto.metaschema.core.configuration.DefaultConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfigurationFeature;
import gov.nist.secauto.metaschema.core.metapath.MetapathException;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.core.model.constraint.ValidationFeature;
import gov.nist.secauto.metaschema.core.model.validation.AggregateValidationResult;
import gov.nist.secauto.metaschema.core.model.validation.IValidationResult;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.CustomCollectors;
import gov.nist.secauto.metaschema.core.util.IVersionInfo;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.core.util.UriUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.Format;
import gov.nist.secauto.metaschema.databind.io.IBoundLoader;
import gov.nist.secauto.metaschema.databind.model.metaschema.BindingConstraintLoader;
import gov.nist.secauto.metaschema.modules.sarif.SarifValidationHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractValidateContentCommand
extends AbstractTerminalCommand {
    private static final Logger LOGGER = LogManager.getLogger(AbstractValidateContentCommand.class);
    @NonNull
    private static final String COMMAND = "validate";
    @NonNull
    private static final List<ExtraArgument> EXTRA_ARGUMENTS = (List)ObjectUtils.notNull(List.of(new DefaultExtraArgument("file-or-URI-to-validate", true)));
    @NonNull
    private static final Option AS_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("as").hasArg().argName("FORMAT").desc("source format: xml, json, or yaml").numberOfArgs(1).build());
    @NonNull
    private static final Option CONSTRAINTS_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"c").hasArgs().argName("URL").desc("additional constraint definitions").build());
    @NonNull
    private static final Option SARIF_OUTPUT_FILE_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"o").hasArg().argName("FILE").desc("write SARIF results to the provided FILE").numberOfArgs(1).build());
    @NonNull
    private static final Option SARIF_INCLUDE_PASS_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("sarif-include-pass").desc("include pass results in SARIF").build());
    @NonNull
    private static final Option NO_SCHEMA_VALIDATION_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("disable-schema-validation").desc("do not perform schema validation").build());
    @NonNull
    private static final Option NO_CONSTRAINT_VALIDATION_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("disable-constraint-validation").desc("do not perform constraint validation").build());

    public String getName() {
        return COMMAND;
    }

    public Collection<? extends Option> gatherOptions() {
        return List.of(AS_OPTION, CONSTRAINTS_OPTION, SARIF_OUTPUT_FILE_OPTION, SARIF_INCLUDE_PASS_OPTION, NO_SCHEMA_VALIDATION_OPTION, NO_CONSTRAINT_VALIDATION_OPTION);
    }

    public List<ExtraArgument> getExtraArguments() {
        return EXTRA_ARGUMENTS;
    }

    public void validateOptions(CLIProcessor.CallingContext callingContext, CommandLine cmdLine) throws InvalidArgumentException {
        List extraArgs = cmdLine.getArgList();
        if (extraArgs.size() != 1) {
            throw new InvalidArgumentException("The source to validate must be provided.");
        }
        if (cmdLine.hasOption(AS_OPTION)) {
            try {
                String toFormatText = cmdLine.getOptionValue(AS_OPTION);
                Format.valueOf((String)toFormatText.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                InvalidArgumentException newEx = new InvalidArgumentException(String.format("Invalid '%s' argument. The format must be one of: %s.", OptionUtils.toArgument((Option)AS_OPTION), Arrays.asList(Format.values()).stream().map(format -> format.name()).collect(CustomCollectors.joiningWithOxfordComma((String)"and"))));
                newEx.addSuppressed((Throwable)ex);
                throw newEx;
            }
        }
    }

    protected abstract class AbstractValidationCommandExecutor
    extends AbstractCommandExecutor
    implements IBindingContext.ISchemaValidationProvider {
        public AbstractValidationCommandExecutor(@NonNull CLIProcessor.CallingContext callingContext, CommandLine commandLine) {
            super(callingContext, commandLine);
        }

        @NonNull
        protected abstract IBindingContext getBindingContext(@NonNull Set<IConstraintSet> var1) throws MetaschemaException, IOException;

        public ExitStatus execute() {
            Format asFormat;
            URI source;
            IBindingContext bindingContext;
            LinkedHashSet constraintSets;
            URI cwd = (URI)ObjectUtils.notNull((Object)Paths.get("", new String[0]).toAbsolutePath().toUri());
            CommandLine cmdLine = this.getCommandLine();
            if (cmdLine.hasOption(CONSTRAINTS_OPTION)) {
                String[] args;
                BindingConstraintLoader constraintLoader = new BindingConstraintLoader(IBindingContext.instance());
                constraintSets = new LinkedHashSet();
                for (String arg : args = cmdLine.getOptionValues(CONSTRAINTS_OPTION)) {
                    assert (arg != null);
                    try {
                        URI constraintUri = (URI)ObjectUtils.requireNonNull((Object)UriUtils.toUri((String)arg, (URI)cwd));
                        constraintSets.addAll((Collection)constraintLoader.load(constraintUri));
                    }
                    catch (MetapathException | MetaschemaException | IOException | URISyntaxException ex) {
                        return ExitCode.IO_ERROR.exitMessage(new Object[]{"Unable to load constraint set '" + arg + "'."}).withThrowable(ex);
                    }
                }
            } else {
                constraintSets = CollectionUtil.emptySet();
            }
            try {
                bindingContext = this.getBindingContext(constraintSets);
            }
            catch (MetaschemaException | IOException ex) {
                return ExitCode.PROCESSING_ERROR.exitMessage(new Object[]{"Unable to get binding context. " + ex.getMessage()}).withThrowable(ex);
            }
            IBoundLoader loader = bindingContext.newBoundLoader();
            List extraArgs = cmdLine.getArgList();
            String sourceName = (String)ObjectUtils.requireNonNull((Object)((String)extraArgs.get(0)));
            try {
                source = UriUtils.toUri((String)sourceName, (URI)cwd);
            }
            catch (URISyntaxException ex) {
                return ExitCode.IO_ERROR.exitMessage(new Object[]{"Cannot load source '%s' as it is not a valid file or URI."}).withThrowable((Throwable)ex);
            }
            if (cmdLine.hasOption(AS_OPTION)) {
                try {
                    String toFormatText = cmdLine.getOptionValue(AS_OPTION);
                    asFormat = Format.valueOf((String)toFormatText.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException ex) {
                    return ExitCode.IO_ERROR.exitMessage(new Object[]{"Invalid '--as' argument. The format must be one of: " + (String)Arrays.stream(Format.values()).map(format -> format.name()).collect(CustomCollectors.joiningWithOxfordComma((String)"or"))}).withThrowable((Throwable)ex);
                }
            }
            try {
                asFormat = loader.detectFormat(source);
            }
            catch (FileNotFoundException ex) {
                return ExitCode.IO_ERROR.exitMessage(new Object[]{"The provided source file '" + source + "' does not exist."});
            }
            catch (IOException ex) {
                return ExitCode.PROCESSING_ERROR.exit().withThrowable((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                return ExitCode.IO_ERROR.exitMessage(new Object[]{"Source file has unrecognizable format. Use '--as' to specify the format. The format must be one of: " + (String)Arrays.stream(Format.values()).map(format -> format.name()).collect(CustomCollectors.joiningWithOxfordComma((String)"or"))});
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Validating '{}' as {}.", (Object)source, (Object)asFormat.name());
            }
            DefaultConfiguration configuration = new DefaultConfiguration();
            if (cmdLine.hasOption(SARIF_OUTPUT_FILE_OPTION) && cmdLine.hasOption(SARIF_INCLUDE_PASS_OPTION)) {
                configuration.enableFeature((IConfigurationFeature)ValidationFeature.VALIDATE_GENERATE_PASS_FINDINGS);
            }
            IValidationResult validationResult = null;
            try {
                if (!cmdLine.hasOption(NO_SCHEMA_VALIDATION_OPTION)) {
                    validationResult = this.validateWithSchema(source, asFormat);
                }
                if (!cmdLine.hasOption(NO_CONSTRAINT_VALIDATION_OPTION) && (validationResult == null || validationResult.isPassing())) {
                    IValidationResult constraintValidationResult = bindingContext.validateWithConstraints(source, (IConfiguration)configuration);
                    validationResult = validationResult == null ? constraintValidationResult : AggregateValidationResult.aggregate((IValidationResult[])new IValidationResult[]{validationResult, constraintValidationResult});
                }
            }
            catch (FileNotFoundException ex) {
                return ExitCode.IO_ERROR.exitMessage(new Object[]{String.format("Resource not found at '%s'", source)}).withThrowable((Throwable)ex);
            }
            catch (UnknownHostException ex) {
                return ExitCode.IO_ERROR.exitMessage(new Object[]{String.format("Unknown host for '%s'.", source)}).withThrowable((Throwable)ex);
            }
            catch (IOException ex) {
                return ExitCode.IO_ERROR.exit().withThrowable((Throwable)ex);
            }
            catch (MetapathException ex) {
                return ExitCode.PROCESSING_ERROR.exit().withThrowable((Throwable)ex);
            }
            if (cmdLine.hasOption(SARIF_OUTPUT_FILE_OPTION) && LOGGER.isInfoEnabled()) {
                Path sarifFile = (Path)ObjectUtils.notNull((Object)Paths.get(cmdLine.getOptionValue(SARIF_OUTPUT_FILE_OPTION), new String[0]));
                IVersionInfo version = (IVersionInfo)this.getCallingContext().getCLIProcessor().getVersionInfos().get("http://csrc.nist.gov/ns/metaschema-java/cli/command-version");
                try {
                    SarifValidationHandler sarifHandler = new SarifValidationHandler(source, version);
                    if (validationResult != null) {
                        sarifHandler.addFindings(validationResult.getFindings());
                    }
                    sarifHandler.write(sarifFile);
                }
                catch (IOException ex) {
                    return ExitCode.IO_ERROR.exit().withThrowable((Throwable)ex);
                }
            } else if (validationResult != null && !validationResult.getFindings().isEmpty()) {
                LOGGER.info("Validation identified the following issues:", (Object)source);
                LoggingValidationHandler.instance().handleValidationResults(validationResult);
            }
            if (validationResult == null || validationResult.isPassing()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("The file '{}' is valid.", (Object)source);
                }
            } else if (LOGGER.isErrorEnabled()) {
                LOGGER.error("The file '{}' is invalid.", (Object)source);
            }
            return (validationResult == null || validationResult.isPassing() ? ExitCode.OK : ExitCode.FAIL).exit();
        }
    }
}

