/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.commands.MetaschemaCommands;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.ExitStatus;
import gov.nist.secauto.metaschema.cli.processor.InvalidArgumentException;
import gov.nist.secauto.metaschema.cli.processor.OptionUtils;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractTerminalCommand;
import gov.nist.secauto.metaschema.cli.processor.command.DefaultExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.MermaidErDiagramGenerator;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.core.util.UriUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenerateDiagramCommand
extends AbstractTerminalCommand {
    private static final Logger LOGGER = LogManager.getLogger(GenerateDiagramCommand.class);
    @NonNull
    private static final String COMMAND = "generate-diagram";
    @NonNull
    private static final List<ExtraArgument> EXTRA_ARGUMENTS = (List)ObjectUtils.notNull(List.of(new DefaultExtraArgument("metaschema-module-file-or-URL", true), new DefaultExtraArgument("destination-diagram-file", false)));

    public String getName() {
        return COMMAND;
    }

    public String getDescription() {
        return "Generate a diagram for the provided Metaschema module";
    }

    public Collection<? extends Option> gatherOptions() {
        return List.of(MetaschemaCommands.OVERWRITE_OPTION);
    }

    public List<ExtraArgument> getExtraArguments() {
        return EXTRA_ARGUMENTS;
    }

    public void validateOptions(CLIProcessor.CallingContext callingContext, CommandLine cmdLine) throws InvalidArgumentException {
        List extraArgs = cmdLine.getArgList();
        if (extraArgs.isEmpty() || extraArgs.size() > 2) {
            throw new InvalidArgumentException("Illegal number of arguments.");
        }
    }

    public ICommandExecutor newExecutor(CLIProcessor.CallingContext callingContext, CommandLine cmdLine) {
        return ICommandExecutor.using((CLIProcessor.CallingContext)callingContext, (CommandLine)cmdLine, this::executeCommand);
    }

    protected ExitStatus executeCommand(@NonNull CLIProcessor.CallingContext callingContext, @NonNull CommandLine cmdLine) {
        IModule module;
        List extraArgs = cmdLine.getArgList();
        Path destination = null;
        if (extraArgs.size() > 1) {
            destination = Paths.get((String)extraArgs.get(1), new String[0]).toAbsolutePath();
        }
        if (destination != null) {
            if (Files.exists(destination, new LinkOption[0])) {
                if (!cmdLine.hasOption(MetaschemaCommands.OVERWRITE_OPTION)) {
                    return ExitCode.INVALID_ARGUMENTS.exitMessage(new Object[]{String.format("The provided destination '%s' already exists and the '%s' option was not provided.", destination, OptionUtils.toArgument((Option)MetaschemaCommands.OVERWRITE_OPTION))});
                }
                if (!Files.isWritable(destination)) {
                    return ExitCode.IO_ERROR.exitMessage(new Object[]{"The provided destination '" + destination + "' is not writable."});
                }
            } else {
                Path parent = destination.getParent();
                if (parent != null) {
                    try {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    catch (IOException ex) {
                        return ExitCode.INVALID_TARGET.exit().withThrowable((Throwable)ex);
                    }
                }
            }
        }
        URI cwd = (URI)ObjectUtils.notNull((Object)Paths.get("", new String[0]).toAbsolutePath().toUri());
        try {
            URI moduleUri = UriUtils.toUri((String)((String)ObjectUtils.requireNonNull((Object)((String)extraArgs.get(0)))), (URI)cwd);
            module = MetaschemaCommands.handleModule(moduleUri, CollectionUtil.emptyList());
        }
        catch (URISyntaxException ex) {
            return ExitCode.INVALID_ARGUMENTS.exitMessage(new Object[]{String.format("Cannot load module as '%s' is not a valid file or URL.", ex.getInput())}).withThrowable((Throwable)ex);
        }
        catch (MetaschemaException | IOException ex) {
            return ExitCode.PROCESSING_ERROR.exit().withThrowable(ex);
        }
        try {
            if (destination == null) {
                StringWriter stringWriter = new StringWriter();
                try (PrintWriter writer = new PrintWriter(stringWriter);){
                    MermaidErDiagramGenerator.generate((IModule)module, (PrintWriter)writer);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(((Object)stringWriter).toString());
                }
            } else {
                try (BufferedWriter writer = Files.newBufferedWriter(destination, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                     PrintWriter printWriter = new PrintWriter(writer);){
                    MermaidErDiagramGenerator.generate((IModule)module, (PrintWriter)printWriter);
                }
            }
            return ExitCode.OK.exit();
        }
        catch (Exception ex) {
            return ExitCode.PROCESSING_ERROR.exit().withThrowable((Throwable)ex);
        }
    }
}

