/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.commands.MetaschemaCommands;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.ExitStatus;
import gov.nist.secauto.metaschema.cli.processor.InvalidArgumentException;
import gov.nist.secauto.metaschema.cli.processor.OptionUtils;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractTerminalCommand;
import gov.nist.secauto.metaschema.cli.processor.command.DefaultExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import gov.nist.secauto.metaschema.core.configuration.DefaultConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfigurationFeature;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.model.xml.ModuleLoader;
import gov.nist.secauto.metaschema.core.util.CustomCollectors;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.core.util.UriUtils;
import gov.nist.secauto.metaschema.databind.io.Format;
import gov.nist.secauto.metaschema.schemagen.ISchemaGenerator;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenerateSchemaCommand
extends AbstractTerminalCommand {
    private static final Logger LOGGER = LogManager.getLogger(GenerateSchemaCommand.class);
    @NonNull
    private static final String COMMAND = "generate-schema";
    @NonNull
    private static final List<ExtraArgument> EXTRA_ARGUMENTS;
    @NonNull
    private static final Option AS_OPTION;
    @NonNull
    private static final Option INLINE_TYPES_OPTION;

    public String getName() {
        return COMMAND;
    }

    public String getDescription() {
        return "Generate a schema for the specified Module module";
    }

    public Collection<? extends Option> gatherOptions() {
        return List.of(MetaschemaCommands.OVERWRITE_OPTION, AS_OPTION, INLINE_TYPES_OPTION);
    }

    public List<ExtraArgument> getExtraArguments() {
        return EXTRA_ARGUMENTS;
    }

    public void validateOptions(CLIProcessor.CallingContext callingContext, CommandLine cmdLine) throws InvalidArgumentException {
        try {
            String asFormatText = cmdLine.getOptionValue(AS_OPTION);
            if (asFormatText != null) {
                ISchemaGenerator.SchemaFormat.valueOf((String)asFormatText.toUpperCase(Locale.ROOT));
            }
        }
        catch (IllegalArgumentException ex) {
            InvalidArgumentException newEx = new InvalidArgumentException(String.format("Invalid '%s' argument. The format must be one of: %s.", OptionUtils.toArgument((Option)AS_OPTION), Arrays.asList(Format.values()).stream().map(format -> format.name()).collect(CustomCollectors.joiningWithOxfordComma((String)"and"))));
            newEx.setOption(AS_OPTION);
            newEx.addSuppressed((Throwable)ex);
            throw newEx;
        }
        List extraArgs = cmdLine.getArgList();
        if (extraArgs.isEmpty() || extraArgs.size() > 2) {
            throw new InvalidArgumentException("Illegal number of arguments.");
        }
    }

    public ICommandExecutor newExecutor(CLIProcessor.CallingContext callingContext, CommandLine cmdLine) {
        return ICommandExecutor.using((CLIProcessor.CallingContext)callingContext, (CommandLine)cmdLine, this::executeCommand);
    }

    protected ExitStatus executeCommand(@NonNull CLIProcessor.CallingContext callingContext, @NonNull CommandLine cmdLine) {
        URI input;
        List extraArgs = cmdLine.getArgList();
        Path destination = null;
        if (extraArgs.size() > 1) {
            destination = Paths.get((String)extraArgs.get(1), new String[0]).toAbsolutePath();
        }
        if (destination != null) {
            if (Files.exists(destination, new LinkOption[0])) {
                if (!cmdLine.hasOption(MetaschemaCommands.OVERWRITE_OPTION)) {
                    return ExitCode.INVALID_ARGUMENTS.exitMessage(new Object[]{String.format("The provided destination '%s' already exists and the '%s' option was not provided.", destination, OptionUtils.toArgument((Option)MetaschemaCommands.OVERWRITE_OPTION))});
                }
                if (!Files.isWritable(destination)) {
                    return ExitCode.IO_ERROR.exitMessage(new Object[]{"The provided destination '" + destination + "' is not writable."});
                }
            } else {
                Path parent = destination.getParent();
                if (parent != null) {
                    try {
                        Files.createDirectories(parent, new FileAttribute[0]);
                    }
                    catch (IOException ex) {
                        return ExitCode.INVALID_TARGET.exit().withThrowable((Throwable)ex);
                    }
                }
            }
        }
        String asFormatText = cmdLine.getOptionValue(AS_OPTION);
        ISchemaGenerator.SchemaFormat asFormat = ISchemaGenerator.SchemaFormat.valueOf((String)asFormatText.toUpperCase(Locale.ROOT));
        DefaultConfiguration configuration = new DefaultConfiguration();
        if (cmdLine.hasOption(INLINE_TYPES_OPTION)) {
            configuration.enableFeature((IConfigurationFeature)SchemaGenerationFeature.INLINE_DEFINITIONS);
            if (ISchemaGenerator.SchemaFormat.JSON.equals((Object)asFormat)) {
                configuration.disableFeature((IConfigurationFeature)SchemaGenerationFeature.INLINE_CHOICE_DEFINITIONS);
            } else {
                configuration.enableFeature((IConfigurationFeature)SchemaGenerationFeature.INLINE_CHOICE_DEFINITIONS);
            }
        }
        String inputName = (String)ObjectUtils.notNull((Object)((String)extraArgs.get(0)));
        URI cwd = (URI)ObjectUtils.notNull((Object)Paths.get("", new String[0]).toAbsolutePath().toUri());
        try {
            input = UriUtils.toUri((String)inputName, (URI)cwd);
        }
        catch (URISyntaxException ex) {
            return ExitCode.IO_ERROR.exitMessage(new Object[]{String.format("Unable to load '%s' as it is not a valid file or URI.", inputName)}).withThrowable((Throwable)ex);
        }
        assert (input != null);
        try {
            ModuleLoader loader = new ModuleLoader();
            loader.allowEntityResolution();
            IModule module = (IModule)loader.load(input);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Generating {} schema for '{}'.", (Object)asFormat.name(), (Object)input);
            }
            if (destination == null) {
                OutputStream os = (OutputStream)ObjectUtils.notNull((Object)System.out);
                ISchemaGenerator.generateSchema((IModule)module, (OutputStream)os, (ISchemaGenerator.SchemaFormat)asFormat, (IConfiguration)configuration);
            } else {
                ISchemaGenerator.generateSchema((IModule)module, (Path)destination, (ISchemaGenerator.SchemaFormat)asFormat, (IConfiguration)configuration);
            }
        }
        catch (MetaschemaException | IOException ex) {
            return ExitCode.PROCESSING_ERROR.exit().withThrowable(ex);
        }
        if (destination != null && LOGGER.isInfoEnabled()) {
            LOGGER.info("Generated {} schema file: {}", (Object)asFormat.toString(), (Object)destination);
        }
        return ExitCode.OK.exit();
    }

    static {
        AS_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("as").required().hasArg().argName("FORMAT").desc("source format: xml, json, or yaml").build());
        INLINE_TYPES_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("inline-types").desc("definitions declared inline will be generated as inline types").build());
        EXTRA_ARGUMENTS = (List)ObjectUtils.notNull(List.of(new DefaultExtraArgument("metaschema-module-file-or-URL", true), new DefaultExtraArgument("destination-schema-file", false)));
    }
}

