/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.commands.GenerateDiagramCommand;
import gov.nist.secauto.metaschema.cli.commands.GenerateSchemaCommand;
import gov.nist.secauto.metaschema.cli.commands.ValidateContentUsingModuleCommand;
import gov.nist.secauto.metaschema.cli.commands.ValidateModuleCommand;
import gov.nist.secauto.metaschema.cli.commands.metapath.MetapathCommand;
import gov.nist.secauto.metaschema.cli.processor.command.ICommand;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.core.model.xml.ExternalConstraintsModulePostProcessor;
import gov.nist.secauto.metaschema.core.model.xml.ModuleLoader;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.core.util.UriUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public final class MetaschemaCommands {
    @NonNull
    public static final List<ICommand> COMMANDS = (List)ObjectUtils.notNull(List.of(new ValidateModuleCommand(), new GenerateSchemaCommand(), new GenerateDiagramCommand(), new ValidateContentUsingModuleCommand(), new MetapathCommand()));
    @NonNull
    public static final Option METASCHEMA_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"m").hasArg().argName("FILE_OR_URL").required().desc("metaschema resource").build());
    @NonNull
    public static final Option OVERWRITE_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("overwrite").desc("overwrite the destination if it exists").build());

    @NonNull
    public static IModule handleModule(@NonNull CommandLine commandLine, @NonNull URI cwd, @NonNull Collection<IConstraintSet> constraintSets) throws URISyntaxException, IOException, MetaschemaException {
        String moduleName = (String)ObjectUtils.requireNonNull((Object)commandLine.getOptionValue(METASCHEMA_OPTION));
        URI moduleUri = UriUtils.toUri((String)moduleName, (URI)cwd);
        return MetaschemaCommands.handleModule(moduleUri, constraintSets);
    }

    @NonNull
    public static IModule handleModule(@NonNull URI moduleResource, @NonNull Collection<IConstraintSet> constraintSets) throws IOException, MetaschemaException {
        ExternalConstraintsModulePostProcessor postProcessor = new ExternalConstraintsModulePostProcessor(constraintSets);
        ModuleLoader loader = new ModuleLoader(CollectionUtil.singletonList((Object)postProcessor));
        loader.allowEntityResolution();
        return (IModule)loader.load(moduleResource);
    }

    @NonNull
    public static URI handleResource(@NonNull String location, @NonNull URI cwd) throws IOException {
        try {
            return UriUtils.toUri((String)location, (URI)cwd);
        }
        catch (URISyntaxException ex) {
            IOException newEx = new IOException(String.format("Cannot load module as '%s' is not a valid file or URL.", location));
            newEx.addSuppressed(ex);
            throw newEx;
        }
    }

    private MetaschemaCommands() {
    }
}

