/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.commands.AbstractValidateContentCommand;
import gov.nist.secauto.metaschema.cli.commands.MetaschemaCommands;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import gov.nist.secauto.metaschema.core.configuration.DefaultConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.core.model.util.JsonUtil;
import gov.nist.secauto.metaschema.core.model.util.XmlUtil;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.DefaultBindingContext;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.schemagen.ISchemaGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.json.JSONObject;

public class ValidateContentUsingModuleCommand
extends AbstractValidateContentCommand {
    @NonNull
    private static final String COMMAND = "validate-content";

    @Override
    public String getName() {
        return COMMAND;
    }

    public String getDescription() {
        return "Verify that the provided resource is well-formed and valid to the provided Module-based model.";
    }

    @Override
    public Collection<? extends Option> gatherOptions() {
        Collection<? extends Option> orig = super.gatherOptions();
        ArrayList<Object> retval = new ArrayList<Object>(orig.size() + 1);
        retval.addAll(orig);
        retval.add(MetaschemaCommands.METASCHEMA_OPTION);
        return CollectionUtil.unmodifiableCollection(retval);
    }

    public ICommandExecutor newExecutor(CLIProcessor.CallingContext callingContext, CommandLine commandLine) {
        return new OscalCommandExecutor(callingContext, commandLine);
    }

    private final class OscalCommandExecutor
    extends AbstractValidateContentCommand.AbstractValidationCommandExecutor {
        private Path tempDir;
        private IModule module;

        private OscalCommandExecutor(@NonNull CLIProcessor.CallingContext callingContext, CommandLine commandLine) {
            super(ValidateContentUsingModuleCommand.this, callingContext, commandLine);
        }

        @NonNull
        private Path getTempDir() throws IOException {
            if (this.tempDir == null) {
                this.tempDir = Files.createTempDirectory("validation-", new FileAttribute[0]);
                this.tempDir.toFile().deleteOnExit();
            }
            assert (this.tempDir != null);
            return this.tempDir;
        }

        @NonNull
        private IModule getModule(@NonNull Set<IConstraintSet> constraintSets) throws MetaschemaException, IOException {
            URI cwd = (URI)ObjectUtils.notNull((Object)Paths.get("", new String[0]).toAbsolutePath().toUri());
            if (this.module == null) {
                try {
                    this.module = MetaschemaCommands.handleModule(this.getCommandLine(), cwd, constraintSets);
                }
                catch (URISyntaxException ex) {
                    throw new IOException(String.format("Cannot load module as '%s' is not a valid file or URL.", ex.getInput()), ex);
                }
            }
            assert (this.module != null);
            return this.module;
        }

        @NonNull
        private IModule getModule() {
            return (IModule)ObjectUtils.requireNonNull((Object)this.module);
        }

        @Override
        protected IBindingContext getBindingContext(@NonNull Set<IConstraintSet> constraintSets) throws MetaschemaException, IOException {
            DefaultBindingContext retval = new DefaultBindingContext();
            retval.registerModule(this.getModule(constraintSets), this.getTempDir());
            return retval;
        }

        public List<Source> getXmlSchemas(@NonNull URL targetResource) throws IOException {
            Path schemaFile = Files.createTempFile(this.getTempDir(), "schema-", ".xml", new FileAttribute[0]);
            assert (schemaFile != null);
            DefaultConfiguration configuration = new DefaultConfiguration();
            ISchemaGenerator.generateSchema((IModule)this.getModule(), (Path)schemaFile, (ISchemaGenerator.SchemaFormat)ISchemaGenerator.SchemaFormat.XML, (IConfiguration)configuration);
            return (List)ObjectUtils.requireNonNull(List.of(XmlUtil.getStreamSource((URL)((URL)ObjectUtils.notNull((Object)schemaFile.toUri().toURL())))));
        }

        public JSONObject getJsonSchema(@NonNull JSONObject json) throws IOException {
            Path schemaFile = Files.createTempFile(this.getTempDir(), "schema-", ".json", new FileAttribute[0]);
            assert (schemaFile != null);
            DefaultConfiguration configuration = new DefaultConfiguration();
            ISchemaGenerator.generateSchema((IModule)this.getModule(), (Path)schemaFile, (ISchemaGenerator.SchemaFormat)ISchemaGenerator.SchemaFormat.JSON, (IConfiguration)configuration);
            try (BufferedReader reader = (BufferedReader)ObjectUtils.notNull((Object)Files.newBufferedReader(schemaFile, StandardCharsets.UTF_8));){
                JSONObject jSONObject = JsonUtil.toJsonObject((Reader)reader);
                return jSONObject;
            }
        }
    }
}

