/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.commands.AbstractValidateContentCommand;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import gov.nist.secauto.metaschema.core.configuration.DefaultConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.core.model.util.JsonUtil;
import gov.nist.secauto.metaschema.core.model.util.XmlUtil;
import gov.nist.secauto.metaschema.core.model.xml.ExternalConstraintsModulePostProcessor;
import gov.nist.secauto.metaschema.core.model.xml.ModuleLoader;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.DefaultBindingContext;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.binding.metaschema.METASCHEMA;
import gov.nist.secauto.metaschema.databind.model.binding.metaschema.MetaschemaModelModule;
import gov.nist.secauto.metaschema.schemagen.ISchemaGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.json.JSONObject;

public class ValidateModuleCommand
extends AbstractValidateContentCommand {
    @NonNull
    private static final String COMMAND = "validate";

    @Override
    public String getName() {
        return COMMAND;
    }

    public String getDescription() {
        return "Validate that the specified Module is well-formed and valid to the Module model";
    }

    public ICommandExecutor newExecutor(CLIProcessor.CallingContext callingContext, CommandLine commandLine) {
        return new ValidateModuleCommandExecutor(callingContext, commandLine);
    }

    private final class ValidateModuleCommandExecutor
    extends AbstractValidateContentCommand.AbstractValidationCommandExecutor {
        private Path tempDir;

        private ValidateModuleCommandExecutor(@NonNull CLIProcessor.CallingContext callingContext, CommandLine commandLine) {
            super(callingContext, commandLine);
        }

        private Path getTempDir() throws IOException {
            if (this.tempDir == null) {
                this.tempDir = Files.createTempDirectory("validation-", new FileAttribute[0]);
                this.tempDir.toFile().deleteOnExit();
            }
            return this.tempDir;
        }

        @Override
        protected IBindingContext getBindingContext(Set<IConstraintSet> constraintSets) throws MetaschemaException, IOException {
            IBindingContext retval;
            if (constraintSets.isEmpty()) {
                retval = IBindingContext.instance();
            } else {
                ExternalConstraintsModulePostProcessor postProcessor = new ExternalConstraintsModulePostProcessor(constraintSets);
                retval = new DefaultBindingContext(CollectionUtil.singletonList((Object)postProcessor));
            }
            retval.getBoundDefinitionForClass(METASCHEMA.class);
            return retval;
        }

        public List<Source> getXmlSchemas(@NonNull URL targetResource) throws IOException {
            LinkedList<StreamSource> retval = new LinkedList<StreamSource>();
            retval.add(XmlUtil.getStreamSource((URL)((URL)ObjectUtils.requireNonNull((Object)ModuleLoader.class.getResource("/schema/xml/metaschema.xsd"), (String)"Unable to load '/schema/xml/metaschema.xsd' on the classpath"))));
            return CollectionUtil.unmodifiableList(retval);
        }

        public JSONObject getJsonSchema(@NonNull JSONObject json) throws IOException {
            IBoundModule module = IBindingContext.instance().registerModule(MetaschemaModelModule.class);
            Path schemaFile = Files.createTempFile(this.getTempDir(), "schema-", ".json", new FileAttribute[0]);
            assert (schemaFile != null);
            DefaultConfiguration configuration = new DefaultConfiguration();
            ISchemaGenerator.generateSchema((IModule)module, (Path)schemaFile, (ISchemaGenerator.SchemaFormat)ISchemaGenerator.SchemaFormat.JSON, (IConfiguration)configuration);
            try (BufferedReader reader = (BufferedReader)ObjectUtils.notNull((Object)Files.newBufferedReader(schemaFile, StandardCharsets.UTF_8));){
                JSONObject jSONObject = JsonUtil.toJsonObject((Reader)reader);
                return jSONObject;
            }
        }
    }
}

