/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands.metapath;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.commands.MetaschemaCommands;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.ExitStatus;
import gov.nist.secauto.metaschema.cli.processor.InvalidArgumentException;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractTerminalCommand;
import gov.nist.secauto.metaschema.cli.processor.command.ExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import gov.nist.secauto.metaschema.core.metapath.DynamicContext;
import gov.nist.secauto.metaschema.core.metapath.ISequence;
import gov.nist.secauto.metaschema.core.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.core.metapath.StaticContext;
import gov.nist.secauto.metaschema.core.metapath.item.DefaultItemWriter;
import gov.nist.secauto.metaschema.core.metapath.item.IItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IModuleNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItemFactory;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.core.util.UriUtils;
import gov.nist.secauto.metaschema.databind.DefaultBindingContext;
import gov.nist.secauto.metaschema.databind.io.IBoundLoader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EvaluateMetapathCommand
extends AbstractTerminalCommand {
    private static final Logger LOGGER = LogManager.getLogger(EvaluateMetapathCommand.class);
    @NonNull
    private static final String COMMAND = "eval";
    @NonNull
    private static final Option EXPRESSION_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"e").longOpt("expression").required().hasArg().argName("EXPRESSION").desc("Metapath expression to execute").build());
    @NonNull
    public static final Option CONTENT_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"i").hasArg().argName("FILE_OR_URL").desc("Metaschema content instance resource").build());
    @NonNull
    public static final Option METASCHEMA_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"m").hasArg().argName("FILE_OR_URL").desc("metaschema resource").build());

    public String getName() {
        return COMMAND;
    }

    public String getDescription() {
        return "Execute a Metapath expression against a document";
    }

    public Collection<? extends Option> gatherOptions() {
        return List.of(METASCHEMA_OPTION, CONTENT_OPTION, EXPRESSION_OPTION);
    }

    public List<ExtraArgument> getExtraArguments() {
        return CollectionUtil.emptyList();
    }

    public void validateOptions(CLIProcessor.CallingContext callingContext, CommandLine cmdLine) throws InvalidArgumentException {
        List extraArgs = cmdLine.getArgList();
        if (!extraArgs.isEmpty()) {
            throw new InvalidArgumentException("Illegal number of extra arguments.");
        }
    }

    public ICommandExecutor newExecutor(CLIProcessor.CallingContext callingContext, CommandLine cmdLine) {
        return ICommandExecutor.using((CLIProcessor.CallingContext)callingContext, (CommandLine)cmdLine, this::executeCommand);
    }

    protected ExitStatus executeCommand(@NonNull CLIProcessor.CallingContext callingContext, @NonNull CommandLine cmdLine) {
        IModuleNodeItem item;
        IModule module;
        URI cwd = (URI)ObjectUtils.notNull((Object)Paths.get("", new String[0]).toAbsolutePath().toUri());
        if (cmdLine.hasOption(METASCHEMA_OPTION)) {
            try {
                String moduleName = (String)ObjectUtils.requireNonNull((Object)cmdLine.getOptionValue(METASCHEMA_OPTION));
                URI moduleUri = UriUtils.toUri((String)moduleName, (URI)cwd);
                module = MetaschemaCommands.handleModule(moduleUri, CollectionUtil.emptyList());
            }
            catch (URISyntaxException ex) {
                return ExitCode.INVALID_ARGUMENTS.exitMessage(new Object[]{String.format("Cannot load module as '%s' is not a valid file or URL.", ex.getInput())}).withThrowable((Throwable)ex);
            }
            catch (MetaschemaException | IOException ex) {
                return ExitCode.PROCESSING_ERROR.exit().withThrowable(ex);
            }
            if (cmdLine.hasOption(CONTENT_OPTION)) {
                URI contentResource;
                DefaultBindingContext bindingContext = new DefaultBindingContext();
                try {
                    Path compilePath = Files.createTempDirectory("validation-", new FileAttribute[0]);
                    compilePath.toFile().deleteOnExit();
                    bindingContext.registerModule(module, compilePath);
                }
                catch (IOException ex) {
                    return ExitCode.PROCESSING_ERROR.exitMessage(new Object[]{"Unable to get binding context. " + ex.getMessage()}).withThrowable((Throwable)ex);
                }
                IBoundLoader loader = bindingContext.newBoundLoader();
                try {
                    contentResource = MetaschemaCommands.handleResource(cmdLine.getOptionValue(CONTENT_OPTION), cwd);
                }
                catch (IOException ex) {
                    return ExitCode.INVALID_ARGUMENTS.exitMessage(new Object[]{"Unable to resolve content location. " + ex.getMessage()}).withThrowable((Throwable)ex);
                }
                try {
                    item = loader.loadAsNodeItem(contentResource);
                }
                catch (IOException ex) {
                    return ExitCode.INVALID_ARGUMENTS.exitMessage(new Object[]{"Unable to resolve content location. " + ex.getMessage()}).withThrowable((Throwable)ex);
                }
            }
            item = INodeItemFactory.instance().newModuleNodeItem(module);
        } else {
            if (cmdLine.hasOption(CONTENT_OPTION)) {
                return ExitCode.INVALID_ARGUMENTS.exitMessage(new Object[]{String.format("Must use '%s' to specify the Metaschema module.", CONTENT_OPTION.getArgName())});
            }
            module = null;
            item = null;
        }
        String expression = cmdLine.getOptionValue(EXPRESSION_OPTION);
        StaticContext.Builder builder = StaticContext.builder();
        if (module != null) {
            builder.defaultModelNamespace(module.getXmlNamespace());
        }
        StaticContext staticContext = builder.build();
        try {
            MetapathExpression compiledMetapath = MetapathExpression.compile((String)expression, (StaticContext)staticContext);
            ISequence sequence = compiledMetapath.evaluate((IItem)item, new DynamicContext(staticContext));
            StringWriter stringWriter = new StringWriter();
            try (PrintWriter writer = new PrintWriter(stringWriter);){
                DefaultItemWriter itemWriter = new DefaultItemWriter(writer);
                itemWriter.writeSequence(sequence);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(((Object)stringWriter).toString());
            }
            return ExitCode.OK.exit();
        }
        catch (Exception ex) {
            return ExitCode.PROCESSING_ERROR.exit().withThrowable((Throwable)ex);
        }
    }
}

