/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands.metapath;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.ExitStatus;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractTerminalCommand;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import gov.nist.secauto.metaschema.core.metapath.StaticContext;
import gov.nist.secauto.metaschema.core.metapath.function.FunctionService;
import gov.nist.secauto.metaschema.core.metapath.function.IArgument;
import gov.nist.secauto.metaschema.core.metapath.function.IFunction;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListFunctionsSubcommand
extends AbstractTerminalCommand {
    private static final Logger LOGGER = LogManager.getLogger(ListFunctionsSubcommand.class);
    @NonNull
    private static final String COMMAND = "list-functions";

    public String getName() {
        return COMMAND;
    }

    public String getDescription() {
        return "Get a listing of supported Metapath functions";
    }

    public ICommandExecutor newExecutor(CLIProcessor.CallingContext callingContext, CommandLine cmdLine) {
        return ICommandExecutor.using((CLIProcessor.CallingContext)callingContext, (CommandLine)cmdLine, this::executeCommand);
    }

    protected ExitStatus executeCommand(@NonNull CLIProcessor.CallingContext callingContext, @NonNull CommandLine cmdLine) {
        Map namespaceToNameToFunctionMap = FunctionService.getInstance().stream().collect(Collectors.groupingBy(function -> function.getQName().getNamespaceURI(), Collectors.groupingBy(IFunction::getName, Collectors.toList())));
        Map<String, String> namespaceToPrefixMap = StaticContext.getWellKnownNamespacesMap().entrySet().stream().collect(Collectors.toMap(entry -> ((URI)entry.getValue()).toASCIIString(), Map.Entry::getKey));
        ArrayList<String> namespaces = new ArrayList<String>(namespaceToNameToFunctionMap.keySet());
        Collections.sort(namespaces);
        for (String namespace : namespaces) {
            String prefix = namespaceToPrefixMap.get(namespace);
            if (prefix == null) {
                LOGGER.atInfo().log("In namespace '{}':", (Object)namespace);
            } else {
                LOGGER.atInfo().log("In namespace '{}' as '{}':", (Object)namespace, (Object)prefix);
            }
            Map namespacedFunctions = namespaceToNameToFunctionMap.get(namespace);
            ArrayList<String> names = new ArrayList<String>(namespacedFunctions.keySet());
            Collections.sort(names);
            for (String name : names) {
                List functions = namespacedFunctions.get(name);
                Collections.sort(functions, Comparator.comparing(IFunction::arity));
                for (IFunction function2 : functions) {
                    String functionRef = prefix == null ? String.format("Q{%s}%s", function2.getQName().getNamespaceURI(), function2.getName()) : String.format("%s:%s", prefix, function2.getName());
                    LOGGER.atInfo().log(String.format("%s(%s) as %s", functionRef, function2.getArguments().isEmpty() ? "" : function2.getArguments().stream().map(IArgument::toSignature).collect(Collectors.joining(",")) + (function2.isArityUnbounded() ? ", ..." : ""), function2.getResult().toSignature()));
                }
            }
        }
        return ExitCode.OK.exit();
    }
}

