/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.model.constraint.ConstraintValidationFinding;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.model.validation.IValidationFinding;
import gov.nist.secauto.metaschema.core.model.validation.IValidationResult;
import gov.nist.secauto.metaschema.core.model.validation.JsonSchemaContentValidator;
import gov.nist.secauto.metaschema.core.model.validation.XmlSchemaContentValidator;
import java.net.URI;
import java.util.List;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.fusesource.jansi.Ansi;
import org.xml.sax.SAXParseException;

public final class LoggingValidationHandler {
    private static final Logger LOGGER = LogManager.getLogger(LoggingValidationHandler.class);
    @NonNull
    private static final LoggingValidationHandler NO_LOG_EXCPTION_INSTANCE = new LoggingValidationHandler(false);
    @NonNull
    private static final LoggingValidationHandler LOG_EXCPTION_INSTANCE = new LoggingValidationHandler(true);
    private final boolean logExceptions;

    @NonNull
    public static LoggingValidationHandler instance() {
        return LoggingValidationHandler.instance(false);
    }

    @SuppressFBWarnings(value={"SING_SINGLETON_GETTER_NOT_SYNCHRONIZED"}, justification="both values are class initialized")
    @NonNull
    public static LoggingValidationHandler instance(boolean logExceptions) {
        return logExceptions ? LOG_EXCPTION_INSTANCE : NO_LOG_EXCPTION_INSTANCE;
    }

    private LoggingValidationHandler(boolean logExceptions) {
        this.logExceptions = logExceptions;
    }

    public boolean isLogExceptions() {
        return this.logExceptions;
    }

    public boolean handleValidationResults(IValidationResult result) {
        this.handleValidationFindings(result.getFindings());
        return result.isPassing();
    }

    public void handleValidationFindings(@NonNull List<? extends IValidationFinding> findings) {
        for (IValidationFinding iValidationFinding : findings) {
            if (iValidationFinding instanceof JsonSchemaContentValidator.JsonValidationFinding) {
                this.handleJsonValidationFinding((JsonSchemaContentValidator.JsonValidationFinding)iValidationFinding);
                continue;
            }
            if (iValidationFinding instanceof XmlSchemaContentValidator.XmlValidationFinding) {
                this.handleXmlValidationFinding((XmlSchemaContentValidator.XmlValidationFinding)iValidationFinding);
                continue;
            }
            if (iValidationFinding instanceof ConstraintValidationFinding) {
                this.handleConstraintValidationFinding((ConstraintValidationFinding)iValidationFinding);
                continue;
            }
            throw new IllegalStateException();
        }
    }

    private void handleJsonValidationFinding(@NonNull JsonSchemaContentValidator.JsonValidationFinding finding) {
        Ansi ansi = this.generatePreamble(finding.getSeverity());
        ansi = ansi.a('[').fgBright(Ansi.Color.WHITE).a(finding.getCause().getPointerToViolation()).reset().a(']');
        URI documentUri = finding.getDocumentUri();
        ansi = documentUri == null ? ansi.format(" %s", new Object[]{finding.getMessage()}) : ansi.format(" %s [%s]", new Object[]{finding.getMessage(), documentUri.toString()});
        this.getLogger((IValidationFinding)finding).log((Object)ansi);
    }

    private void handleXmlValidationFinding(XmlSchemaContentValidator.XmlValidationFinding finding) {
        Ansi ansi = this.generatePreamble(finding.getSeverity());
        SAXParseException ex = finding.getCause();
        URI documentUri = finding.getDocumentUri();
        ansi = documentUri == null ? ansi.format("%s [{%d,%d}]", new Object[]{finding.getMessage(), ex.getLineNumber(), ex.getColumnNumber()}) : ansi.format("%s [%s{%d,%d}]", new Object[]{finding.getMessage(), documentUri.toString(), ex.getLineNumber(), ex.getColumnNumber()});
        this.getLogger((IValidationFinding)finding).log((Object)ansi);
    }

    private void handleConstraintValidationFinding(@NonNull ConstraintValidationFinding finding) {
        Ansi ansi = this.generatePreamble(finding.getSeverity());
        this.getLogger((IValidationFinding)finding).log((Object)ansi.format("[%s] %s", new Object[]{finding.getTarget().getMetapath(), finding.getMessage()}));
    }

    @NonNull
    private LogBuilder getLogger(@NonNull IValidationFinding finding) {
        LogBuilder retval;
        switch (finding.getSeverity()) {
            case CRITICAL: {
                retval = LOGGER.atFatal();
                break;
            }
            case ERROR: {
                retval = LOGGER.atError();
                break;
            }
            case WARNING: {
                retval = LOGGER.atWarn();
                break;
            }
            case INFORMATIONAL: {
                retval = LOGGER.atInfo();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level: " + finding.getSeverity().name());
            }
        }
        assert (retval != null);
        if (finding.getCause() != null && this.isLogExceptions()) {
            retval.withThrowable(finding.getCause());
        }
        return retval;
    }

    @NonNull
    private Ansi generatePreamble(@NonNull IConstraint.Level level) {
        Ansi ansi = Ansi.ansi().fgBright(Ansi.Color.WHITE).a('[').reset();
        switch (level) {
            case CRITICAL: {
                ansi = ansi.fgRed().a("CRITICAL").reset();
                break;
            }
            case ERROR: {
                ansi = ansi.fgBrightRed().a("ERROR").reset();
                break;
            }
            case WARNING: {
                ansi = ansi.fgBrightYellow().a("WARNING").reset();
                break;
            }
            case INFORMATIONAL: {
                ansi = ansi.fgBrightBlue().a("INFO").reset();
                break;
            }
            default: {
                ansi = Ansi.ansi().fgBright(Ansi.Color.MAGENTA).a(level.name()).reset();
            }
        }
        ansi = ansi.fgBright(Ansi.Color.WHITE).a("] ").reset();
        assert (ansi != null);
        return ansi;
    }
}

