/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.commands.MetaschemaCommands;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.ExitStatus;
import gov.nist.secauto.metaschema.cli.processor.command.CommandService;
import gov.nist.secauto.metaschema.core.MetaschemaJavaVersion;
import gov.nist.secauto.metaschema.core.model.MetaschemaVersion;
import java.util.LinkedHashMap;

public final class CLI {
    public static void main(String[] args) {
        System.exit(CLI.runCli(args).getExitCode().getStatusCode());
    }

    @NonNull
    public static ExitStatus runCli(String ... args) {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        LinkedHashMap<String, Object> versions = new LinkedHashMap<String, Object>();
        versions.put("http://csrc.nist.gov/ns/metaschema-java/cli/command-version", new MetaschemaJavaVersion());
        versions.put("http://csrc.nist.gov/ns/oscal/metaschema/1.0", new MetaschemaVersion());
        CLIProcessor processor = new CLIProcessor("metaschema-cli", versions);
        MetaschemaCommands.COMMANDS.forEach(arg_0 -> ((CLIProcessor)processor).addCommandHandler(arg_0));
        CommandService.getInstance().getCommands().stream().forEach(command -> {
            assert (command != null);
            processor.addCommandHandler(command);
        });
        return processor.process(args);
    }

    private CLI() {
    }
}

