/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.commands.MetaschemaCommands;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractCommandExecutor;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractTerminalCommand;
import gov.nist.secauto.metaschema.cli.processor.command.CommandExecutionException;
import gov.nist.secauto.metaschema.cli.processor.command.DefaultExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ExtraArgument;
import gov.nist.secauto.metaschema.core.util.AutoCloser;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.Format;
import gov.nist.secauto.metaschema.databind.io.IBoundLoader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractConvertSubcommand
extends AbstractTerminalCommand {
    private static final Logger LOGGER = LogManager.getLogger(AbstractConvertSubcommand.class);
    @NonNull
    private static final String COMMAND = "convert";
    @NonNull
    private static final List<ExtraArgument> EXTRA_ARGUMENTS = (List)ObjectUtils.notNull(List.of(new DefaultExtraArgument("source-file-or-URL", true), new DefaultExtraArgument("destination-file", false)));

    public String getName() {
        return COMMAND;
    }

    public Collection<? extends Option> gatherOptions() {
        return (Collection)ObjectUtils.notNull(List.of(MetaschemaCommands.OVERWRITE_OPTION, MetaschemaCommands.TO_OPTION));
    }

    public List<ExtraArgument> getExtraArguments() {
        return EXTRA_ARGUMENTS;
    }

    protected static abstract class AbstractConversionCommandExecutor
    extends AbstractCommandExecutor {
        protected AbstractConversionCommandExecutor(@NonNull CLIProcessor.CallingContext callingContext, @NonNull CommandLine commandLine) {
            super(callingContext, commandLine);
        }

        @NonNull
        protected abstract IBindingContext getBindingContext() throws CommandExecutionException;

        public void execute() throws CommandExecutionException {
            Format toFormat;
            Path destination;
            block19: {
                CommandLine cmdLine = this.getCommandLine();
                List extraArgs = cmdLine.getArgList();
                destination = null;
                if (extraArgs.size() > 1) {
                    destination = MetaschemaCommands.handleDestination((String)ObjectUtils.requireNonNull((Object)((String)extraArgs.get(1))), cmdLine);
                }
                URI source = MetaschemaCommands.handleSource((String)ObjectUtils.requireNonNull((Object)((String)extraArgs.get(0))), (URI)ObjectUtils.notNull((Object)AbstractConvertSubcommand.getCurrentWorkingDirectory().toUri()));
                toFormat = MetaschemaCommands.getFormat(cmdLine, MetaschemaCommands.TO_OPTION);
                IBindingContext bindingContext = this.getBindingContext();
                try {
                    IBoundLoader loader = bindingContext.newBoundLoader();
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Converting '{}'.", (Object)source);
                    }
                    if (destination == null) {
                        try (OutputStreamWriter writer = new OutputStreamWriter(AutoCloser.preventClose((OutputStream)System.out), StandardCharsets.UTF_8);){
                            this.handleConversion(source, toFormat, writer, loader);
                            break block19;
                        }
                    }
                    try (BufferedWriter writer = Files.newBufferedWriter(destination, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                        assert (writer != null);
                        this.handleConversion(source, toFormat, writer, loader);
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new CommandExecutionException(ExitCode.PROCESSING_ERROR, (Throwable)ex);
                }
                catch (IOException ex) {
                    throw new CommandExecutionException(ExitCode.IO_ERROR, (Throwable)ex);
                }
            }
            if (destination != null && LOGGER.isInfoEnabled()) {
                LOGGER.info("Generated {} file: {}", (Object)toFormat.toString(), (Object)destination);
            }
        }

        protected abstract void handleConversion(@NonNull URI var1, @NonNull Format var2, @NonNull Writer var3, @NonNull IBoundLoader var4) throws FileNotFoundException, IOException;
    }
}

