/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.cli.commands.MetaschemaCommands;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractCommandExecutor;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractTerminalCommand;
import gov.nist.secauto.metaschema.cli.processor.command.CommandExecutionException;
import gov.nist.secauto.metaschema.cli.processor.command.DefaultExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ExtraArgument;
import gov.nist.secauto.metaschema.cli.util.LoggingValidationHandler;
import gov.nist.secauto.metaschema.core.configuration.DefaultConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfigurationFeature;
import gov.nist.secauto.metaschema.core.metapath.MetapathException;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.core.model.constraint.ValidationFeature;
import gov.nist.secauto.metaschema.core.model.validation.AggregateValidationResult;
import gov.nist.secauto.metaschema.core.model.validation.IValidationResult;
import gov.nist.secauto.metaschema.core.util.IVersionInfo;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.Format;
import gov.nist.secauto.metaschema.databind.io.IBoundLoader;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.modules.sarif.SarifValidationHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractValidateContentCommand
extends AbstractTerminalCommand {
    private static final Logger LOGGER = LogManager.getLogger(AbstractValidateContentCommand.class);
    @NonNull
    private static final String COMMAND = "validate";
    @NonNull
    private static final List<ExtraArgument> EXTRA_ARGUMENTS = (List)ObjectUtils.notNull(List.of(new DefaultExtraArgument("file-or-URI-to-validate", true)));
    @NonNull
    private static final Option CONSTRAINTS_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"c").hasArgs().argName("URL").desc("additional constraint definitions").build());
    @NonNull
    private static final Option SARIF_OUTPUT_FILE_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"o").hasArg().argName("FILE").desc("write SARIF results to the provided FILE").numberOfArgs(1).build());
    @NonNull
    private static final Option SARIF_INCLUDE_PASS_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("sarif-include-pass").desc("include pass results in SARIF").build());
    @NonNull
    private static final Option NO_SCHEMA_VALIDATION_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("disable-schema-validation").desc("do not perform schema validation").build());
    @NonNull
    private static final Option NO_CONSTRAINT_VALIDATION_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("disable-constraint-validation").desc("do not perform constraint validation").build());

    public String getName() {
        return COMMAND;
    }

    public Collection<? extends Option> gatherOptions() {
        return List.of(MetaschemaCommands.AS_FORMAT_OPTION, CONSTRAINTS_OPTION, SARIF_OUTPUT_FILE_OPTION, SARIF_INCLUDE_PASS_OPTION, NO_SCHEMA_VALIDATION_OPTION, NO_CONSTRAINT_VALIDATION_OPTION);
    }

    public List<ExtraArgument> getExtraArguments() {
        return EXTRA_ARGUMENTS;
    }

    protected abstract class AbstractValidationCommandExecutor
    extends AbstractCommandExecutor {
        public AbstractValidationCommandExecutor(@NonNull CLIProcessor.CallingContext callingContext, CommandLine commandLine) {
            super(callingContext, commandLine);
        }

        @NonNull
        protected abstract IBindingContext getBindingContext(@NonNull Set<IConstraintSet> var1) throws CommandExecutionException;

        @NonNull
        protected abstract IModule getModule(@NonNull CommandLine var1, @NonNull IBindingContext var2) throws CommandExecutionException;

        @NonNull
        protected abstract IBindingContext.ISchemaValidationProvider getSchemaValidationProvider(@NonNull IModule var1, @NonNull CommandLine var2, @NonNull IBindingContext var3);

        public void execute() throws CommandExecutionException {
            CommandLine cmdLine = this.getCommandLine();
            URI currentWorkingDirectory = (URI)ObjectUtils.notNull((Object)AbstractValidateContentCommand.getCurrentWorkingDirectory().toUri());
            Set<IConstraintSet> constraintSets = MetaschemaCommands.loadConstraintSets(cmdLine, CONSTRAINTS_OPTION, currentWorkingDirectory);
            List extraArgs = cmdLine.getArgList();
            URI source = MetaschemaCommands.handleSource((String)ObjectUtils.requireNonNull((Object)((String)extraArgs.get(0))), currentWorkingDirectory);
            IBindingContext bindingContext = this.getBindingContext(constraintSets);
            IBoundLoader loader = bindingContext.newBoundLoader();
            Format asFormat = MetaschemaCommands.determineSourceFormat(cmdLine, MetaschemaCommands.AS_FORMAT_OPTION, loader, source);
            IValidationResult validationResult = this.validate(source, asFormat, cmdLine, bindingContext);
            this.handleOutput(source, validationResult, cmdLine, bindingContext);
            if (validationResult == null || validationResult.isPassing()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("The file '{}' is valid.", (Object)source);
                }
            } else if (LOGGER.isErrorEnabled()) {
                LOGGER.error("The file '{}' is invalid.", (Object)source);
            }
            if (validationResult != null && !validationResult.isPassing()) {
                throw new CommandExecutionException(ExitCode.FAIL);
            }
        }

        @Nullable
        private IValidationResult validate(@NonNull URI source, @NonNull Format asFormat, @NonNull CommandLine commandLine, @NonNull IBindingContext bindingContext) throws CommandExecutionException {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Validating '{}' as {}.", (Object)source, (Object)asFormat.name());
            }
            IValidationResult validationResult = null;
            try {
                IBoundModule module = bindingContext.registerModule(this.getModule(commandLine, bindingContext));
                if (!commandLine.hasOption(NO_SCHEMA_VALIDATION_OPTION)) {
                    validationResult = this.getSchemaValidationProvider((IModule)module, commandLine, bindingContext).validateWithSchema(source, asFormat, bindingContext);
                }
                if (!commandLine.hasOption(NO_CONSTRAINT_VALIDATION_OPTION)) {
                    DefaultConfiguration configuration = new DefaultConfiguration();
                    if (commandLine.hasOption(SARIF_OUTPUT_FILE_OPTION) && commandLine.hasOption(SARIF_INCLUDE_PASS_OPTION)) {
                        configuration.enableFeature((IConfigurationFeature)ValidationFeature.VALIDATE_GENERATE_PASS_FINDINGS);
                    }
                    IValidationResult constraintValidationResult = bindingContext.validateWithConstraints(source, (IConfiguration)configuration);
                    validationResult = validationResult == null ? constraintValidationResult : AggregateValidationResult.aggregate((IValidationResult[])new IValidationResult[]{validationResult, constraintValidationResult});
                }
            }
            catch (FileNotFoundException ex) {
                throw new CommandExecutionException(ExitCode.IO_ERROR, String.format("Resource not found at '%s'", source), (Throwable)ex);
            }
            catch (UnknownHostException ex) {
                throw new CommandExecutionException(ExitCode.IO_ERROR, String.format("Unknown host for '%s'.", source), (Throwable)ex);
            }
            catch (IOException ex) {
                throw new CommandExecutionException(ExitCode.IO_ERROR, ex.getLocalizedMessage(), (Throwable)ex);
            }
            catch (MetapathException ex) {
                throw new CommandExecutionException(ExitCode.PROCESSING_ERROR, ex.getLocalizedMessage(), (Throwable)ex);
            }
            return validationResult;
        }

        private void handleOutput(@NonNull URI source, @Nullable IValidationResult validationResult, @NonNull CommandLine commandLine, @NonNull IBindingContext bindingContext) throws CommandExecutionException {
            if (commandLine.hasOption(SARIF_OUTPUT_FILE_OPTION) && LOGGER.isInfoEnabled()) {
                Path sarifFile = (Path)ObjectUtils.notNull((Object)Paths.get(commandLine.getOptionValue(SARIF_OUTPUT_FILE_OPTION), new String[0]));
                IVersionInfo version = (IVersionInfo)this.getCallingContext().getCLIProcessor().getVersionInfos().get("http://csrc.nist.gov/ns/metaschema-java/cli/command-version");
                try {
                    SarifValidationHandler sarifHandler = new SarifValidationHandler(source, version);
                    if (validationResult != null) {
                        sarifHandler.addFindings((Collection)validationResult.getFindings());
                    }
                    sarifHandler.write(sarifFile, bindingContext);
                }
                catch (IOException ex) {
                    throw new CommandExecutionException(ExitCode.IO_ERROR, ex.getLocalizedMessage(), (Throwable)ex);
                }
            } else if (validationResult != null && !validationResult.getFindings().isEmpty()) {
                LOGGER.info("Validation identified the following issues:");
                LoggingValidationHandler.instance().handleResults(validationResult);
            }
        }
    }
}

