/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.cli.commands.MetaschemaCommands;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractTerminalCommand;
import gov.nist.secauto.metaschema.cli.processor.command.CommandExecutionException;
import gov.nist.secauto.metaschema.cli.processor.command.DefaultExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.util.MermaidErDiagramGenerator;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class GenerateDiagramCommand
extends AbstractTerminalCommand {
    private static final Logger LOGGER = LogManager.getLogger(GenerateDiagramCommand.class);
    @NonNull
    private static final String COMMAND = "generate-diagram";
    @NonNull
    private static final List<ExtraArgument> EXTRA_ARGUMENTS = (List)ObjectUtils.notNull(List.of(new DefaultExtraArgument("metaschema-module-file-or-URL", true), new DefaultExtraArgument("destination-diagram-file", false)));

    GenerateDiagramCommand() {
    }

    public String getName() {
        return COMMAND;
    }

    public String getDescription() {
        return "Generate a diagram for the provided Metaschema module";
    }

    public Collection<? extends Option> gatherOptions() {
        return List.of(MetaschemaCommands.OVERWRITE_OPTION);
    }

    public List<ExtraArgument> getExtraArguments() {
        return EXTRA_ARGUMENTS;
    }

    public ICommandExecutor newExecutor(CLIProcessor.CallingContext callingContext, CommandLine cmdLine) {
        return ICommandExecutor.using((CLIProcessor.CallingContext)callingContext, (CommandLine)cmdLine, this::executeCommand);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Catching generic exception for CLI error handling")
    protected void executeCommand(@NonNull CLIProcessor.CallingContext callingContext, @NonNull CommandLine cmdLine) throws CommandExecutionException {
        URI moduleUri;
        List extraArgs = cmdLine.getArgList();
        Path destination = null;
        if (extraArgs.size() > 1) {
            destination = MetaschemaCommands.handleDestination((String)ObjectUtils.requireNonNull((Object)((String)extraArgs.get(1))), cmdLine);
        }
        IBindingContext bindingContext = MetaschemaCommands.newBindingContextWithDynamicCompilation();
        try {
            moduleUri = GenerateDiagramCommand.resolveAgainstCWD((String)((String)ObjectUtils.requireNonNull((Object)((String)extraArgs.get(0)))));
        }
        catch (URISyntaxException ex) {
            throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("Cannot load module as '%s' is not a valid file or URL. %s", extraArgs.get(0), ex.getLocalizedMessage()), (Throwable)ex);
        }
        IModule module = MetaschemaCommands.loadModule(moduleUri, bindingContext);
        if (destination == null) {
            StringWriter stringWriter = new StringWriter();
            try (PrintWriter writer = new PrintWriter(stringWriter);){
                MermaidErDiagramGenerator.generate((IModule)module, (PrintWriter)writer);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(((Object)stringWriter).toString());
            }
        } else {
            try (BufferedWriter writer = Files.newBufferedWriter(destination, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                 PrintWriter printWriter = new PrintWriter(writer);){
                MermaidErDiagramGenerator.generate((IModule)module, (PrintWriter)printWriter);
            }
            catch (IOException ex) {
                throw new CommandExecutionException(ExitCode.IO_ERROR, (Throwable)ex);
            }
        }
    }
}

