/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.commands.MetaschemaCommands;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractTerminalCommand;
import gov.nist.secauto.metaschema.cli.processor.command.CommandExecutionException;
import gov.nist.secauto.metaschema.cli.processor.command.DefaultExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import gov.nist.secauto.metaschema.core.configuration.DefaultConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfigurationFeature;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.AutoCloser;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.schemagen.ISchemaGenerator;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class GenerateSchemaCommand
extends AbstractTerminalCommand {
    private static final Logger LOGGER = LogManager.getLogger(GenerateSchemaCommand.class);
    @NonNull
    private static final String COMMAND = "generate-schema";
    @NonNull
    private static final List<ExtraArgument> EXTRA_ARGUMENTS = (List)ObjectUtils.notNull(List.of(new DefaultExtraArgument("metaschema-module-file-or-URL", true), new DefaultExtraArgument("destination-schema-file", false)));
    private static final Option INLINE_TYPES_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("inline-types").desc("definitions declared inline will be generated as inline types").build());

    GenerateSchemaCommand() {
    }

    public String getName() {
        return COMMAND;
    }

    public String getDescription() {
        return "Generate a schema for the specified Module module";
    }

    public Collection<? extends Option> gatherOptions() {
        return List.of(MetaschemaCommands.OVERWRITE_OPTION, MetaschemaCommands.AS_SCHEMA_FORMAT_OPTION, INLINE_TYPES_OPTION);
    }

    public List<ExtraArgument> getExtraArguments() {
        return EXTRA_ARGUMENTS;
    }

    public ICommandExecutor newExecutor(CLIProcessor.CallingContext callingContext, CommandLine cmdLine) {
        return ICommandExecutor.using((CLIProcessor.CallingContext)callingContext, (CommandLine)cmdLine, this::executeCommand);
    }

    protected void executeCommand(@NonNull CLIProcessor.CallingContext callingContext, @NonNull CommandLine cmdLine) throws CommandExecutionException {
        ISchemaGenerator.SchemaFormat asFormat;
        Path destination;
        block19: {
            List extraArgs = cmdLine.getArgList();
            destination = extraArgs.size() > 1 ? MetaschemaCommands.handleDestination((String)ObjectUtils.requireNonNull((Object)((String)extraArgs.get(1))), cmdLine) : null;
            asFormat = MetaschemaCommands.getSchemaFormat(cmdLine, MetaschemaCommands.AS_SCHEMA_FORMAT_OPTION);
            DefaultConfiguration configuration = new DefaultConfiguration();
            if (cmdLine.hasOption(INLINE_TYPES_OPTION)) {
                configuration.enableFeature((IConfigurationFeature)SchemaGenerationFeature.INLINE_DEFINITIONS);
                if (ISchemaGenerator.SchemaFormat.JSON.equals((Object)asFormat)) {
                    configuration.disableFeature((IConfigurationFeature)SchemaGenerationFeature.INLINE_CHOICE_DEFINITIONS);
                } else {
                    configuration.enableFeature((IConfigurationFeature)SchemaGenerationFeature.INLINE_CHOICE_DEFINITIONS);
                }
            }
            IBindingContext bindingContext = MetaschemaCommands.newBindingContextWithDynamicCompilation();
            IModule module = MetaschemaCommands.loadModule((String)ObjectUtils.requireNonNull((Object)((String)extraArgs.get(0))), (URI)ObjectUtils.notNull((Object)GenerateSchemaCommand.getCurrentWorkingDirectory().toUri()), bindingContext);
            bindingContext.registerModule(module);
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Generating {} schema for '{}'.", (Object)asFormat.name(), extraArgs.get(0));
                }
                if (destination == null) {
                    OutputStream os = (OutputStream)ObjectUtils.notNull((Object)System.out);
                    try (OutputStream out = AutoCloser.preventClose((OutputStream)os);
                         OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
                        ISchemaGenerator.generateSchema((IModule)module, (Writer)writer, (ISchemaGenerator.SchemaFormat)asFormat, (IConfiguration)configuration);
                        break block19;
                    }
                }
                ISchemaGenerator.generateSchema((IModule)module, (Path)destination, (ISchemaGenerator.SchemaFormat)asFormat, (IConfiguration)configuration);
            }
            catch (IOException ex) {
                throw new CommandExecutionException(ExitCode.PROCESSING_ERROR, (Throwable)ex);
            }
        }
        if (destination != null && LOGGER.isInfoEnabled()) {
            LOGGER.info("Generated {} schema file: {}", (Object)asFormat.toString(), (Object)destination);
        }
    }
}

