/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands.metapath;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.cli.commands.MetaschemaCommands;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.command.AbstractTerminalCommand;
import gov.nist.secauto.metaschema.cli.processor.command.CommandExecutionException;
import gov.nist.secauto.metaschema.cli.processor.command.ExtraArgument;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import gov.nist.secauto.metaschema.core.metapath.DynamicContext;
import gov.nist.secauto.metaschema.core.metapath.ISequence;
import gov.nist.secauto.metaschema.core.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.core.metapath.StaticContext;
import gov.nist.secauto.metaschema.core.metapath.item.DefaultItemWriter;
import gov.nist.secauto.metaschema.core.metapath.item.IItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IModuleNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItemFactory;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.IBoundLoader;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class EvaluateMetapathCommand
extends AbstractTerminalCommand {
    private static final Logger LOGGER = LogManager.getLogger(EvaluateMetapathCommand.class);
    @NonNull
    private static final String COMMAND = "eval";
    @NonNull
    private static final Option EXPRESSION_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"e").longOpt("expression").required().hasArg().argName("EXPRESSION").desc("Metapath expression to execute").build());
    @NonNull
    private static final Option CONTENT_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"i").hasArg().argName("FILE_OR_URL").desc("Metaschema content instance resource").build());

    EvaluateMetapathCommand() {
    }

    public String getName() {
        return COMMAND;
    }

    public String getDescription() {
        return "Execute a Metapath expression against a document";
    }

    public Collection<? extends Option> gatherOptions() {
        return List.of(MetaschemaCommands.METASCHEMA_OPTIONAL_OPTION, CONTENT_OPTION, EXPRESSION_OPTION);
    }

    public List<ExtraArgument> getExtraArguments() {
        return CollectionUtil.emptyList();
    }

    public ICommandExecutor newExecutor(CLIProcessor.CallingContext callingContext, CommandLine cmdLine) {
        return ICommandExecutor.using((CLIProcessor.CallingContext)callingContext, (CommandLine)cmdLine, this::executeCommand);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Catching generic exception for CLI error handling")
    private void executeCommand(@NonNull CLIProcessor.CallingContext callingContext, @NonNull CommandLine cmdLine) throws CommandExecutionException {
        IBoundModule module = null;
        IModuleNodeItem item = null;
        if (cmdLine.hasOption(MetaschemaCommands.METASCHEMA_OPTIONAL_OPTION)) {
            IBindingContext bindingContext = MetaschemaCommands.newBindingContextWithDynamicCompilation();
            module = bindingContext.registerModule(MetaschemaCommands.loadModule(cmdLine, MetaschemaCommands.METASCHEMA_OPTIONAL_OPTION, (URI)ObjectUtils.notNull((Object)EvaluateMetapathCommand.getCurrentWorkingDirectory().toUri()), bindingContext));
            if (cmdLine.hasOption(CONTENT_OPTION)) {
                URI contentResource;
                IBoundLoader loader = bindingContext.newBoundLoader();
                String contentLocation = (String)ObjectUtils.requireNonNull((Object)cmdLine.getOptionValue(CONTENT_OPTION));
                try {
                    contentResource = MetaschemaCommands.getResourceUri(contentLocation, (URI)ObjectUtils.notNull((Object)EvaluateMetapathCommand.getCurrentWorkingDirectory().toUri()));
                }
                catch (URISyntaxException ex) {
                    throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("Unable to load content '%s'. %s", contentLocation, ex.getMessage()), (Throwable)ex);
                }
                try {
                    item = loader.loadAsNodeItem(contentResource);
                }
                catch (IOException ex) {
                    throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("Unable to load content '%s'. %s", contentLocation, ex.getMessage()), (Throwable)ex);
                }
            }
            item = INodeItemFactory.instance().newModuleNodeItem((IModule)module);
        } else if (cmdLine.hasOption(CONTENT_OPTION)) {
            throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("Must use '%s' to specify the Metaschema module.", CONTENT_OPTION.getArgName()));
        }
        StaticContext.Builder builder = StaticContext.builder();
        if (module != null) {
            builder.defaultModelNamespace(module.getXmlNamespace());
        }
        StaticContext staticContext = builder.build();
        String expression = cmdLine.getOptionValue(EXPRESSION_OPTION);
        if (expression == null) {
            throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("Must use '%s' to specify the Metapath expression.", EXPRESSION_OPTION.getArgName()));
        }
        try {
            MetapathExpression compiledMetapath = MetapathExpression.compile((String)expression, (StaticContext)staticContext);
            ISequence sequence = compiledMetapath.evaluate((IItem)item, new DynamicContext(staticContext));
            try (StringWriter stringWriter = new StringWriter();){
                try (PrintWriter writer = new PrintWriter(stringWriter);){
                    try (DefaultItemWriter itemWriter = new DefaultItemWriter(writer);){
                        itemWriter.writeSequence(sequence);
                    }
                    catch (IOException ex) {
                        throw new CommandExecutionException(ExitCode.IO_ERROR, (Throwable)ex);
                    }
                    catch (Exception ex) {
                        throw new CommandExecutionException(ExitCode.RUNTIME_ERROR, (Throwable)ex);
                    }
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(((Object)stringWriter).toString());
                }
            }
            catch (IOException ex) {
                throw new CommandExecutionException(ExitCode.IO_ERROR, (Throwable)ex);
            }
        }
        catch (RuntimeException ex) {
            throw new CommandExecutionException(ExitCode.PROCESSING_ERROR, (Throwable)ex);
        }
    }
}

