/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.commands.ConvertContentUsingModuleCommand;
import gov.nist.secauto.metaschema.cli.commands.GenerateDiagramCommand;
import gov.nist.secauto.metaschema.cli.commands.GenerateSchemaCommand;
import gov.nist.secauto.metaschema.cli.commands.ValidateContentUsingModuleCommand;
import gov.nist.secauto.metaschema.cli.commands.ValidateModuleCommand;
import gov.nist.secauto.metaschema.cli.commands.metapath.MetapathCommand;
import gov.nist.secauto.metaschema.cli.processor.ExitCode;
import gov.nist.secauto.metaschema.cli.processor.OptionUtils;
import gov.nist.secauto.metaschema.cli.processor.command.CommandExecutionException;
import gov.nist.secauto.metaschema.cli.processor.command.ICommand;
import gov.nist.secauto.metaschema.core.metapath.MetapathException;
import gov.nist.secauto.metaschema.core.model.IConstraintLoader;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.CustomCollectors;
import gov.nist.secauto.metaschema.core.util.DeleteOnShutdown;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.core.util.UriUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.Format;
import gov.nist.secauto.metaschema.databind.io.IBoundLoader;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingModuleLoader;
import gov.nist.secauto.metaschema.schemagen.ISchemaGenerator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public final class MetaschemaCommands {
    @NonNull
    public static final List<ICommand> COMMANDS = (List)ObjectUtils.notNull(List.of(new ValidateModuleCommand(), new GenerateSchemaCommand(), new GenerateDiagramCommand(), new ValidateContentUsingModuleCommand(), new ConvertContentUsingModuleCommand(), new MetapathCommand()));
    @NonNull
    public static final Option METASCHEMA_REQUIRED_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"m").hasArg().argName("FILE_OR_URL").required().desc("metaschema resource").numberOfArgs(1).build());
    @NonNull
    public static final Option METASCHEMA_OPTIONAL_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder((String)"m").hasArg().argName("FILE_OR_URL").desc("metaschema resource").numberOfArgs(1).build());
    @NonNull
    public static final Option OVERWRITE_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("overwrite").desc("overwrite the destination if it exists").build());
    @NonNull
    public static final Option TO_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("to").required().hasArg().argName("FORMAT").desc("convert to format: " + (String)Arrays.stream(Format.values()).map(Enum::name).collect(CustomCollectors.joiningWithOxfordComma((String)"or"))).numberOfArgs(1).build());
    @NonNull
    public static final Option AS_FORMAT_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("as").hasArg().argName("FORMAT").desc("source format: " + (String)Arrays.stream(Format.values()).map(Enum::name).collect(CustomCollectors.joiningWithOxfordComma((String)"or"))).numberOfArgs(1).build());
    @NonNull
    public static final Option AS_SCHEMA_FORMAT_OPTION = (Option)ObjectUtils.notNull((Object)Option.builder().longOpt("as").required().hasArg().argName("FORMAT").desc("schema format: " + (String)Arrays.stream(ISchemaGenerator.SchemaFormat.values()).map(Enum::name).collect(CustomCollectors.joiningWithOxfordComma((String)"or"))).numberOfArgs(1).build());

    @NonNull
    public static URI handleSource(@NonNull String pathOrUri, @NonNull URI currentWorkingDirectory) throws CommandExecutionException {
        try {
            return MetaschemaCommands.getResourceUri(pathOrUri, currentWorkingDirectory);
        }
        catch (URISyntaxException ex) {
            throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("Cannot load source '%s' as it is not a valid file or URI.", pathOrUri), (Throwable)ex);
        }
    }

    public static Path handleDestination(@NonNull String path, @NonNull CommandLine commandLine) throws CommandExecutionException {
        Path retval = Paths.get(path, new String[0]).toAbsolutePath();
        if (Files.exists(retval, new LinkOption[0])) {
            if (!commandLine.hasOption(OVERWRITE_OPTION)) {
                throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("The provided destination '%s' already exists and the '%s' option was not provided.", retval, OptionUtils.toArgument((Option)OVERWRITE_OPTION)));
            }
            if (!Files.isWritable(retval)) {
                throw new CommandExecutionException(ExitCode.IO_ERROR, String.format("The provided destination '%s' is not writable.", retval));
            }
        } else {
            Path parent = retval.getParent();
            if (parent != null) {
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                catch (IOException ex) {
                    throw new CommandExecutionException(ExitCode.INVALID_TARGET, (Throwable)ex);
                }
            }
        }
        return retval;
    }

    @NonNull
    public static Format getFormat(@NonNull CommandLine commandLine, @NonNull Option option) throws CommandExecutionException {
        String toFormatText = commandLine.getOptionValue(option);
        if (toFormatText == null) {
            throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("The '%s' argument was not provided.", option.hasLongOpt() ? "--" + option.getLongOpt() : "-" + option.getOpt()));
        }
        try {
            return Format.valueOf((String)toFormatText.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("Invalid '%s' argument. The format must be one of: %s.", option.hasLongOpt() ? "--" + option.getLongOpt() : "-" + option.getOpt(), Arrays.stream(Format.values()).map(Enum::name).collect(CustomCollectors.joiningWithOxfordComma((String)"or"))), (Throwable)ex);
        }
    }

    @NonNull
    public static ISchemaGenerator.SchemaFormat getSchemaFormat(@NonNull CommandLine commandLine, @NonNull Option option) throws CommandExecutionException {
        String toFormatText = commandLine.getOptionValue(option);
        if (toFormatText == null) {
            throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("Option '%s' not provided.", option.hasLongOpt() ? "--" + option.getLongOpt() : "-" + option.getOpt()));
        }
        try {
            return ISchemaGenerator.SchemaFormat.valueOf((String)toFormatText.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("Invalid '%s' argument. The schema format must be one of: %s.", option.hasLongOpt() ? "--" + option.getLongOpt() : "-" + option.getOpt(), Arrays.stream(ISchemaGenerator.SchemaFormat.values()).map(Enum::name).collect(CustomCollectors.joiningWithOxfordComma((String)"or"))), (Throwable)ex);
        }
    }

    @NonNull
    public static Format determineSourceFormat(@NonNull CommandLine commandLine, @NonNull Option option, @NonNull IBoundLoader loader, @NonNull URI resource) throws CommandExecutionException {
        if (commandLine.hasOption(option)) {
            return MetaschemaCommands.getFormat(commandLine, option);
        }
        try {
            return loader.detectFormat(resource);
        }
        catch (FileNotFoundException ex) {
            throw new CommandExecutionException(ExitCode.IO_ERROR, String.format("The provided source '%s' does not exist.", resource), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new CommandExecutionException(ExitCode.IO_ERROR, String.format("Unable to determine source format. Use '%s' to specify the format. %s", option.hasLongOpt() ? "--" + option.getLongOpt() : "-" + option.getOpt(), ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    @NonNull
    public static IModule loadModule(@NonNull CommandLine commandLine, @NonNull Option option, @NonNull URI currentWorkingDirectory, @NonNull IBindingContext bindingContext) throws CommandExecutionException {
        URI moduleUri;
        String moduleName = commandLine.getOptionValue(option);
        if (moduleName == null) {
            throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("Unable to determine the module to load. Use '%s' to specify the module.", option.hasLongOpt() ? "--" + option.getLongOpt() : "-" + option.getOpt()));
        }
        try {
            moduleUri = UriUtils.toUri((String)moduleName, (URI)currentWorkingDirectory);
        }
        catch (URISyntaxException ex) {
            throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("Cannot load module as '%s' is not a valid file or URL. %s", ex.getInput(), ex.getLocalizedMessage()), (Throwable)ex);
        }
        return MetaschemaCommands.loadModule(moduleUri, bindingContext);
    }

    @NonNull
    public static IModule loadModule(@NonNull String moduleResource, @NonNull URI currentWorkingDirectory, @NonNull IBindingContext bindingContext) throws CommandExecutionException {
        try {
            URI moduleUri = MetaschemaCommands.getResourceUri(moduleResource, currentWorkingDirectory);
            return MetaschemaCommands.loadModule(moduleUri, bindingContext);
        }
        catch (URISyntaxException ex) {
            throw new CommandExecutionException(ExitCode.INVALID_ARGUMENTS, String.format("Cannot load module as '%s' is not a valid file or URL. %s", ex.getInput(), ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    @NonNull
    public static IModule loadModule(@NonNull URI moduleResource, @NonNull IBindingContext bindingContext) throws CommandExecutionException {
        try {
            IBindingModuleLoader loader = bindingContext.newModuleLoader();
            loader.allowEntityResolution();
            return (IModule)loader.load(moduleResource);
        }
        catch (MetaschemaException | IOException ex) {
            throw new CommandExecutionException(ExitCode.PROCESSING_ERROR, ex);
        }
    }

    @NonNull
    public static URI getResourceUri(@NonNull String location, @NonNull URI currentWorkingDirectory) throws URISyntaxException {
        return UriUtils.toUri((String)location, (URI)currentWorkingDirectory);
    }

    @NonNull
    public static Set<IConstraintSet> loadConstraintSets(@NonNull CommandLine commandLine, @NonNull Option option, @NonNull URI currentWorkingDirectory) throws CommandExecutionException {
        LinkedHashSet constraintSets;
        if (commandLine.hasOption(option)) {
            String[] args;
            IConstraintLoader constraintLoader = IBindingContext.getConstraintLoader();
            constraintSets = new LinkedHashSet();
            for (String arg : args = commandLine.getOptionValues(option)) {
                assert (arg != null);
                try {
                    URI constraintUri = (URI)ObjectUtils.requireNonNull((Object)UriUtils.toUri((String)arg, (URI)currentWorkingDirectory));
                    constraintSets.addAll((Collection)constraintLoader.load(constraintUri));
                }
                catch (MetapathException | MetaschemaException | IOException | URISyntaxException ex) {
                    throw new CommandExecutionException(ExitCode.IO_ERROR, String.format("Unable to process constraint set '%s'. %s", arg, ex.getLocalizedMessage()), ex);
                }
            }
        } else {
            constraintSets = CollectionUtil.emptySet();
        }
        return constraintSets;
    }

    @NonNull
    public static Path newTempDir() throws IOException {
        Path retval = Files.createTempDirectory("metaschema-cli-", new FileAttribute[0]);
        DeleteOnShutdown.register((Path)retval);
        return (Path)ObjectUtils.notNull((Object)retval);
    }

    @NonNull
    public static IBindingContext newBindingContextWithDynamicCompilation() throws CommandExecutionException {
        return MetaschemaCommands.newBindingContextWithDynamicCompilation(CollectionUtil.emptySet());
    }

    @NonNull
    public static IBindingContext newBindingContextWithDynamicCompilation(@NonNull Set<IConstraintSet> constraintSets) throws CommandExecutionException {
        try {
            Path tempDir = MetaschemaCommands.newTempDir();
            return IBindingContext.builder().compilePath(tempDir).constraintSet(constraintSets).build();
        }
        catch (IOException ex) {
            throw new CommandExecutionException(ExitCode.RUNTIME_ERROR, String.format("Unable to initialize the binding context. %s", ex.getLocalizedMessage()), (Throwable)ex);
        }
    }

    private MetaschemaCommands() {
    }
}

