/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.commands.AbstractValidateContentCommand;
import gov.nist.secauto.metaschema.cli.commands.MetaschemaCommands;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.command.CommandExecutionException;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import gov.nist.secauto.metaschema.core.configuration.DefaultConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.core.model.validation.JsonSchemaContentValidator;
import gov.nist.secauto.metaschema.core.model.validation.XmlSchemaContentValidator;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.schemagen.ISchemaGenerator;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.xml.sax.SAXException;

class ValidateContentUsingModuleCommand
extends AbstractValidateContentCommand {
    @NonNull
    private static final String COMMAND = "validate-content";

    ValidateContentUsingModuleCommand() {
    }

    @Override
    public String getName() {
        return COMMAND;
    }

    public String getDescription() {
        return "Verify that the provided resource is well-formed and valid to the provided Module-based model.";
    }

    @Override
    public Collection<? extends Option> gatherOptions() {
        Collection<? extends Option> orig = super.gatherOptions();
        ArrayList<Object> retval = new ArrayList<Object>(orig.size() + 1);
        retval.addAll(orig);
        retval.add(MetaschemaCommands.METASCHEMA_REQUIRED_OPTION);
        return CollectionUtil.unmodifiableCollection(retval);
    }

    public ICommandExecutor newExecutor(CLIProcessor.CallingContext callingContext, CommandLine commandLine) {
        return new CommandExecutor(callingContext, commandLine);
    }

    private final class CommandExecutor
    extends AbstractValidateContentCommand.AbstractValidationCommandExecutor {
        private CommandExecutor(@NonNull CLIProcessor.CallingContext callingContext, CommandLine commandLine) {
            super(callingContext, commandLine);
        }

        @Override
        protected IBindingContext getBindingContext(@NonNull Set<IConstraintSet> constraintSets) throws CommandExecutionException {
            return MetaschemaCommands.newBindingContextWithDynamicCompilation(constraintSets);
        }

        @Override
        protected IModule getModule(CommandLine commandLine, IBindingContext bindingContext) throws CommandExecutionException {
            return MetaschemaCommands.loadModule(commandLine, MetaschemaCommands.METASCHEMA_REQUIRED_OPTION, (URI)ObjectUtils.notNull((Object)ValidateContentUsingModuleCommand.getCurrentWorkingDirectory().toUri()), bindingContext);
        }

        @Override
        protected IBindingContext.ISchemaValidationProvider getSchemaValidationProvider(IModule module, CommandLine commandLine, IBindingContext bindingContext) {
            return new ModuleValidationProvider(module);
        }
    }

    private static final class ModuleValidationProvider
    implements IBindingContext.ISchemaValidationProvider {
        @NonNull
        private final IModule module;

        public ModuleValidationProvider(@NonNull IModule module) {
            this.module = module;
        }

        public XmlSchemaContentValidator getXmlSchemas(@NonNull URL targetResource, @NonNull IBindingContext bindingContext) throws IOException, SAXException {
            DefaultConfiguration configuration = new DefaultConfiguration();
            try (StringWriter writer = new StringWriter();){
                XmlSchemaContentValidator xmlSchemaContentValidator;
                ISchemaGenerator.generateSchema((IModule)this.module, (Writer)writer, (ISchemaGenerator.SchemaFormat)ISchemaGenerator.SchemaFormat.XML, (IConfiguration)configuration);
                try (StringReader reader = new StringReader(writer.toString());){
                    xmlSchemaContentValidator = new XmlSchemaContentValidator((List)ObjectUtils.notNull(List.of(new StreamSource(reader))));
                }
                return xmlSchemaContentValidator;
            }
        }

        public JsonSchemaContentValidator getJsonSchema(@NonNull JSONObject json, @NonNull IBindingContext bindingContext) throws IOException {
            DefaultConfiguration configuration = new DefaultConfiguration();
            try (StringWriter writer = new StringWriter();){
                ISchemaGenerator.generateSchema((IModule)this.module, (Writer)writer, (ISchemaGenerator.SchemaFormat)ISchemaGenerator.SchemaFormat.JSON, (IConfiguration)configuration);
                JsonSchemaContentValidator jsonSchemaContentValidator = new JsonSchemaContentValidator(new JSONObject(new JSONTokener(writer.toString())));
                return jsonSchemaContentValidator;
            }
        }
    }
}

