/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.cli.commands;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.cli.commands.AbstractValidateContentCommand;
import gov.nist.secauto.metaschema.cli.commands.MetaschemaCommands;
import gov.nist.secauto.metaschema.cli.processor.CLIProcessor;
import gov.nist.secauto.metaschema.cli.processor.command.CommandExecutionException;
import gov.nist.secauto.metaschema.cli.processor.command.ICommandExecutor;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.core.model.util.JsonUtil;
import gov.nist.secauto.metaschema.core.model.validation.JsonSchemaContentValidator;
import gov.nist.secauto.metaschema.core.model.validation.XmlSchemaContentValidator;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetaschemaModelModule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import nl.talsmasoftware.lazy4j.Lazy;
import org.apache.commons.cli.CommandLine;
import org.json.JSONObject;
import org.xml.sax.SAXException;

class ValidateModuleCommand
extends AbstractValidateContentCommand {
    @NonNull
    private static final String COMMAND = "validate";

    ValidateModuleCommand() {
    }

    @Override
    public String getName() {
        return COMMAND;
    }

    public String getDescription() {
        return "Validate that the specified Module is well-formed and valid to the Module model";
    }

    public ICommandExecutor newExecutor(CLIProcessor.CallingContext callingContext, CommandLine commandLine) {
        return new CommandExecutor(callingContext, commandLine);
    }

    private final class CommandExecutor
    extends AbstractValidateContentCommand.AbstractValidationCommandExecutor {
        private final Lazy<ValidationProvider> validationProvider;

        private CommandExecutor(@NonNull CLIProcessor.CallingContext callingContext, CommandLine commandLine) {
            super(callingContext, commandLine);
            this.validationProvider = Lazy.lazy(() -> new ValidationProvider());
        }

        @Override
        protected IBindingContext getBindingContext(Set<IConstraintSet> constraintSets) throws CommandExecutionException {
            return MetaschemaCommands.newBindingContextWithDynamicCompilation(constraintSets);
        }

        @Override
        protected IModule getModule(CommandLine commandLine, IBindingContext bindingContext) {
            return bindingContext.registerModule(MetaschemaModelModule.class);
        }

        @Override
        protected IBindingContext.ISchemaValidationProvider getSchemaValidationProvider(IModule module, CommandLine commandLine, IBindingContext bindingContext) {
            return (IBindingContext.ISchemaValidationProvider)ObjectUtils.notNull((Object)((ValidationProvider)this.validationProvider.get()));
        }
    }

    private static final class ValidationProvider
    implements IBindingContext.ISchemaValidationProvider {
        private ValidationProvider() {
        }

        public XmlSchemaContentValidator getXmlSchemas(@NonNull URL targetResource, @NonNull IBindingContext bindingContext) throws IOException, SAXException {
            try (InputStream is = this.getClass().getResourceAsStream("/schema/xml/metaschema-model_schema.xsd");){
                LinkedList<StreamSource> sources = new LinkedList<StreamSource>();
                sources.add(new StreamSource((InputStream)ObjectUtils.requireNonNull((Object)is, (String)"Unable to load '/schema/xml/metaschema.xsd' on the classpath")));
                XmlSchemaContentValidator xmlSchemaContentValidator = new XmlSchemaContentValidator(sources);
                return xmlSchemaContentValidator;
            }
        }

        public JsonSchemaContentValidator getJsonSchema(@NonNull JSONObject json, @NonNull IBindingContext bindingContext) throws IOException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/schema/json/metaschema-model_schema.json"), StandardCharsets.UTF_8));){
                JsonSchemaContentValidator jsonSchemaContentValidator = new JsonSchemaContentValidator(JsonUtil.toJsonObject((Reader)reader));
                return jsonSchemaContentValidator;
            }
        }
    }
}

